﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Collections;

    public class MultiLabel : Control
    {
        private int linechars;
        private int linecount;
        public int LineH;
        public int ScrollW;
        public string Text;

        public MultiLabel(string text, int t, int l, int h, int w, int lh, int sw) : base(t, l, h, w)
        {
            base.DefaultSettings["line"] = 0;
            this.LineH = lh;
            this.ScrollW = sw;
            this.Text = text;
            this.linechars = (w * 50) / 100;
            this.linecount = h / lh;
        }

        public override ArrayList GetElements(Connection c)
        {
            int num2;
            int num = (int) base.GetSettings(c)["line"];
            ArrayList list = new ArrayList();
            ArrayList list2 = new ArrayList(ISRM.Parse(this.Text, null, c.Lingo).Split("\n".ToCharArray()));
            for (num2 = 0; num2 < list2.Count; num2++)
            {
                int num3;
                string str = (string) list2[num2];
                if ((str.Length > this.linechars) && ((num3 = str.IndexOf(" ", this.linechars)) >= 0))
                {
                    list2.Insert(num2 + 1, str.Substring(num3 + 1));
                    list2[num2] = str.Substring(0, num3);
                }
            }
            for (num2 = num; (num2 < (num + this.linecount)) && (num2 < list2.Count); num2++)
            {
                list.Add(new Element(c, list2[num2].ToString(), ButtonStyleFlagsEnum.ISB_LEFT, base.T + ((num2 - num) * this.LineH), base.L, this.LineH, base.W - this.ScrollW, this, this));
            }
            list.Add(new Element(c, "", ButtonStyleFlagsEnum.ISB_DARK, base.T, base.L, base.H, base.W - this.ScrollW, this, this));
            if (list2.Count > this.linecount)
            {
                list.Add(new Element(c, "", ButtonStyleFlagsEnum.ISB_DARK, base.T, base.L + (base.W - this.ScrollW), base.H, this.ScrollW, this, this));
                char ch = 'Џ';
                list.Add(new Element(c, ch.ToString(), ButtonStyleFlagsEnum.ISB_CLICK | ButtonStyleFlagsEnum.ISB_DARK, base.T, base.L + (base.W - this.ScrollW), this.LineH, this.ScrollW, this, this, new ControlDelegate(this.LineUp)));
                ch = 'ђ';
                list.Add(new Element(c, ch.ToString(), ButtonStyleFlagsEnum.ISB_CLICK | ButtonStyleFlagsEnum.ISB_DARK, base.T + (base.H - this.LineH), base.L + (base.W - this.ScrollW), this.LineH, this.ScrollW, this, this, new ControlDelegate(this.LineDown)));
            }
            return list;
        }

        public void LineDown(Control control, Connection connection)
        {
            int num = (int) base.GetSettings(connection)["line"];
            base.GetSettings(connection)["line"] = num + this.linecount;
        }

        public void LineUp(Control control, Connection connection)
        {
            int num = (int) base.GetSettings(connection)["line"];
            if ((num - this.linecount) >= 0)
            {
                base.GetSettings(connection)["line"] = num - this.linecount;
            }
        }
    }
}

