﻿namespace ISRM
{
    using System;
    using System.Collections;
    using System.Timers;

    public class MessageSystem
    {
        private MessageDelegate Display;
        private int i;
        public ArrayList list;
        private Timer timer;

        public MessageSystem(MessageDelegate Out)
        {
            this.i = 0;
            this.Display = Out;
            this.list = new ArrayList();
            this.timer = new Timer(2000.0);
            this.timer.Enabled = true;
            this.timer.Elapsed += new ElapsedEventHandler(this.Show);
        }

        public MessageSystem(MessageSystem ms, MessageDelegate Out) : this(Out)
        {
            this.list.AddRange(ms.list);
        }

        public void Add(Message m)
        {
            if ((m.Text.Length > 0) && (m.ID != 0))
            {
                int index = this.LastOf(m.ID);
                if (index < 0)
                {
                    this.list.Add(m);
                }
                else
                {
                    this.list.Insert(index, m);
                }
            }
        }

        private int LastOf(byte d)
        {
            for (int i = 0; i < this.list.Count; i++)
            {
                if ((((Message) this.list[i]).ID == d) && (((i + 1) == this.list.Count) || (((Message) this.list[i + 1]).ID != d)))
                {
                    return i;
                }
            }
            return -1;
        }

        public int Remove(byte d)
        {
            int num = -1;
            int count = this.list.Count;
            for (int i = 0; i < count; i++)
            {
                if (((Message) this.list[i]).ID == d)
                {
                    this.list.RemoveAt(i);
                    if (num < 0)
                    {
                        num = i;
                    }
                    i--;
                    count--;
                }
            }
            return num;
        }

        public void Replace(Message m)
        {
            if (m.ID != 0)
            {
                int index = this.Remove(m.ID);
                if (m.Text.Length > 0)
                {
                    if (index >= 0)
                    {
                        this.list.Insert(index, m);
                    }
                    else
                    {
                        this.list.Add(m);
                    }
                }
            }
        }

        private void Show(object source, EventArgs e)
        {
            if (this.list.Count > 0)
            {
                Message m = (Message) this.list[this.i];
                this.Display(m);
                if (m.Expire > 0)
                {
                    m.Expire--;
                    if (m.Expire == 0)
                    {
                        this.list.Remove(m);
                    }
                }
                this.i++;
                this.i = this.i % this.list.Count;
            }
        }
    }
}

