﻿namespace ISRM
{
    using System;
    using System.Collections;

    public class Menu : ArrayList
    {
        public DrawDecider Draw;
        public bool Enabled = true;
        public string Name;
        public NameDelegate Thing;

        public Menu(string s)
        {
            this.Name = s;
        }

        public void Add(Menu m)
        {
            if (m != null)
            {
                NavigateButton button = new NavigateButton(m.Name) {
                    Target = m
                };
                if (m.Thing != null)
                {
                    button.Thing = (NameDelegate) Delegate.Combine(button.Thing, m.Thing);
                }
                if (m.Draw != null)
                {
                    button.Draw = (DrawDecider) Delegate.Combine(button.Draw, m.Draw);
                }
                this.Add(button);
                NavigateButton button2 = new NavigateButton("mn_back") {
                    Target = this
                };
                m.Insert(0, button2);
            }
        }
    }
}

