﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Collections;
    using System.Collections.Generic;

    public class ListBox : Control
    {
        public string[] Columns;
        public int[] ColumnW;
        public bool IsScrollable;
        public int LineCount;
        public int LineH;
        public List<string[]> Rows;
        public int ScrollW;

        public ListBox(List<string[]> rows, string[] columns, int[] columnw, bool scroll, int n, int lh, int sw, int t, int l)
        {
            base.DefaultSettings["line"] = 0;
            this.IsScrollable = scroll;
            this.Rows = rows;
            this.Columns = columns;
            this.ColumnW = columnw;
            this.LineCount = n;
            this.LineH = lh;
            this.ScrollW = sw;
            base.T = t;
            base.L = l;
            base.H = lh * (n + 1);
            base.W = 0;
            foreach (int num in this.ColumnW)
            {
                base.W += num;
            }
        }

        public override ArrayList GetElements(Connection c)
        {
            int num = (int) base.GetSettings(c)["line"];
            ArrayList list = new ArrayList();
            int num2 = 0;
            int index = 0;
            while (index < this.ColumnW.Length)
            {
                list.Add(new Element(c, ISRM.Parse(this.Columns[index], null, c.Lingo), ButtonStyleFlagsEnum.ISB_DARK | ButtonStyleFlagsEnum.ISB_LEFT, base.T, base.L + num2, this.LineH, this.ColumnW[index], this, this));
                num2 += this.ColumnW[index];
                index++;
            }
            for (int i = 0; ((i + num) < this.Rows.Count) && (i < this.LineCount); i++)
            {
                string[] strArray = this.Rows[i + num];
                num2 = 0;
                for (index = 0; (index < this.ColumnW.Length) && (index < strArray.Length); index++)
                {
                    list.Add(new Element(c, strArray[index], ButtonStyleFlagsEnum.ISB_LEFT, base.T + ((i + 1) * this.LineH), base.L + num2, this.LineH, this.ColumnW[index], this, this));
                    num2 += this.ColumnW[index];
                }
            }
            list.Add(new Element(c, "", ButtonStyleFlagsEnum.ISB_DARK, base.T, base.L, base.H, base.W, this, this));
            if (this.IsScrollable && (this.Rows.Count > this.LineCount))
            {
                list.Add(new Element(c, "", ButtonStyleFlagsEnum.ISB_DARK, base.T, base.L + base.W, base.H, this.ScrollW, this, this));
                char ch = 'Џ';
                list.Add(new Element(c, ch.ToString(), ButtonStyleFlagsEnum.ISB_CLICK | ButtonStyleFlagsEnum.ISB_DARK, base.T, base.L + base.W, this.LineH, this.ScrollW, this, this, new ControlDelegate(this.LineUp)));
                list.Add(new Element(c, Convert.ToChar(0x452).ToString(), ButtonStyleFlagsEnum.ISB_CLICK | ButtonStyleFlagsEnum.ISB_DARK, base.T + (base.H - this.LineH), base.L + base.W, this.LineH, this.ScrollW, this, this, new ControlDelegate(this.LineDown)));
            }
            return list;
        }

        public void LineDown(Control control, Connection connection)
        {
            int num = ((int) base.GetSettings(connection)["line"]) + this.LineCount;
            base.GetSettings(connection)["line"] = num;
        }

        public void LineUp(Control control, Connection connection)
        {
            int num = ((int) base.GetSettings(connection)["line"]) - this.LineCount;
            if (num >= 0)
            {
                base.GetSettings(connection)["line"] = num;
            }
        }
    }
}

