﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using LfsInSimLib.IS_Packets;
    using LfsInSimLib.IS_SubPackets;
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.Configuration;
    using System.IO;
    using System.Reflection;
    using System.Resources;
    using System.Threading;
    using System.Timers;

    public class ISRM
    {
        private Cancellor Agreement;
        private int AgreementTime;
        public string Car;
        public cList Connections = new cList();
        public static Language DefaultLanguage;
        private System.Timers.Timer DingDong = new System.Timers.Timer(200.0);
        private ushort Finish;
        public IS_RSTFlagsEnum Flags;
        private List<Language> Languages = new List<Language>();
        public int Laps;
        public int LapsDone;
        private object locker = new object();
        private Bunch LS = new Bunch();
        public Menu MainMenu;
        public byte MessageIDs = 0;
        public List<module> Modules = new List<module>();
        public ushort NumNodes;
        private OutDelegate Out;
        public pList Players = new pList();
        public pList PlayersPits = new pList();
        public PosList Positions = new PosList();
        public string Product;
        public int Quals;
        public List<Control> Screen = new List<Control>();
        public SessionType Session;
        private SBool ShowAgreement = new SBool(false);
        private SBool ShowHelp = new SBool(false);
        private ushort Split1;
        private ushort Split2;
        private ushort Split3;
        public string Track;
        private SBool VotingFlag = new SBool(false);
        public byte Weather;
        public WindEnum Wind;

        public ISRM(OutDelegate newOut, string pw)
        {
            string str = "EN";
            this.Out = newOut;
            IS_ISI m = new IS_ISI {
                ReqI = 5,
                UDPPort = 0,
                Flags = IS_ISIFlagsEnum.ISF_MCI,
                Prefix = 0,
                Interval = 50,
                Admin = pw,
                IName = "ISRM"
            };
            this.Out(m);
            IS_TINY is_tiny = new IS_TINY {
                ReqI = 5,
                SubT = IS_TINYTypeEnum.TINY_NCN
            };
            this.Out(is_tiny);
            is_tiny.ReqI = 5;
            is_tiny.SubT = IS_TINYTypeEnum.TINY_NPL;
            this.Out(is_tiny);
            is_tiny.ReqI = 5;
            is_tiny.SubT = IS_TINYTypeEnum.TINY_REO;
            this.Out(is_tiny);
            is_tiny.ReqI = 5;
            is_tiny.SubT = IS_TINYTypeEnum.TINY_RST;
            this.Out(is_tiny);
            this.ShowAgreement.isTrue = SConvert.ToBoolean(ConfigurationManager.AppSettings["show_agreement"]);
            this.AgreementTime = Convert.ToInt32(ConfigurationManager.AppSettings["agreement_time"]);
            this.VotingFlag.isTrue = SConvert.ToBoolean(ConfigurationManager.AppSettings["voting"]);
            DirectoryInfo info = new DirectoryInfo("Language");
            foreach (FileInfo info2 in info.GetFiles("*.resx"))
            {
                Language item = new Language();
                ResXResourceReader reader = new ResXResourceReader(info2.FullName);
                foreach (DictionaryEntry entry in reader)
                {
                    item.Add(entry.Key, entry.Value);
                }
                reader.Close();
                item.Name = info2.Name.Replace(info2.Extension, "");
                if (item.Name == str)
                {
                    DefaultLanguage = item;
                }
                item.FullName = (string) item["mn_cur_lang"];
                this.Languages.Add(item);
            }
            this.Languages.Remove(DefaultLanguage);
            this.Languages.Insert(0, DefaultLanguage);
            foreach (Language language2 in this.Languages)
            {
                int index = this.Languages.IndexOf(language2);
                Button button = new Button(language2.FullName, new ControlDelegate(this.LangClick), 60 + (index * 15), 70, 15, 50);
                this.LS.List.Add(button);
            }
            this.MainMenu = new Menu("mn_menu");
            Menu menu = new Menu("mn_options") {
                Draw = new DrawDecider(Control.IsAdmin)
            };
            menu.Add(new CheckBox(this.ShowAgreement, "mn_showagr"));
            menu.Add(new CheckBox(this.ShowHelp, "mn_showhelp"));
            menu.Add(new CheckBox(this.VotingFlag, "mn_voting"));
            this.MainMenu.Add(menu);
            Button button2 = new Button("mn_help", new ControlDelegate(this.ViewHelp));
            button2.DrawSBool(this.ShowHelp);
            this.MainMenu.Add(button2);
            Button b = new Button("mn_ok", new ControlDelegate(this.Agree), 170, 80, 20, 40) {
                Draw = new DrawDecider(this.AgreeWait)
            };
            this.Agreement = new Cancellor(new MultiLabel("mn_agreement", 40, 50, 120, 110, 10, 10), b);
        }

        public void Admin_MS(string str)
        {
            this.Send_MST("/" + str);
        }

        private void Agree(Control control, Connection connection)
        {
            connection.Agree = true;
            connection.Screen.Remove(this.Agreement);
        }

        private bool AgreeWait(Connection connection)
        {
            return (((DateTime.Now - connection.Connected) > TimeSpan.FromSeconds((double) this.AgreementTime)) || !this.ShowAgreement.isTrue);
        }

        public void Broadcast(Message m)
        {
            if (m.ID != 0)
            {
                foreach (Player player in this.Players)
                {
                    player.Messages.Replace(m);
                }
            }
            if (m.Text.Length > 0)
            {
                this.Send_MTC(m);
            }
        }

        public void Broadcast(string str)
        {
            this.Broadcast(new Message(str, 0));
        }

        private void ChangeLanguage(Control control, Connection connection)
        {
            int num = (this.Languages.IndexOf(connection.Lingo) + 1) % this.Languages.Count;
            connection.Lingo = this.Languages[num];
        }

        private void ConvertNode(ref ushort node)
        {
            node = (ushort) (((node + this.NumNodes) - this.Finish) % this.NumNodes);
        }

        public static void FileAdd(string[] x, string path)
        {
            StreamWriter writer = new StreamWriter(new FileStream(path, FileMode.Append, FileAccess.Write));
            for (int i = 0; i < x.Length; i++)
            {
                string str = x[i];
                writer.Write(str.Replace("'", "`"));
                if (i != (x.Length - 1))
                {
                    writer.Write("'");
                }
            }
            writer.WriteLine();
            writer.Close();
        }

        public static void FileRead(List<string[]> List, string path)
        {
            string str;
            StreamReader reader = new StreamReader(new FileStream(path, FileMode.OpenOrCreate, FileAccess.Read));
            while ((str = reader.ReadLine()) != null)
            {
                if (str.Length > 0)
                {
                    List.Add(str.Split("'".ToCharArray()));
                }
            }
            reader.Close();
        }

        public static void FileWrite(List<string[]> List, string path)
        {
            StreamWriter writer = new StreamWriter(new FileStream(path, FileMode.Create, FileAccess.Write));
            foreach (string[] strArray in List)
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    string str = strArray[i];
                    writer.Write(str.Replace("'", "`"));
                    if (i != (strArray.Length - 1))
                    {
                        writer.Write("'");
                    }
                }
                writer.WriteLine();
            }
            writer.Close();
        }

        public byte GetID()
        {
            this.MessageIDs = (byte) (this.MessageIDs + 1);
            return this.MessageIDs;
        }

        public bool HasModule(string s)
        {
            foreach (module module in this.Modules)
            {
                if (module.ToString() == s)
                {
                    return true;
                }
            }
            return false;
        }

        public void In(object message)
        {
            object obj2;
            Monitor.Enter(obj2 = this.locker);
            try
            {
                Connection connection;
                Player player;
                Connection current;
                int num;
                Element element;
                //IEnumerator enumerator;
                if (message is IS_VER)
                {
                    IS_VER is_ver = (IS_VER) message;
                    this.Product = is_ver.Product;
                    this.Init();
                }
                if (message is IS_RST)
                {
                    IS_RST is_rst = (IS_RST) message;
                    this.UpdateTrackInfo(is_rst.RaceLaps, is_rst.QualMins, is_rst.Track, is_rst.Weather, is_rst.Wind);
                    this.UpdateNodeInfo(is_rst.NumNodes, is_rst.Split1, is_rst.Split2, is_rst.Split3, is_rst.NumNodes);
                }
                if (message is IS_STA)
                {
                    IS_STA is_sta = (IS_STA) message;
                    this.UpdateTrackInfo(is_sta.RaceLaps, is_sta.QualMins, is_sta.Track, is_sta.Weather, is_sta.Wind);
                }
                if (message is IS_NCN)
                {
                    IS_NCN is_ncn = (IS_NCN) message;
                    if (this.Connections.ID(is_ncn.UCID) == null)
                    {
                        connection = new Connection(is_ncn.UCID, is_ncn.UName, is_ncn.PName, is_ncn.Admin, DefaultLanguage);
                        this.Connections.Add(connection);
                        connection.CurrentMenu = this.MainMenu;
                        if (this.Languages.Count > 1)
                        {
                            connection.Screen.Add(this.LS);
                        }
                        else
                        {
                            this.LangClick(null, connection);
                        }
                        if (!(this.ShowAgreement.isTrue && (this.AgreementTime != 0)))
                        {
                            connection.Agree = true;
                        }
                        this.ScreenDraw(connection);
                    }
                }
                if (message is IS_NPL)
                {
                    IS_NPL is_npl = (IS_NPL) message;
                    if (this.Players.ID(is_npl.PLID) != null)
                    {
                        this.PlayersPits.RemoveID(is_npl.PLID);
                    }
                    else if (this.PlayersPits.ID(is_npl.PLID) != null)
                    {
                        player = this.PlayersPits.ID(is_npl.PLID);
                        this.Players.Add(player);
                        this.Connections.ID(is_npl.UCID).Players.Add(player);
                        this.PlayersPits.RemoveID(is_npl.PLID);
                    }
                    else
                    {
                        player = new Player(this.Connections.ID(is_npl.UCID), is_npl.PLID, is_npl.PName, this);
                        this.Players.Add(player);
                        this.Connections.ID(is_npl.UCID).Players.Add(player);
                        if (!this.Connections.ID(is_npl.UCID).Agree)
                        {
                            this.Admin_MS("spec " + player.PName);
                        }
                    }
                }
                if (message is IS_PLL)
                {
                    IS_PLL is_pll = (IS_PLL) message;
                    /*
                    using (enumerator = this.Connections.GetEnumerator())
                    {
                        while (enumerator.MoveNext())
                        {
                            current = (Connection) enumerator.Current;
                            current.Players.RemoveID(is_pll.PLID);
                        }
                    }
                     */
                    this.Players.RemoveID(is_pll.PLID);
                    this.PlayersPits.RemoveID(is_pll.PLID);
                }
                if (message is IS_CNL)
                {
                    IS_CNL is_cnl = (IS_CNL) message;
                    this.Connections.RemoveID(is_cnl.UCID);
                }
                if (message is IS_CPR)
                {
                    IS_CPR is_cpr = (IS_CPR) message;
                    current = this.Connections.ID(is_cpr.UCID);
                    if (current.Plyr != null)
                    {
                        current.Plyr.PName = is_cpr.PName;
                    }
                    current.PName = is_cpr.PName;
                }
                if (message is IS_TOC)
                {
                    IS_TOC is_toc = (IS_TOC) message;
                    player = this.Connections.ID(is_toc.OldUCID).Players.ID(is_toc.PLID);
                    this.Connections.ID(is_toc.OldUCID).Players.Remove(player);
                    this.Connections.ID(is_toc.NewUCID).Players.Add(player);
                }
                if (message is IS_PLP)
                {
                    IS_PLP is_plp = (IS_PLP) message;
                    if ((this.Players.ID(is_plp.PLID) != null) && (this.PlayersPits.ID(is_plp.PLID) == null))
                    {
                        this.PlayersPits.Add(this.Players.ID(is_plp.PLID));
                    }
                    /*
                    using (enumerator = this.Connections.GetEnumerator())
                    {
                        while (enumerator.MoveNext())
                        {
                            current = (Connection) enumerator.Current;
                            current.Players.RemoveID(is_plp.PLID);
                        }
                    }
                    */
                    this.Players.RemoveID(is_plp.PLID);
                }
                if (message is IS_MCI)
                {
                    IS_MCI is_mci = (IS_MCI) message;
                    for (num = 0; num < is_mci.NumC; num++)
                    {
                        this.Update(is_mci.Info[num]);
                    }
                }
                if (message is IS_PEN)
                {
                    IS_PEN is_pen = (IS_PEN) message;
                    this.Players.ID(is_pen.PLID).Penalty = is_pen.NewPen;
                }
                if (message is IS_LAP)
                {
                    IS_LAP is_lap = (IS_LAP) message;
                    if (this.Positions.PLID(is_lap.PLID) == 1)
                    {
                        this.UpdateLap(is_lap.LapsDone);
                    }
                }
                if (message is IS_III)
                {
                    IS_III is_iii = (IS_III) message;
                    string str = "";
                    for (num = 0; num < is_iii.Msg.Length; num++)
                    {
                        str = str + "(" + ((int) is_iii.Msg[num]).ToString() + ")";
                    }
                    Console.WriteLine(str);
                    current = this.Connections.ID(is_iii.UCID);
                    if (current.Admin && (is_iii.Msg == "debug"))
                    {
                        this.StartDebug(new Exception("Exception triggered by admin."));
                    }
                    if ((current.Players.Count > 0) && (is_iii.Msg == "position"))
                    {
                        this.Send_MTC(string.Format("X:{0} Y:{1} Z:{2}", current.Plyr.X, current.Plyr.Y, current.Plyr.Z), current);
                    }
                }
                if (message is IS_VTN)
                {
                    IS_VTN is_vtn = (IS_VTN) message;
                    if (!(((is_vtn.Action != VoteEnum.VOTE_RESTART) || this.VotingFlag.isTrue) || this.Connections.ID(is_vtn.UCID).Admin))
                    {
                        IS_TINY m = new IS_TINY {
                            SubT = IS_TINYTypeEnum.TINY_VTC
                        };
                        this.Out(m);
                    }
                }
                if (message is IS_TINY)
                {
                    IS_TINY is_tiny2 = (IS_TINY) message;
                    if (is_tiny2.SubT == IS_TINYTypeEnum.TINY_REN)
                    {
                        this.Session = SessionType.Nothing;
                    }
                }
                if (message is IS_BFN)
                {
                    IS_BFN is_bfn = (IS_BFN) message;
                    connection = this.Connections.ID(is_bfn.UCID);
                    if ((is_bfn.SubT == IS_BFNTypeEnum.BFN_REQUEST) && connection.Agree)
                    {
                        connection.ShowMenu = true;
                    }
                    if ((is_bfn.SubT == IS_BFNTypeEnum.BFN_CLEAR) || (is_bfn.SubT == IS_BFNTypeEnum.BFN_USER_CLEAR))
                    {
                        if (connection.Agree)
                        {
                            connection.ShowMenu = !connection.ShowMenu;
                        }
                        connection.ElementList.Clear();
                    }
                    this.ScreenDraw();
                }
                if (message is IS_BTC)
                {
                    IS_BTC is_btc = (IS_BTC) message;
                    connection = this.Connections.ID(is_btc.UCID);
                    element = connection.ElementList.ID(is_btc.ClickID);
                    if ((element != null) && (element.Event != null))
                    {
                        element.Event(element.C, connection);
                    }
                    this.ScreenDraw();
                }
                if (message is IS_BTT)
                {
                    IS_BTT is_btt = (IS_BTT) message;
                    connection = this.Connections.ID(is_btt.UCID);
                    element = connection.ElementList.ID(is_btt.ClickID);
                    if (element.Event != null)
                    {
                        element.Event(element.C, connection);
                    }
                    this.ScreenDraw();
                }
                foreach (module module in this.Modules)
                {
                    module.In(message);
                    module.Update();
                }
            }
            catch (Exception exception)
            {
                this.StartDebug(exception);
            }
            finally
            {
                Monitor.Exit(obj2);
            }
        }

        public void Init()
        {
            StreamWriter writer = new StreamWriter(new FileStream("debug.log", FileMode.Append, FileAccess.Write));
            writer.WriteLine(string.Format("***Launch@{0}***", DateTime.Now));
            writer.Close();
            this.DingDong.Elapsed += new ElapsedEventHandler(this.Tick);
            this.DingDong.Start();
            if (SConvert.ToBoolean(ConfigurationManager.AppSettings["mod_drag"]))
            {
                this.LoadModule(new mod_drag());
            }
            this.MainMenu.Add(new Button("mn_cur_lang", new ControlDelegate(this.ChangeLanguage)));
            Menu m = new Menu("mn_about");
            Version version = Assembly.GetExecutingAssembly().GetName().Version;
            m.Add(new Label(string.Format("^3ISRM {0}.{1}", version.Major, version.Minor)));
            m.Add(new Label("mn_author"));
            m.Add(new Label("kuhnoo@gmail.com"));
            m.Add(new Label("mn_modload"));
            foreach (module module in this.Modules)
            {
                m.Add(new Label(module.ToString()));
            }
            this.MainMenu.Add(m);
        }

        private ushort kph2lfs(float kph)
        {
            return (ushort) ((kph / 360f) * 32768f);
        }

        public void LangClick(Control q, Connection c)
        {
            if (q != null)
            {
                foreach (Language language in this.Languages)
                {
                    if (language.FullName == ((Button) q).Name)
                    {
                        c.Lingo = language;
                    }
                }
                this.Send_MTC(new Message("mn_welcome", 0, c.PName), c);
                c.Screen.Remove(this.LS);
            }
            if (this.ShowAgreement.isTrue)
            {
                c.Screen.Add(this.Agreement);
            }
        }

        private void LoadModule(module m)
        {
            m.Parent = this;
            if (m.moduleMenu != null)
            {
                this.MainMenu.Add(m.moduleMenu);
            }
            this.Modules.Add(m);
        }

        public static string Parse(string s, object o, Language l)
        {
            if (s == null)
            {
                return "";
            }
            if (l[s] != null)
            {
                s = (string) l[s];
            }
            else if (DefaultLanguage[s] != null)
            {
                s = (string) DefaultLanguage[s];
            }
            return string.Format(s, o);
        }

        public void ScreenDraw()
        {
            ArrayList list = new ArrayList();
            foreach (Control control in this.Screen)
            {
                if ((DateTime.Now - control.Created) > control.Expire)
                {
                    list.Add(control);
                }
            }
            foreach (Control control in list)
            {
                this.Screen.Remove(control);
                control.Created = DateTime.MaxValue;
            }
            foreach (Connection connection in this.Connections)
            {
                this.ScreenDraw(connection);
            }
        }

        public void ScreenDraw(Connection connection)
        {
            lock (this)
            {
                ArrayList elements;
                Element current;
                eList list = new eList();
                foreach (Control control in this.Screen)
                {
                    elements = control.GetElements(connection);
                    /*
                    using (IEnumerator enumerator2 = elements.GetEnumerator())
                    {
                        while (enumerator2.MoveNext())
                        {
                            current = (Element) enumerator2.Current;
                            list.Add(current);
                        }
                    }
                    */
                }
                foreach (Control control in connection.Screen)
                {
                    elements = control.GetElements(connection);
                    /*
                    using (IEnumerator enumerator3 = elements.GetEnumerator())
                    {
                        while (enumerator3.MoveNext())
                        {
                            current = (Element) enumerator3.Current;
                            list.Add(current);
                        }
                    }
                    */
                }
                for (int i = list.Count - 1; i >= 0; i--)
                {
                    current = (Element) list[i];
                    if (((current == null) || (current.P.W <= 0)) || (current.P.H <= 0))
                    {
                        list.RemoveAt(i);
                    }
                }
                int t = 70;
                int l = 0;
                if (connection.ShowMenu)
                {
                    foreach (Control control in connection.CurrentMenu)
                    {
                        if (control.Draw(connection))
                        {
                            elements = control.GetElements(connection, t, l);
                            foreach (Element element in elements)
                            {
                                if (element != null)
                                {
                                    list.Add(element);
                                }
                            }
                            t += control.T;
                            l += control.L;
                        }
                    }
                }
                foreach (Element element in list)
                {
                    ArrayList list3 = new ArrayList();
                    foreach (Element element2 in connection.ElementList)
                    {
                        if (eList.ButtonsEqual(element.P, element2.P))
                        {
                            element.P.ClickID = element2.P.ClickID;
                            list3.Add(element2);
                        }
                    }
                    foreach (Element element2 in list3)
                    {
                        connection.ElementList.Remove(element2);
                    }
                }
                foreach (Element element in list)
                {
                    if (element.P.ClickID == 0xff)
                    {
                        element.P.ClickID = list.IssueId();
                        this.Out(element.P);
                        element.D.Created = DateTime.Now;
                    }
                }
                foreach (Element element in connection.ElementList)
                {
                    if (!list.HasID(element.P.ClickID))
                    {
                        IS_BFN m = new IS_BFN {
                            UCID = connection.UCID,
                            ClickID = element.P.ClickID,
                            SubT = IS_BFNTypeEnum.BFN_DEL_BTN
                        };
                        this.Out(m);
                    }
                }
                connection.ElementList = list;
            }
        }

        public void Send_MST(string str)
        {
            IS_MST m = new IS_MST();
            if (str.Length >= 0x3f)
            {
                m.Msg = str.Substring(0, 0x3f);
            }
            else
            {
                m.Msg = str;
            }
            this.Out(m);
        }

        public void Send_MTC(Message m)
        {
            foreach (Connection connection in this.Connections)
            {
                this.Send_MTC(m, connection);
            }
        }

        public void Send_MTC(string str)
        {
            foreach (Connection connection in this.Connections)
            {
                this.Send_MTC(str, connection);
            }
        }

        public void Send_MTC(Message m, Connection c)
        {
            string str = Parse(m.Text, m.Thing, c.Lingo);
            this.Send_MTC(str, c);
        }

        public void Send_MTC(string str, Connection c)
        {
            if (str.Length > 0)
            {
                IS_MTC m = new IS_MTC();
                if (str.Length >= 0x3f)
                {
                    m.msg = str.Substring(0, 0x3f);
                }
                else
                {
                    m.msg = str;
                }
                m.UCID = c.UCID;
                this.Out(m);
            }
        }

        public void Send_RCM(string str)
        {
            this.Send_RCM(str, null);
        }

        public void Send_RCM(Message m, Player p)
        {
            string str = Parse(m.Text, m.Thing, p.Conn.Lingo);
            this.Send_RCM(str, p);
        }

        public void Send_RCM(string str, Player p)
        {
            if (str.Length > 0)
            {
                this.Send_MST("/rcm " + str);
                if (p == null)
                {
                    this.Send_MST("/rcm_all");
                }
                else
                {
                    this.Send_MST("/rcm_ply " + p.PName);
                }
            }
            else if (p == null)
            {
                this.Send_MST("/rcc_all");
            }
            else
            {
                this.Send_MST("/rcc_ply " + p.PName);
            }
        }

        private void StartDebug(Exception e)
        {
            StreamWriter writer = new StreamWriter(new FileStream("debug.log", FileMode.Append, FileAccess.Write));
            try
            {
                writer.WriteLine(string.Format("@{1}:{0}", e.ToString(), DateTime.Now));
                writer.WriteLine(e.StackTrace);
                writer.Write("C: ");
                foreach (Connection connection in this.Connections)
                {
                    writer.Write(" " + connection.UCID);
                }
                writer.WriteLine();
                writer.Write("P: ");
                foreach (Player player in this.Players)
                {
                    writer.Write(" " + player.PLID);
                }
                writer.WriteLine();
                writer.Write("S: ");
                foreach (Control control in this.Screen)
                {
                    writer.Write(" " + control.ToString());
                }
                writer.WriteLine();
            }
            catch
            {
            }
            finally
            {
                writer.Close();
                Console.WriteLine(e.ToString());
            }
        }

        private void StateUpdate()
        {
            this.Positions = new PosList();
            foreach (Player player in this.Players)
            {
                int index = 0;
                index = 1;
                while (index < this.Positions.Count)
                {
                    if (player.Position <= this.Players.ID((byte) this.Positions[index]).Position)
                    {
                        break;
                    }
                    index++;
                }
                this.Positions.Insert(index, player.PLID);
            }
        }

        private void Tick(object o, EventArgs e)
        {
            object obj2;
            Monitor.Enter(obj2 = this.locker);
            try
            {
                this.ScreenDraw();
            }
            catch (Exception exception)
            {
                this.StartDebug(exception);
            }
            finally
            {
                Monitor.Exit(obj2);
            }
        }

        private void Update(CompCar c)
        {
            Player player = this.Players.ID(c.PLID);
            if (player != null)
            {
                player.Update(c);
            }
            if (c.Sp2 >= 0x80)
            {
                this.StateUpdate();
                foreach (module module in this.Modules)
                {
                    module.Update();
                }
            }
        }

        private void UpdateLap(int lapsdone)
        {
            this.LapsDone = lapsdone;
        }

        private void UpdateNodeInfo(ushort numnodes, ushort split1, ushort split2, ushort split3, ushort finish)
        {
            if (this.NumNodes > 0)
            {
                this.NumNodes = numnodes;
            }
            else
            {
                this.NumNodes = 0xffff;
            }
            foreach (Player player in this.Players)
            {
                player.Init();
            }
            this.Finish = finish;
            this.Split1 = split1;
            this.Split2 = split2;
            this.Split3 = split3;
            this.ConvertNode(ref this.Split1);
            this.ConvertNode(ref this.Split2);
            this.ConvertNode(ref this.Split3);
        }

        private void UpdateTrackInfo(RaceLaps laps, byte quals, string track, byte weather, WindEnum wind)
        {
            if (laps.Laps > 0)
            {
                this.Laps = laps.Laps.Value;
                this.Session = SessionType.Race;
                this.LapsDone = 0;
            }
            else if (quals > 0)
            {
                this.Quals = quals;
                this.Session = SessionType.Qual;
            }
            else
            {
                this.Session = SessionType.Practice;
            }
            this.Track = track;
            this.Weather = weather;
            this.Wind = wind;
        }

        public void ViewHelp(Control q, Connection c)
        {
            if (!c.Screen.Contains(this.Agreement))
            {
                c.Screen.Add(this.Agreement);
            }
        }
    }
}

