﻿namespace ISRM
{
    using System;

    public class EnumBox : Button
    {
        private Type EnumType;
        public int i;
        public S<Enum> Obj;

        public EnumBox(S<Enum> obj, string hidden, ControlDelegate e) : base(hidden + Enum.GetName(obj.Value.GetType(), obj.Value))
        {
            base.Hidden = hidden;
            this.EnumType = obj.Value.GetType();
            this.Obj = obj;
            for (int i = 0; i < Enum.GetNames(this.EnumType).Length; i++)
            {
                if (Enum.GetNames(this.EnumType)[i] == Enum.GetName(this.EnumType, this.Obj.Value))
                {
                    this.i = i;
                }
            }
            base.Event = (ControlDelegate) Delegate.Combine(base.Event, new ControlDelegate(this.Click));
            if (e != null)
            {
                base.Event = (ControlDelegate) Delegate.Combine(base.Event, e);
            }
        }

        public EnumBox(S<Enum> obj, string hidden, ControlDelegate e, short t, short l, short h, short w) : this(obj, hidden, e)
        {
            base.T = t;
            base.L = l;
            base.H = h;
            base.W = w;
        }

        private void Click(Control c, Connection d)
        {
            this.i++;
            this.i = this.i % Enum.GetValues(this.EnumType).Length;
            base.Name = base.Hidden + Enum.GetNames(this.EnumType)[this.i];
            this.Obj.Value = (Enum) Enum.GetValues(this.EnumType).GetValue(this.i);
        }
    }
}

