﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using LfsInSimLib.IS_Packets;
    using System;

    public class Element
    {
        public Control C;
        public Control D;
        public ControlDelegate Event;
        public IS_BTN P;

        public Element(IS_BTN p, Control c, Control d, ControlDelegate e)
        {
            this.C = c;
            this.D = d;
            this.P = p;
            this.Event = e;
        }

        public Element(Connection conn, string text, ButtonStyleFlagsEnum style, int t, int l, int h, int w, Control c, Control d)
        {
            this.C = c;
            this.D = d;
            this.P = new IS_BTN();
            this.P.Text = text;
            this.P.BStyle = style;
            this.P.T = (byte) t;
            this.P.L = (byte) l;
            this.P.H = (byte) h;
            this.P.W = (byte) w;
            this.P.ReqI = 1;
            this.P.UCID = conn.UCID;
            this.P.Inst = 0;
            this.P.TypeIn = 0;
            this.P.ClickID = 0xff;
        }

        public Element(Connection conn, string text, ButtonStyleFlagsEnum style, int t, int l, int h, int w, Control c, Control d, ControlDelegate e) : this(conn, text, style, t, l, h, w, c, d)
        {
            this.Event = e;
        }
    }
}

