﻿namespace ISRM
{
    using System;
    using System.Collections;

    public abstract class Control
    {
        public DateTime Created;
        public Hashtable DefaultSettings;
        public DrawDecider Draw;
        public TimeSpan Expire;
        public int H;
        public int L;
        private SBool SDraw;
        public int T;
        public int W;

        public Control()
        {
            this.DefaultSettings = new Hashtable();
            this.L = 0;
            this.T = 0;
            this.W = 0;
            this.H = 0;
            this.Created = DateTime.MaxValue;
            this.Expire = TimeSpan.MaxValue;
            this.Draw = (DrawDecider) Delegate.Combine(this.Draw, new DrawDecider(this.Dummy));
        }

        public Control(int t, int l, int h, int w) : this()
        {
            this.T = t;
            this.L = l;
            this.H = h;
            this.W = w;
        }

        public void DrawSBool(SBool x)
        {
            this.SDraw = x;
            this.Draw = new DrawDecider(this.GetSDraw);
        }

        private bool Dummy(Connection c)
        {
            return true;
        }

        public abstract ArrayList GetElements(Connection c);
        public ArrayList GetElements(Connection c, int t, int l)
        {
            ArrayList elements = this.GetElements(c);
            if (elements.Count > 0)
            {
                int num = t - ((Element) elements[0]).P.T;
                int num2 = l - ((Element) elements[0]).P.L;
                foreach (Element element in elements)
                {
                    element.P.T = (byte) (element.P.T + ((byte) num));
                    element.P.L = (byte) (element.P.L + ((byte) num2));
                }
            }
            return elements;
        }

        public bool GetSDraw(Connection c)
        {
            return this.SDraw.isTrue;
        }

        public Hashtable GetSettings(Connection c)
        {
            if (c.ControlSettings[this] == null)
            {
                c.ControlSettings[this] = new Hashtable(this.DefaultSettings);
            }
            return (Hashtable) c.ControlSettings[this];
        }

        public static bool IsAdmin(Connection connection)
        {
            return connection.Admin;
        }
    }
}

