// LFS Vertex Shader : ShadowToWorld


// Vertex shader input structures

struct VS_INPUT_SHADOW
{
	float4	v0		: POSITION;
};


// Vertex shader output structures

struct VS_OUTPUT_1_SHADOW
{
    float4	oPos	: POSITION;
	float	oFog	: FOG;
	float2	oT0		: TEXCOORD0;
};

struct VS_OUTPUT_2_SHADOW
{
    float4	oPos	: POSITION;
	float	oFog	: FOG;
	float2	oT0		: TEXCOORD0;
	float2	oT1		: TEXCOORD1;
};

struct VS_OUTPUT_3_SHADOW
{
    float4	oPos	: POSITION;
	float	oFog	: FOG;
	float2	oT0		: TEXCOORD0;
	float2	oT1		: TEXCOORD1;
	float2	oT2		: TEXCOORD2;
};

struct VS_OUTPUT_4_SHADOW
{
    float4	oPos	: POSITION;
	float	oFog	: FOG;
	float2	oT0		: TEXCOORD0;
	float2	oT1		: TEXCOORD1;
	float2	oT2		: TEXCOORD2;
	float2	oT3		: TEXCOORD3;
};


// Global variables

float4x4	lightinfo_mat	: register(c0);
float4		fog_info		: register(c90);

float4x4	shad_mat_0		: register(c64);
float4x4	shad_mat_1		: register(c68);
float4x4	shad_mat_2		: register(c72);
float4x4	shad_mat_3		: register(c76);


// Main functions

VS_OUTPUT_1_SHADOW vs_1_shadow_main( in VS_INPUT_SHADOW In )
{
    VS_OUTPUT_1_SHADOW Out;

	// Pos and Fog
	Out.oPos = mul(In.v0, lightinfo_mat);
	Out.oFog = Out.oPos.z * fog_info.x + fog_info.y;
	
	// SHADOWTEX
	Out.oT0 = mul(In.v0, shad_mat_0).xy;
	
    return Out;
}

VS_OUTPUT_2_SHADOW vs_2_shadow_main( in VS_INPUT_SHADOW In )
{
    VS_OUTPUT_2_SHADOW Out;

	// Pos and Fog
	Out.oPos = mul(In.v0, lightinfo_mat);
	Out.oFog = Out.oPos.z * fog_info.x + fog_info.y;
	
	// SHADOWTEX
	Out.oT0 = mul(In.v0, shad_mat_0).xy;
	Out.oT1 = mul(In.v0, shad_mat_1).xy;
	
    return Out;
}

VS_OUTPUT_3_SHADOW vs_3_shadow_main( in VS_INPUT_SHADOW In )
{
    VS_OUTPUT_3_SHADOW Out;

	// Pos and Fog
	Out.oPos = mul(In.v0, lightinfo_mat);
	Out.oFog = Out.oPos.z * fog_info.x + fog_info.y;
	
	// SHADOWTEX
	Out.oT0 = mul(In.v0, shad_mat_0).xy;
	Out.oT1 = mul(In.v0, shad_mat_1).xy;
	Out.oT2 = mul(In.v0, shad_mat_2).xy;
	
    return Out;
}

VS_OUTPUT_4_SHADOW vs_4_shadow_main( in VS_INPUT_SHADOW In )
{
    VS_OUTPUT_4_SHADOW Out;

	// Pos and Fog
	Out.oPos = mul(In.v0, lightinfo_mat);
	Out.oFog = Out.oPos.z * fog_info.x + fog_info.y;
	
	// SHADOWTEX
	Out.oT0 = mul(In.v0, shad_mat_0).xy;
	Out.oT1 = mul(In.v0, shad_mat_1).xy;
	Out.oT2 = mul(In.v0, shad_mat_2).xy;
	Out.oT3 = mul(In.v0, shad_mat_3).xy;
	
    return Out;
}