// LFS Vertex Shader : CarToShadow


// Vertex shader input structure

struct VS_INPUT
{
	float4	v0		: POSITION;
};


// Vertex shader output structure

struct VS_OUTPUT
{
    float4	oPos	: POSITION;
	float4	oD0		: COLOR0;
};


// Global variables

float4x4	pmat			: register(c80);
float4		shad_col		: register(c84);


// Main function

VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;

	Out.oPos = mul(In.v0, pmat);
	Out.oD0 = shad_col;
	
    return Out;
}