<?php
/* Checked if logged in ***************************/
session_start();
include("login.php");
$logged_in = checkLogin();
if(!$logged_in){
	displayLogin();
}
else
{
	$PageClass = new Page;
	
	$PageClass->CheckUserLevel("0"); // Zero = all levels
	
	// Get Setup Station Language File Data
	$PageClass->SetLanguageFiles($_SESSION['LangCode']);
	$stnLang = include("includes/".$_SESSION['stnLangFile']);
	
	// Includes
	include("includes/cp_unicode_tables.php");
	include("includes/general.class.php");
	
	
	// function to safely trim null-terminated strings
	// could just use trim () in this example though
	function trim_c_string ($string) {
	    $new = "";
	    $len = strlen ($string);
	    for ($x=0; $x<$len; $x++) {
	        if ($string[$x] != "\0") $new .= $string[$x];
	        else break;
	    }
	    return $new;
	}
	
	
	// Function to display all Team Member Status
	function display_fixed_table($TeamMembers, $LfsUsers, $InGameName){
	  $GeneralClass = new General;
	  $stnLang = include("includes/".$_SESSION['stnLangFile']);
	/// Count the number of members
	$TotalMembers = count($TeamMembers);
	// Create Header row for the table
	echo "<tr><th class='pme-header' align='center'>".$stnLang['TeamMember']."</th>
			<th class='pme-header' align='center'>".$stnLang['Status']."</th>
			<th class='pme-header' align='center'>".$stnLang['OnServer']."</th></tr>";
	for($i = 0; $i < $TotalMembers; $i++){
	    if($TeamMembers[$i] != "")
	    {
			echo "<tr>\n";
		    foreach ($LfsUsers as $LfsUser => $LfsHost) {
		     if(strtolower($LfsUser) == $TeamMembers[$i]){
		        $LfsUser = $GeneralClass->WriteColor(preg_replace ($GeneralClass->tr_ptrn, $GeneralClass->tr_ptrn_r, $LfsUser));
		        $LfsHost = $GeneralClass->WriteColor(preg_replace ($GeneralClass->tr_ptrn, $GeneralClass->tr_ptrn_r, $LfsHost));
		        echo "<td class='pme-cell-0'><b>$InGameName[$i]</b></td>\n";
		        echo "<td class='pme-cell-0'><b>".$stnLang['Online']."</b></td>\n";
		        echo"<td class='pme-cell-0'><b>$LfsHost</b></td>\n</tr>\n";
		        $Found = "True";
		        break;
		     }
		     else{
		        $Found = "False";
		     }
	     }
	    }
	     if($TeamMembers[$i] != "" && $Found == "False"){
	        echo "<td class='pme-cell-0'>$InGameName[$i]</td>\n";
	        echo "<td class='pme-cell-0'>".$stnLang['Offline']."</td>\n";
	        echo"<td class='pme-cell-0'>&nbsp;</td>\n</tr>\n";
	     }
	}
	}
	
	$PageClass->ConnectToDatabase();
	
	//Populate the Team Members and InGameName arrays
	$count=0;
	$sql = mysql_query("SELECT * FROM stn_users ORDER BY username");
	while($Members = mysql_fetch_array($sql))
	{
	 $TeamMembers[$count] = $Members['lfsnick'];
	 $InGameName[$count]  = $Members['ingamenick'];
	 $count = $count+1; 
	}
	
	// Start of document creation
	$PageClass->DisplayDocType("xhtml10");
	echo "\n<html>\n<head>\n";
	$PageClass->DisplayTitle();
	echo $PageClass->charset;
	$PageClass->DisplayKeywordsDescription();
	$PageClass->DisplayCss();
	echo "</head>\n<body>\n";
	$PageClass->DisplayHeader();
	
	// *** Get the values of the LFSW pubstats variables from the class file ***//
	$pspre = $PageClass->pubstatsPremium;
	$psver = $PageClass->pubstatsVersion;
	$psidk = $PageClass->pubstatsIdentKey;
	
	
	// *** Navigation Section *** //
	echo "<div id='leftnavigation'>\n";
	$PageClass->DisplayMenu("Buttons");
	$PageClass->DisplayMenu("AdminButtons");
	echo "</div>\n";
	
	// *** Page Content *** //
	echo "<div id=\"content\">\n";
	
	// init some vars
	$LfsUsers = array ();
	$x = 0;
	$LfsHostList = "";
	// get the hostlist
	$LfsHostList = @file_get_contents ("http://www.lfsworld.net/pubstat/get_stat2.php?version=".$psver."&idk=".$psidk."&action=hosts");

	$len = strlen ($LfsHostList);
	// Thanks to Tristiancliffe for this line. It is a refresh link
	if ($len < 52) exit ("<P><center><a href='javascript:document.location.reload();'>".$stnLang['TooQuick']."</a></center>");
	
	// parse the data
	while ($x < $len) {
	    $LfsHostName = "";
	    $nr_racers = 0;
	    for ($y=0; $y<32; $y++) $LfsHostName .= $LfsHostList[$x++];
	    $LfsHostName = trim_c_string ($LfsHostName);
	    $x += 20; // skip some host-data
	    $nr_racers = ord ($LfsHostList[$x++]);
	    for ($w=0; $w<$nr_racers; $w++) {
	        $LfsUserName = "";
	        for ($y=0; $y<24; $y++) $LfsUserName .= $LfsHostList[$x++];
	        $LfsUsers[trim_c_string ($LfsUserName)] = $LfsHostName;
	    }
	}
	
	
	// Create table to hold data
	echo "<center>\n<br />";
	echo "<table class='pme-main'>\n";
	display_fixed_table($TeamMembers, $LfsUsers, $InGameName);
	/* Close the table */
	echo "</table>\n</center>\n<br />\n";
	echo "</div>\n";
	$PageClass->DisplayValidationLogos("xhtml10", true);
?>
</body>
</html>
<?php } ?>