<?php
/* Checked if logged in ***************************/
session_start();
include("login.php");
$logged_in = checkLogin();
if(!$logged_in){
	displayLogin();
}
else
{
	$PageClass = new Page;
	
	$PageClass->CheckUserLevel("0"); // Zero = all levels
	// Get Setup Station Language File Data
	$PageClass->SetLanguageFiles($_SESSION['LangCode']);
	$stnLang = include("includes/".$_SESSION['stnLangFile']);
	require("includes/general.class.php");	
	
	$GeneralClass = new General;
	
	$PageClass->ConnectToDatabase();
	// Start of document creation
	$PageClass->DisplayDocType("xhtml10");
	echo "\n<html>\n<head>\n";
	$PageClass->DisplayTitle();
	echo $PageClass->charset;
	$PageClass->DisplayKeywordsDescription();
	$PageClass->DisplayCss();
	echo "</head>\n<body>\n";
	$PageClass->DisplayHeader();
	
	// *** Get the values of the LFSW pubstats variables from the class file ***//
	$pspre = $PageClass->pubstatsPremium;
	$psver = $PageClass->pubstatsVersion;
	$psidk = $PageClass->pubstatsIdentKey;
	
	
	// *** Navigation Section *** //
	echo "<div id='leftnavigation'>\n";
	$PageClass->DisplayMenu("Buttons");
	$PageClass->DisplayMenu("AdminButtons");
	echo "</div>\n";
	
	// *** Page Content *** //
	echo "<div id=\"content\">\n";
	
	// *** Used to display User PB/HL & WR when Car & track selected ***//
	if($_SESSION['username'] != "Guest")
	{
		if((isset($_POST['PME_sys_qf1_id']) && isset($_POST['PME_sys_qf2_id'])))
		{ 
		  if($_POST['PME_sys_qf1_id'] != "*" && $_POST['PME_sys_qf2_id'] != "*")
		  {   
			//Only execute if not $_POST the clear or Hide buttons
			if(!isset($_POST['PME_sys_sw']))
		    {
			  $GeneralClass->ShowUsersPubstats($_POST['PME_sys_qf1_id'], $_POST['PME_sys_qf2_id'], $PageClass->pubstatsPremium, $PageClass->pubstatsVersion, $PageClass->pubstatsIdentKey);
		    } 
		  }
		}
	}
	
	// Create Zip file of selected the setups and set the query
	// depending on the option selected
	$selsets = "All";
	if(isset($_POST['PME_sys_qf1_id'])  && isset($_POST['PME_sys_qf2_id']))
	{
	  if($_POST['PME_sys_qf1_id'] != "*" && $_POST['PME_sys_qf2_id'] == "*")
	  {
	    $selsets = "Car";
	  }
	  elseif($_POST['PME_sys_qf1_id'] == "*" && $_POST['PME_sys_qf2_id'] != "*")
	  {
	    $selsets = "Track";
	  }
	  elseif($_POST['PME_sys_qf1_id'] != "*" && $_POST['PME_sys_qf2_id'] != "*")
	  {
	    $selsets = "CarTrack"; 
	  }
	  else
	  {
	    $selsets = "All"; 
	  }
	}
	
	// Create Zip Files
	switch($selsets)
	{
	  case "Car":
	       $GeneralClass->ZipSetupFiles($_POST['PME_sys_qf1_id']);
		   break;
	
	  case "Track":
	       $GeneralClass->ZipSetupFiles(NULL, $_POST['PME_sys_qf2_id']);
		   break;
	
	  case "CarTrack":
	       $GeneralClass->ZipSetupFiles($_POST['PME_sys_qf1_id'], $_POST['PME_sys_qf2_id']);
		   break;
	}	
	
	// Display dowload links
	if($selsets != "All")
	{
	  echo "<center><a href='setups/SelectedSetups.zip'>".$stnLang['DloadSelect']."</a>
			&nbsp;&nbsp;&nbsp;&nbsp;<a href='setups/AllSetups.zip'>".$stnLang['DloadAll']."</a></center><p />";
	}
	else
	{
	 echo "<center><a href='setups/AllSetups.zip'>".$stnLang['DloadAll']."</a></center><p />"; 
	}
	
	/*
	 * IMPORTANT NOTE: This generated file contains only a subset of huge amount
	 * of options that can be used with phpMyEdit. To get information about all
	 * features offered by phpMyEdit, check official documentation. It is available
	 * online and also for download on phpMyEdit project management page:
	 *
	 * http://platon.sk/projects/main_page.php?project_id=5
	 */
	
	// MySQL host name, user name, password, database, and table
	$opts['hn'] = $PageClass->dbhost;
	$opts['un'] = $PageClass->dbuser;
	$opts['pw'] = $PageClass->dbpswd;
	$opts['db'] = $PageClass->dbname;
	$opts['tb'] = 'stn_setups';
	
	// Name of field which is the unique key
	$opts['key'] = 'suid';
	
	// Type of key field (int/real/string/date etc.)
	$opts['key_type'] = 'int';
	
	// Sorting field(s)
	$opts['sort_field'] = array('carcode', 'trackcode');
	
	// Number of records to display on the screen
	// Value of -1 lists all records in a table
	$opts['inc'] = 12;
	
	// Options you wish to give the users
	// A - add,  C - change, P - copy, V - view, D - delete,
	// F - filter, I - initial sort suppressed
	 $opts['options'] = 'VF';  
	
	
	// *** Button Options used by setups ***
	$opts['buttons']['L']['up'] = array('<<', '<', '>', '>>');
	$opts['buttons']['L']['down'] = $opts['buttons']['L']['up'];
	$opts['buttons']['F']['up'] = array('<<', '<', '>', '>>');
	$opts['buttons']['F']['down'] = $opts['buttons']['L']['up'];
	
	
	// Number of lines to display on multiple selection filters
	$opts['multiple'] = '4';
	
	// Navigation style: B - buttons (default), T - text links, G - graphic links
	// Buttons position: U - up, D - down (default)
	$opts['navigation'] = 'DG';
	
	// Display special page elements
	$opts['display'] = array(
		'form'  => true,
		'query' => true,
		'sort'  => true,
		'time'  => false,
		'tabs'  => true
	);
	
	// Set default prefixes for variables
	$opts['js']['prefix']               = 'PME_js_';
	$opts['dhtml']['prefix']            = 'PME_dhtml_';
	$opts['cgi']['prefix']['operation'] = 'PME_op_';
	$opts['cgi']['prefix']['sys']       = 'PME_sys_';
	$opts['cgi']['prefix']['data']      = 'PME_data_';
	
	/* Get the user's default language and use it if possible or you can
	   specify particular one you want to use. Refer to official documentation
	   for list of available languages. */
	$opts['language'] = $_SESSION['LangCode'];
	//echo $_SESSION['LangCode']; exit;
	/* Table-level filter capability. If set, it is included in the WHERE clause
	   of any generated SELECT statement in SQL query. This gives you ability to
	   work only with subset of data from table.
	
	$opts['filters'] = "column1 like '%11%' AND column2<17";
	$opts['filters'] = "section_id = 9";
	$opts['filters'] = "PMEtable0.sessions_count > 200";
	*/
	
	
	/* Field definitions
	   
	Fields will be displayed left to right on the screen in the order in which they
	appear in generated list. Here are some most used field options documented.
	
	['name'] is the title used for column headings, etc.;
	['maxlen'] maximum length to display add/edit/search input boxes
	['trimlen'] maximum length of string content to display in row listing
	['width'] is an optional display width specification for the column
	          e.g.  ['width'] = '100px';
	['mask'] a string that is used by sprintf() to format field output
	['sort'] true or false; means the users may sort the display on this column
	['strip_tags'] true or false; whether to strip tags from content
	['nowrap'] true or false; whether this field should get a NOWRAP
	['select'] T - text, N - numeric, D - drop-down, M - multiple selection
	['options'] optional parameter to control whether a field is displayed
	  L - list, F - filter, A - add, C - change, P - copy, D - delete, V - view
	            Another flags are:
	            R - indicates that a field is read only
	            W - indicates that a field is a password field
	            H - indicates that a field is to be hidden and marked as hidden
	['URL'] is used to make a field 'clickable' in the display
	        e.g.: 'mailto:$value', 'http://$value' or '$page?stuff';
	['URLtarget']  HTML target link specification (for example: _blank)
	['textarea']['rows'] and/or ['textarea']['cols']
	  specifies a textarea is to be used to give multi-line input
	  e.g. ['textarea']['rows'] = 5; ['textarea']['cols'] = 10
	['values'] restricts user input to the specified constants,
	           e.g. ['values'] = array('A','B','C') or ['values'] = range(1,99)
	['values']['table'] and ['values']['column'] restricts user input
	  to the values found in the specified column of another table
	['values']['description'] = 'desc_column'
	  The optional ['values']['description'] field allows the value(s) displayed
	  to the user to be different to those in the ['values']['column'] field.
	  This is useful for giving more meaning to column values. Multiple
	  descriptions fields are also possible. Check documentation for this.
	*/
	
	$opts['fdd']['suid'] = array(
	  'name'     => 'ID',
	  'select'   => 'T',
	  'options'  => 'AVCPDR', // auto increment
	  'maxlen'   => 11,
	  'default'  => '0',
	  'sort'     => true
	);
	
	// *** Populate carcodes ***
	$count=0;
	$sql = mysql_query("SELECT carcode FROM stn_cars ORDER BY carcode");
	while($car = mysql_fetch_array($sql))
	{
	 $cars[$count] = $car['carcode'];
	 $count = $count+1; 
	}
	$opts['fdd']['carcode'] = array(
	  'name'     => $stnLang['Car'],
	  'select'   => 'D',
	  'maxlen'   => 3,
	  'values'	 => $cars,
	  'sort'     => true
	);
	
	// *** Populate trackcode with "Track Names (Track Code)" ***
	$count=0;
	$sql = mysql_query("SELECT trackcode FROM stn_tracks ORDER BY trackcode");
	while($track = mysql_fetch_array($sql))
	{
	 $tracks[$count] = $track['trackcode'];
	 $count = $count+1; 
	}
	$opts['fdd']['trackcode'] = array(
	  'name'     => $stnLang['Track'],
	  'select'   => 'D',
	  'maxlen'   => 4,
	  'values'	 => $tracks,
	  'sort'     => true
	);
	$opts['fdd']['createdby'] = array(
	  'name'     => $stnLang['CreatedBy'],
	  'select'   => 'T',
	  'maxlen'   => 50,
	  'sort'     => true
	);
	$opts['fdd']['modifiedby'] = array(
	  'name'     => $stnLang['ModifiedBy'],
	  'select'   => 'T',
	  'maxlen'   => 50,
	  'sort'     => true
	);
	$findme = "_";
	$opts['fdd']['setname'] = array(
	  'name'     => $stnLang['Name'],
	  'input'    => 'F',
	  'maxlen'   => 50,
	  'URL'		 => 'setups/$value',
	  'sort'     => true
	);
	$opts['fdd']['comments'] = array(
	  'name'     => $stnLang['Comments'],
	  'select'   => 'T',
	  'maxlen'   => 65535,
	  'textarea' => array('rows' => 5,
	  					  'cols' => 50),
	  'sort'     => true
	);
	
	// Now important call to phpMyEdit
	require_once 'includes/phpMyEdit.class.php';
	new phpMyEdit($opts);
	
	echo "</div>\n";
	$PageClass->DisplayValidationLogos("xhtml10", true);
?>
</body>
</html>
<?php } ?>