<?php
/* Checked if logged in ***************************/
session_start();
include("login.php");
$logged_in = checkLogin();
if(!$logged_in){
displayLogin();
}
else
{
	$PageClass = new Page;
	
	// Allow access to levels specified otherwise deny access
	switch($_SESSION['userlevel']){
	  case 1:
	  case 2:
	  case 3:
	    $PageClass->CheckUserLevel("0");
	    break;
	  default:
	  	$PageClass->CheckUserLevel("-1"); 
	}
		
	// Get Setup Station Language File Data
	$PageClass->SetLanguageFiles($_SESSION['LangCode']);
	$stnLang = include("includes/".$_SESSION['stnLangFile']);
	
	$PageClass->ConnectToDatabase();
	// Start of document creation
	$PageClass->DisplayDocType("xhtml10");
	echo "\n<html>\n<head>\n";
	$PageClass->DisplayTitle();
	echo $PageClass->charset;
	$PageClass->DisplayKeywordsDescription();
	$PageClass->DisplayCss();
	echo "</head>\n<body>\n";
	$PageClass->DisplayHeader();
	
	// *** Navigation Section *** //
	echo "<div id='leftnavigation'>\n";
	$PageClass->DisplayMenu("Buttons");
	$PageClass->DisplayMenu("AdminButtons");
	echo "</div>\n";
	
	// *** Page Content *** //
	echo "<div id=\"content\">\n";
	
	/*
	 * IMPORTANT NOTE: This generated file contains only a subset of huge amount
	 * of options that can be used with phpMyEdit. To get information about all
	 * features offered by phpMyEdit, check official documentation. It is available
	 * online and also for download on phpMyEdit project management page:
	 *
	 * http://platon.sk/projects/main_page.php?project_id=5
	 */
	
	// MySQL host name, user name, password, database, and table
	$opts['hn'] = $PageClass->dbhost;
	$opts['un'] = $PageClass->dbuser;
	$opts['pw'] = $PageClass->dbpswd;
	$opts['db'] = $PageClass->dbname;
	$opts['tb'] = 'stn_setups';
	
	// Name of field which is the unique key
	$opts['key'] = 'suid';
	
	// Type of key field (int/real/string/date etc.)
	$opts['key_type'] = 'int';
	
	// Sorting field(s)
	$opts['sort_field'] = array('carcode', 'trackcode');
	
	// Number of records to display on the screen
	// Value of -1 lists all records in a table
	$opts['inc'] = 12;
	
	// Options you wish to give the users
	// A - add,  C - change, P - copy, V - view, D - delete,
	// F - filter, I - initial sort suppressed
	 $opts['options'] = 'AVF';  
	
	
	// *** Button Options used by setups ***
	$opts['buttons']['L']['up'] = array('<<', '<', 'add', '>', '>>');
	$opts['buttons']['L']['down'] = $opts['buttons']['L']['up'];
	$opts['buttons']['F']['up'] = array('<<', '<', 'add', '>', '>>');
	$opts['buttons']['F']['down'] = $opts['buttons']['L']['up'];
	
	// *** Triggers ***
	$opts['triggers']['insert']['before']='triggers/uplsetups.tib.php'; 
	
	// Number of lines to display on multiple selection filters
	$opts['multiple'] = '4';
	
	// Navigation style: B - buttons (default), T - text links, G - graphic links
	// Buttons position: U - up, D - down (default)
	$opts['navigation'] = 'DG';
	
	// Display special page elements
	$opts['display'] = array(
		'form'  => true,
		'query' => true,
		'sort'  => true,
		'time'  => false,
		'tabs'  => true
	);
	
	// Set default prefixes for variables
	$opts['js']['prefix']               = 'PME_js_';
	$opts['dhtml']['prefix']            = 'PME_dhtml_';
	$opts['cgi']['prefix']['operation'] = 'PME_op_';
	$opts['cgi']['prefix']['sys']       = 'PME_sys_';
	$opts['cgi']['prefix']['data']      = 'PME_data_';
	
	/* Get the user's default language and use it if possible or you can
	   specify particular one you want to use. Refer to official documentation
	   for list of available languages. */
	$opts['language'] = $_SESSION['LangCode'];
	
	/* Table-level filter capability. If set, it is included in the WHERE clause
	   of any generated SELECT statement in SQL query. This gives you ability to
	   work only with subset of data from table.
	
	$opts['filters'] = "column1 like '%11%' AND column2<17";
	$opts['filters'] = "section_id = 9";
	$opts['filters'] = "PMEtable0.sessions_count > 200";
	*/
	
	/* Field definitions
	   
	Fields will be displayed left to right on the screen in the order in which they
	appear in generated list. Here are some most used field options documented.
	
	['name'] is the title used for column headings, etc.;
	['maxlen'] maximum length to display add/edit/search input boxes
	['trimlen'] maximum length of string content to display in row listing
	['width'] is an optional display width specification for the column
	          e.g.  ['width'] = '100px';
	['mask'] a string that is used by sprintf() to format field output
	['sort'] true or false; means the users may sort the display on this column
	['strip_tags'] true or false; whether to strip tags from content
	['nowrap'] true or false; whether this field should get a NOWRAP
	['select'] T - text, N - numeric, D - drop-down, M - multiple selection
	['options'] optional parameter to control whether a field is displayed
	  L - list, F - filter, A - add, C - change, P - copy, D - delete, V - view
	            Another flags are:
	            R - indicates that a field is read only
	            W - indicates that a field is a password field
	            H - indicates that a field is to be hidden and marked as hidden
	['URL'] is used to make a field 'clickable' in the display
	        e.g.: 'mailto:$value', 'http://$value' or '$page?stuff';
	['URLtarget']  HTML target link specification (for example: _blank)
	['textarea']['rows'] and/or ['textarea']['cols']
	  specifies a textarea is to be used to give multi-line input
	  e.g. ['textarea']['rows'] = 5; ['textarea']['cols'] = 10
	['values'] restricts user input to the specified constants,
	           e.g. ['values'] = array('A','B','C') or ['values'] = range(1,99)
	['values']['table'] and ['values']['column'] restricts user input
	  to the values found in the specified column of another table
	['values']['description'] = 'desc_column'
	  The optional ['values']['description'] field allows the value(s) displayed
	  to the user to be different to those in the ['values']['column'] field.
	  This is useful for giving more meaning to column values. Multiple
	  descriptions fields are also possible. Check documentation for this.
	*/
	
	$opts['fdd']['suid'] = array(
	  'name'     => 'ID',
	  'select'   => 'T',
	  'options'  => 'AVCPDR', // auto increment
	  'maxlen'   => 11,
	  'default'  => '0',
	  'sort'     => true
	);
	
	// *** Populate carcodes ***
	$count=0;
	$sql = mysql_query("SELECT carcode FROM stn_cars ORDER BY carcode");
	while($car = mysql_fetch_array($sql))
	{
	 $cars[$count] = $car['carcode'];
	 $count = $count+1; 
	}
	$opts['fdd']['carcode'] = array(
	  'name'     => $stnLang['Car'],
	  'select'   => 'D',
	  'maxlen'   => 3,
	  'values'	 => $cars,
	  'sort'     => true
	);
	
	// *** Populate trackcode with "Track Names (Track Code)" ***
	$count=0;
	$sql = mysql_query("SELECT trackcode FROM stn_tracks ORDER BY trackcode");
	while($track = mysql_fetch_array($sql))
	{
	 $tracks[$count] = $track['trackcode'];
	 $count = $count+1; 
	}
	$opts['fdd']['trackcode'] = array(
	  'name'     => $stnLang['Track'],
	  'select'   => 'D',
	  'maxlen'   => 4,
	  'values'	 => $tracks,
	  'sort'     => true
	);
	$opts['fdd']['createdby'] = array(
	  'name'     => $stnLang['CreatedBy'],
	  'select'   => 'T',
	  'maxlen'   => 50,
	  'sort'     => true
	);
	$opts['fdd']['modifiedby'] = array(
	  'name'     => $stnLang['ModifiedBy'],
	  'select'   => 'T',
	  'maxlen'   => 50,
	  'sort'     => true
	);
	$opts['fdd']['setname'] = array(
	  'name'     => $stnLang['Name'],
	  'input'    => 'F',
	  'maxlen'   => 50,
	  'URL'		 => 'setups/$value',
	  'sort'     => true
	);
	$opts['fdd']['comments'] = array(
	  'name'     => $stnLang['Comments'],
	  'select'   => 'T',
	  'maxlen'   => 65535,
	  'textarea' => array('rows' => 5,
	  					  'cols' => 50),
	  'sort'     => true
	);
	
	// Now important call to phpMyEdit
	require_once 'includes/phpMyEdit.class.php';
	new phpMyEdit($opts);
	
	echo "</div>\n";
	$PageClass->DisplayValidationLogos("xhtml10", true);
?>
</body>
</html>
<?php } ?>