<?php
#################
##  version 9  ##
#################

@extract($_GET);

//If the LFS player name has changed since registering LFS, edit the below file to 
//display the correct name and pull the correct stats.
include ("inc/userNameSwitch.php");
include ("inc/identKeys.php");

//Use Access to PubStats
//Set to 1 for Premium, 0 (zero) for standard
$prem = 0;

//If the template isn't explicitly set as a variable, set it to the default template.
if (!isset ($template) || empty($template)) {
	$template = 1;
}

//Reads the number of files in the images directory.
$files = (getDirFiles("images/")) ;              
   function getDirFiles($dirPath){
		if ($dirPath[strlen($dirPath)] != "/") 
			$dirPath .= "/";
		if ($handle = opendir($dirPath))  {
			while (false !== ($file = readdir($handle))) 
				if ($file != "." && $file != ".." && (!is_dir($dirPath . $file))) {   
					$filesArr[] = trim($file);
				};
			closedir($handle);
		}		  
		return $filesArr;     
	}
	
//Calculates the number of unique templates in the images directory. 
if ($template == "R") {
	$i = count($files);
	$i = ($i / 2);
	$template = rand(1,$i);
}

//Checks to see if the set template number exists. if not, use default template.
$offline = "images/lfs_check_offline".$template.".png";
$online = "images/lfs_check_online".$template.".png";

if (!file_exists($offline)) {
	$offline = "images/lfs_check_offline1.png";
	$online = "images/lfs_check_online1.png";
}

//UserNames with spaces was breaking the LFS query, so this fixes it.
$name = str_replace(" ", "%20",$name);

$cachefile = 'cache/'.$name.'_cached.php';

//setup random cachetime
$randTime = rand(2,6);
$cachetime = $randTime * 60;

$ver = '1.2';
$act = 'pst';
$host = 'http://www.lfsworld.net';
$path = '/pubstat/get_stat2.php';
$query = "?version=$ver&action=$act&racer=";
$idkey = "&idk=".$identKey;
$prem = "&ps=" . $prem;

// Serve from the cache if it is younger than $cachetime
if (file_exists($cachefile) && time() - $cachetime < filemtime($cachefile)) {
	$url = $cachefile;
	$stream = file_get_contents( $url );
	$stats = explode( "\n", $stream );
} else {
	if ($prem == 0) {
		$url = $host . $path . $query . $name . $idkey;
	} else {
		$url = $host . $path . $query . $name . $idkey . $prem;
	}
	$stream = file_get_contents( $url );
	$stats = explode( "\n", $stream );

	$calendar = date("M.d.Y ");
	$tzMod = 3;
	$hour = date("g") + $tzMod;
	$time = date(":i");
	$date = $calendar . $hour . $time;
	
	//if refresh too soon is returned, read the cached file.
	//if cached file doesn't exist, check LFS server for stats every 5 seconds
	if ($stats[0] == "can't reload this page that quickly after another"){
		if (file_exists($cachefile) && time() - $cachetime < filemtime($cachefile)) {
			$url = $cachefile;
			$stream = file_get_contents( $url );
			$stats = explode( "\n", $stream );
		} else {
			while ($stats[0] == "can't reload this page that quickly after another"){
				sleep(5);
					if ($prem == 0) {
						$url = $host . $path . $query . $name . $idkey;
					} else {
						$url = $host . $path . $query . $name . $idkey . $prem;
					}
				$stream = file_get_contents( $url );
				$stats = explode( "\n", $stream );
			}
			// Cache the output to a file after receiving the live stats.
			$fp = fopen($cachefile, 'w');
			fwrite($fp, $stream."\n<--cached-->\n".$date);
			fclose($fp);
		}
	} else {
		// Cache the output to a file when reading live stats.
		$fp = fopen($cachefile, 'w');
		fwrite($fp, $stream."\n<--cached-->\n".$date);
		fclose($fp);
	}
}

//function for converting foreign texts for display on the graphic.		
function codepage_convert ($str) {
	global $cp_tables;

	$newstr = "";
	$current_cp = "L";
	$len = strlen ($str);
	for ($i=0; $i<$len; $i++) {
		if ($str{$i} == "^" && is_array ($cp_tables[$str{$i+1}])) {
			$i++;
			$current_cp = $str{$i};
		continue;
		}

	$decimal = ord ($str{$i});
		if ($decimal > 127) $newstr .= sprintf ("&#%05d;", $cp_tables[$current_cp][$decimal]);
		else $newstr .= $str{$i};
	}
		return $newstr;
}

//function that returns the current codepage of a given text.
function codepage_setting ($str) {
	global $cp_tables;
	$newstr = "";
	$current_cp = "L";
	$len = strlen ($str);
	for ($i=0; $i<$len; $i++) {
		if ($str{$i} == "^" && is_array ($cp_tables[$str{$i+1}])) {
			$i++;
			$current_cp = $str{$i};
		}
	}
	return $current_cp;
}
	
// Code page indicators
// ^L = Latin 1
// ^G = Greek
// ^C = Cyrillic
// ^J = Japanese
// ^E = Central Europe
// ^T = Turkish
// ^B = Baltic

include ("inc/cp_unicode_tables.php");

// Function to remove the colour code data from a string 
function remove_colour_codes($String){
	$ColCodes = array("^0","^1","^2","^3","^4","^5","^6","^7","^8","^9");
	$NewString = str_replace($ColCodes, "",$String);
	return $NewString;
}

$tr_ptrn = array ("/\^d/", "/\^s/", "/\^c/", "/\^a/", "/\^q/", "/\^t/", "/\^l/", "/\^r/", "/\^v/", "/\^\^/", "/</");
$tr_ptrn_r = array ("&#92;", "&#47;", "&#58;", "*", "?", "\"", "<", ">", "|", "^", "&lt;"); 
		
// sets Units for Fuel and Distant to either metric or imperial	
if ($units == "metric") {
	//Convert distance to km, add comna, no decimals
	$distDrvn = number_format($stats[0] * .001, 0, ".", ","). " km";
	//Convert fuel to liters, add comma, no decimals
	$fuel = number_format($stats[1] * .01, 0, ".", ",") . "L";
} else {
	//Convert distance to miles, add comna, no decimals 
	$distDrvn = number_format($stats[0] * .000621371, 0, ".", ","). " mi";
	//Convert fuel to gallons, add comma, no decimals
	$fuel = number_format($stats[1] * .00264172, 0, ".", ",") . "gal";
}
	//Stats, add comma, no decimals
	$laps = number_format($stats[2], 0, ".", ",") . " laps";
	$wins = number_format($stats[4], 0, ".", ",") . " 1st";
	$second = number_format($stats[5], 0, ".", ",") . " 2nd";
	
if ($stats[0] == "pst: no valid username") {
	header("content-type: image/jpeg");
	$im = imagecreatetruecolor(100,10);
	$white = imagecolorallocate($im, 255, 255, 255);
	$black = imagecolorallocate($im, 0, 0, 0);
	imagefilledrectangle($im, 0, 0, 399, 29, $white);
	$font = "fonts/verdana.ttf";
	$text = "invalid username";
	imagettftext($im, 8, 0, 1, 9, $black, $font, $text);
	imagegif($im);
	imagedestroy($im);
	unlink($cachefile);
	exit;
} elseif ($stats[13] == "0") {
	$offlineTxt1 = "is not";
	$offlineTxt2 = "playing";
	$offlineTxt3 = "online";
	header("content-type: image/jpeg");
	$font = "fonts/verdana.ttf";
	$im = imagecreatefrompng($offline);
	$white = imagecolorallocate($im, 255,255,255);
	$black = imagecolorallocate($im, 0,0,0);
	//Add stats to graphics
	$grey = imagecolorallocate($im, 175,175,175);
	imagettftext($im, 6, 0, 330, 65, $grey, $font, $stats[16]);
	imagettftext($im, 6, 0, 320, 75, $grey, $font, $stats[17]);
	imagettftext($im, 15, 0, 11, 24, $black, $font, $user);
	imagettftext($im, 15, 0, 10, 23, $white, $font, $user);
	imagettftext($im, 10, 0, 11, 41, $black, $font, $offlineTxt1);
	imagettftext($im, 10, 0, 11, 56, $black, $font, $offlineTxt2);
	imagettftext($im, 10, 0, 11, 71, $black, $font, $offlineTxt3);
	imagettftext($im, 10, 0, 10, 40, $white, $font, $offlineTxt1);
	imagettftext($im, 10, 0, 10, 55, $white, $font, $offlineTxt2);
	imagettftext($im, 10, 0, 10, 70, $white, $font, $offlineTxt3);
	imagettftext($im, 7, 0, 85, 36, $black, $font, $distDrvn);
	imagettftext($im, 7, 0, 85, 45, $black, $font, $fuel);
	imagettftext($im, 7, 0, 85, 55, $black, $font, $laps);
	imagettftext($im, 7, 0, 170, 36, $black, $font, $wins);
	imagettftext($im, 7, 0, 170, 45, $black, $font, $second);
	imagejpeg($im,"",90);
	imagedestroy($im);			
} else {
	//If online, create online graphic
	$onlineTxt1 = "is playing";
	$onlineTxt2 = "online";
	header("content-type: image/jpeg");
	$font = "fonts/verdana.ttf";
	$kana = $font;
	$fontSize = 7;
	$im = imagecreatefrompng($online);
	$white = imagecolorallocate($im, 255,255,255);
	//if server name is available, adds server name to graphic
	if (!empty ($stats[14])) {
		$server = remove_colour_codes($stats[14]);
		$cp = codepage_setting($server);
		if ($cp == "J"){
			//$kana = "fonts/msgothic.ttf";
			$kana = "fonts/ipagui.ttf";
			$fontSize = 8;				
		}
		$serverList = codepage_convert($server);
		$serverList = preg_replace ($tr_ptrn, $tr_ptrn_r, $serverList);
		imagettftext($im, 7, 0, 85, 64, $black, $font, "online at");
		imagettftext($im, $fontSize, 0, 85, 74, $black, $kana, $serverList);
	}
	//Add stats to graphics
	$grey = imagecolorallocate($im, 175,175,175);
	imagettftext($im, 6, 0, 330, 65, $grey, $font, $stats[16]);
	imagettftext($im, 6, 0, 320, 75, $grey, $font, $stats[17]);
	imagettftext($im, 15, 0, 11, 24, $black, $font, $user);
	imagettftext($im, 15, 0, 10, 23, $white, $font, $user);
	imagettftext($im, 10, 0, 11, 41, $black, $font, $onlineTxt1);
	imagettftext($im, 10, 0, 11, 56, $black, $font, $onlineTxt2);
	imagettftext($im, 10, 0, 10, 40, $white, $font, $onlineTxt1);
	imagettftext($im, 10, 0, 10, 55, $white, $font, $onlineTxt2);
	imagettftext($im, 7, 0, 85, 36, $black, $font, $distDrvn);
	imagettftext($im, 7, 0, 85, 45, $black, $font, $fuel);
	imagettftext($im, 7, 0, 85, 55, $black, $font, $laps);
	imagettftext($im, 7, 0, 170, 36, $black, $font, $wins);
	imagettftext($im, 7, 0, 170, 45, $black, $font, $second);
	imagejpeg($im,"",90);
	imagedestroy($im);	
}
?>