VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "InSimClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'RayOK's VB6 InSimClient!
'
'To use you need 2 other objects. One is my okSocket and the other is a standard
'timer control. See Class_Init to see the objects being assigned. This project probably
'includes the latest okSocket and an example how this works. Have fun and I'll be happy
'to answer any questions.
'
' RayOK (Stuff)

'objects needed to work
Private WithEvents theSocket As okSocket
Attribute theSocket.VB_VarHelpID = -1
Private WithEvents theTimer As Timer
Attribute theTimer.VB_VarHelpID = -1

'sockets
Private lngInSimClient As Long      'internal socket of the insim client, LFS
Private lngInSimServer As Long      'internal socket of the insim server, us
Private blnConnected As Boolean     'connected or not
Private blnDebug As Boolean         'output some debug info

'connection info
Private strInSimIP As String
Private lngInSimSendPort As Long
Private lngInSimRecvPort As Long
Private strInSimPassword As String

'ISI options for LFS
Private Const ISF_RACE_TRACKING As Byte = 1      'bit 0 turns on race tracking
Private Const ISF_GUARANTEE As Byte = 2          'bit 1 turns on guaranteed delivery
Private Const ISF_SPLIT_MESSAGE As Byte = 4      'bit 2 makes LFS use MSS for user messages instead of MSO
Private Const ISF_NO_WARNINGS As Byte = 8        'bit 3 turns off packet warnings
Private Const ISF_KEEP_ALIVE As Byte = 16        'bit 4 makes LFS send keep alive packets
Private Const ISF_NLP_MCI As Byte = 32           'bit 5 makes lfs send MCI instead of NLP

'events raised to update the UI n' stuff
Public Event Connected()
Public Event Disconnected()
Public Event System(ByVal strMessage As String)

'event packets from InSim, base events
Public Event version(ByVal strVersion As String, ByVal strProduct As String, ByVal lngInSimVer As Long)
Public Event Ack()
Public Event StateChanged(ByVal sngReplaySpeed As Single, ByVal lngFlags As Long, ByVal bytInGameCam As Byte, _
    ByVal bytViewPlayer As Byte, ByVal bytNumPlayers As Byte, ByVal bytNumConns As Byte, _
    ByVal bytNumFinished As Byte, ByVal bytRaceInProgress As Byte, ByVal bytQualMins As Byte, _
    ByVal bytRaceLaps As Byte, ByVal strTrack As String, ByVal strWeather As String, ByVal strWind As String)
Public Event MultiJoin(ByVal bytHost As Byte, ByVal strName As String)
Public Event MultiLeave()
Public Event MessageOut(ByVal strMsg As String)
Public Event MessageSplit(ByVal strMsg As String, ByVal strLFSName As String, ByVal strPlyName As String)
Public Event VoteNotify(ByVal bytConn As Byte, ByVal bytAction As Byte)
Public Event VoteAction(ByVal bytAction As Byte)
Public Event VoteCancel()

'race tracking events
Public Event RaceStart(ByVal bytRaceLaps As Byte, ByVal bytQualMins As Byte, ByVal bytNumInRace As Byte, _
    ByVal strTrack As String, ByVal strWeather As String, ByVal strWind As String)
Public Event RaceClear()
Public Event RaceReOrder(bytPosId() As Byte, ByVal bytNumPlayers As Byte)
Public Event RaceEnd()
Public Event ConnectionNew(ByVal strLFSName As String, ByVal strPlyName As String, _
    ByVal bytAdmin As Byte, ByVal bytConnNum As Byte, ByVal bytTotal As Byte)
Public Event ConnectionRename(ByVal strLFSName As String, ByVal strOldName As String, _
    ByVal strNewName As String, ByVal strPlate As String, ByVal bytUID As Byte)
Public Event ConnectionLeave(ByVal strLFSName As String, ByVal strPlyName As String, _
    ByVal bytConnNum As Byte, ByVal bytTotal As Byte)
Public Event PlayerNew(ByVal strLFSName As String, ByVal strPlyName As String, _
    ByVal strPlate As String, ByVal strCarName As String, ByVal lngFlags As Long, _
    ByVal bytType As Byte, ByVal bytUID As Byte, ByVal bytPlyNum As Byte, ByVal bytTotal As Byte)
Public Event PlayerSplit(ByVal curSeconds As Currency, ByVal bytPlyNum As Byte, ByVal bytUID As Byte, ByVal bytSplit As Byte)
Public Event PlayerLap(ByVal strLFSName As String, ByVal strPlyName As String, ByVal strCarName As String, _
    ByVal curSeconds As Currency, ByVal bytPlyNum As Byte, ByVal bytUID As Byte)
Public Event PlayerPit(ByVal strLFSName As String, ByVal strPlyName As String, ByVal bytUID As Byte, ByVal bytPlyNum As Byte, ByVal bytTotal As Byte)
Public Event PlayerResult(ByVal strLFSName As String, ByVal strPlyName As String, ByVal strPlate As String, _
    ByVal strCarName As String, ByVal lngLapsDone As Long, ByVal lngFlags As Long, ByVal bytConfirmFlags As Byte, _
    ByVal bytNumStops As Byte, ByVal bytType As Byte, ByVal bytUID As Byte, ByVal curTotalTime As Currency, _
    ByVal curBestLap As Currency, ByVal bytResultNum As Byte, ByVal bytNumResults As Byte)
Public Event PlayerLeave(ByVal strLFSName As String, ByVal strPlyName As String, ByVal bytUID As Byte, ByVal bytPlyNum As Byte, ByVal bytTotal As Byte)

'not implemented yet :(
'Public Event NodeLap(udtNLP)
'Public Event MultiCarInfo(udtMCI)

'only used in Bytes2Single to convert
Private Type FourBytes
    bytOne As Byte
    bytTwo As Byte
    bytThree As Boolean
    bytFour As Byte
End Type
Private Type ASingle
    sngSingle As Single
End Type

Public Function Initilize() As Boolean
    Set theSocket = frmMain.InSimSocket
    Set theTimer = frmMain.InSimTimer
    
    blnDebug = True
    
    Initilize = True
End Function

Public Property Get isConnected() As Boolean
    isConnected = blnConnected
End Property

'- socket events if debug
Private Sub theSocket_DataSent(lngSocket As Long)
    If blnDebug Then Debug.Print "|InSim sent|"
End Sub
Private Sub theSocket_Closed(lngSocket As Long)
    If blnDebug Then Debug.Print "|InSim " & IIf(lngSocket = lngInSimServer, "server", "client") & " closed|"
End Sub

'- InSim connect/disconnect control
Public Sub Connect(ByVal IP As String, ByVal SendPort As Long, ByVal RecvPort As Long, ByVal Password As String)
    If Not blnConnected Then
        strInSimIP = IP
        lngInSimSendPort = SendPort
        lngInSimRecvPort = RecvPort
        strInSimPassword = Password
        
        lngInSimClient = theSocket.ConnectTo("UDP", lngInSimSendPort, strInSimIP)
        If lngInSimClient Then
            lngInSimServer = theSocket.ListenTo("UDP", lngInSimRecvPort)
            If lngInSimServer Then    'connected to sockets, send INI packet
                'start the timer to connect/keep alive
                theTimer.Tag = 0
                theTimer.Interval = 1000
                theTimer.Enabled = True
            Else
                RaiseEvent System("-could not create server socket!")
                Call theSocket.CloseIt(lngInSimClient)
            End If
        Else
            RaiseEvent System("-could not create client socket!")
        End If
    Else
        RaiseEvent System("-already connected!?")
    End If
End Sub
Public Function Disconnect()
    If blnConnected Then
        Call SendISP("ISC")       'disconnect from LFS
        Call theSocket.CloseIt(lngInSimClient)
        Call theSocket.CloseIt(lngInSimServer)
    
        blnConnected = False
        
        RaiseEvent Disconnected
    End If
    
    'disable timeout timer
    theTimer.Tag = 0
    theTimer.Enabled = False
End Function

'timer to connect and for keep alive
Private Sub theTimer_Timer()
    Dim lngNumSecs As Long

    lngNumSecs = Val(theTimer.Tag)

    If Not blnConnected Then       'send a VER packet every 10 seconds, 3 times
        If lngNumSecs = 30 Then
            RaiseEvent System("no response in 3 tries.. InSim running?")
            Call Disconnect
            Exit Sub
        ElseIf lngNumSecs Mod 10 = 0 Then
            RaiseEvent System("-connecting to " & strInSimIP & ":" & CStr(lngInSimSendPort) & "(" & lngNumSecs \ 10 + 1 & "/3)")
            
            Call SendISI
            Call SendISP("VER")
        End If
    Else
        'send ACK every 30 seconds for a keep alive
        If lngNumSecs Mod 30 = 0 Then Call SendISP("ACK")

        'if no ack's in 2 mins, disconnect
        If lngNumSecs > 120 Then
            RaiseEvent System("no response in 2 minutes.. InSim running?")
            Call Disconnect
        End If
    End If

    theTimer.Tag = lngNumSecs + 1
End Sub

'in connect(), first InSim packet
Private Sub SendISI()
    Dim i As Byte, bytData(0 To 23) As Byte
    
    bytData(0) = 73 'I
    bytData(1) = 83 'S
    bytData(2) = 73 'I
    '3 is always 0
    
    bytData(4) = lngInSimRecvPort Mod 256
    bytData(5) = lngInSimRecvPort \ 256
    bytData(6) = ISF_RACE_TRACKING + ISF_GUARANTEE + ISF_SPLIT_MESSAGE + ISF_KEEP_ALIVE '+ ISF_NLP_MCI
    '7, NodeSecs is 0, number of seconds between NLP or MCI
    
    '8-23 is password, copy it in
    For i = 1 To Len(strInSimPassword)
        bytData(7 + i) = Asc(Mid$(strInSimPassword, i, 1))
        If i >= 16 Then Exit For
    Next i
    
    Call theSocket.SendData(lngInSimClient, bytData)
End Sub
'general packet.. for requests and verification
Public Sub SendISP(ByVal strID As String, Optional ByVal lngVerify As Long)
    Dim i As Byte, bytData(0 To 7) As Byte
    
    'fill in ID of packet
    For i = 1 To Len(strID)
        bytData(i - 1) = Asc(Mid$(strID, i, 1))
        If i >= 4 Then Exit For
    Next i
    
    'the verify bytes
    bytData(4) = lngVerify Mod 256
    bytData(5) = lngVerify \ 256
    
    Call theSocket.SendData(lngInSimClient, bytData)
End Sub
'goes to everyone like you typed it
Public Sub SendMessage(ByVal strMsg As String)
    Dim i As Byte, bytData(0 To 67) As Byte
    
    bytData(0) = 77 'M
    bytData(1) = 83 'S
    bytData(2) = 84 'T
    '3 is always 0
    
    'the message, upto 63 because 64th must be zero
    For i = 1 To Len(strMsg)
        bytData(3 + i) = Asc(Mid$(strMsg, i, 1))
        If i >= 63 Then Exit For
    Next i
    
    Call theSocket.SendData(lngInSimClient, bytData)
End Sub
'only goes to the specified person, personal, gray message
Public Sub SendPlayerMessage(ByVal strMsg As String, Optional ByVal bytUniqueId As Byte, Optional ByVal bytConnNum As Byte)
    Dim i As Byte, bytData(0 To 71) As Byte
    
    bytData(0) = 77 'M
    bytData(1) = 84 'T
    bytData(2) = 67 'C
    '3 is always 0
    
    bytData(4) = bytConnNum
    bytData(5) = bytUniqueId    'if set then bytConnNum is ignored
    
    '6 & 7 are spares
    
    'the message, upto 63 because 64th must be zero
    For i = 1 To Len(strMsg)
        bytData(7 + i) = Asc(Mid$(strMsg, i, 1))
        If i >= 63 Then Exit For
    Next i
    
    Call theSocket.SendData(lngInSimClient, bytData)
End Sub

'called when data received from LFS
Private Sub theSocket_Received(lngSocket As Long, Data() As Byte)
    If lngSocket = lngInSimServer Then
        'reset timeout
        theTimer.Tag = 0
        
        If blnConnected = False Then   'now connected
            blnConnected = True

            RaiseEvent System("-connected to " & strInSimIP & ":" & CStr(lngInSimSendPort))
            RaiseEvent Connected
            
            'get state and host info
            Call SendISP("SST")
            Call SendISP("ISM")
        End If
        
        'debug outs
        If blnDebug Then Debug.Print "|InSim recv " & Left$(StrConv(Data, vbUnicode), 3)
        
        'parse packet depending on ID
        Select Case Left$(StrConv(Data, vbUnicode), 3)
            Case "VER"
                Call DoVersion(Data)
            Case "ACK"
                RaiseEvent Ack
            Case "STA"
                Call DoStateChanged(Data)
            Case "ISM"          'InSimMulti, when a host is started or joined
                Call DoMultiJoin(Data)
            Case "MPE"          'MultiPlayerEnd, on ending or leaving a host
                RaiseEvent MultiLeave
            Case "MSO"          'MeSsageOut, LFS reporting displayed messages
                Call DoMessageOut(Data)
            Case "MSS"          'MeSsageSplit, user messages if ISF_SPLIT_MESSAGE flag is ON
                Call DoMessageSplit(Data)
            Case "VTN"          'VoTeNotify, votes to restart or qualify
                RaiseEvent VoteNotify(Data(4), Data(5))
            Case "VTA"          'VoTeAction, when a vote is completed
                RaiseEvent VoteAction(Data(4))
            Case "VTC"          'VoTeCancel, when a vote is cancelled (can be sent as ISP to cancel)
                RaiseEvent VoteCancel
            Case "RST"          'Race STart
                Call DoRaceStart(Data)
            Case "CLR"          'CLear Race
                Call SendISP("ACK", Data(6) + (Data(7) * 256))
                RaiseEvent RaceClear
            Case "REO"          'REOrder
                Call DoRaceReOrder(Data)
            Case "REN"          'Race ENd
                Call SendISP("ACK", Data(6) + (Data(7) * 256))
                RaiseEvent RaceEnd
            Case "NCN"          'New CoNnection
                Call DoConnectionNew(Data)
            Case "CPR"          'Connection Player Rename
                Call DoConnectionRename(Data)
            Case "CNL"          'CoNnection Leave
                Call DoConnectionLeave(Data)
            Case "NPL"          'New PLayer joining race, if number already there, leaving pits
                Call DoPlayerNew(Data)
            Case "SP1", "SP2", "SP3"    'SPlit X time
                Call DoPlayerSplit(Data)
            Case "LAP"          'LAP time
                Call DoPlayerLap(Data)
            Case "PLP"          'PLayer Pits
                Call DoPlayerPit(Data)
            Case "RES"          'RESult, qualify or finish
                Call DoPlayerResult(Data)
            Case "PLL"          'PLayer Leave race, spectate
                Call DoPlayerLeave(Data)
            Case "NLP"          'Node and Lap Packet, only nodes
                Call DoNodeLap(Data)
            Case "MCI"          'MultiCarInfo, nodes and position/telemetry
                Call DoMultiCarInfo(Data)
            Case Else
                If blnDebug Then Debug.Print "|InSim packet is not handled!!|"
        End Select
    End If
End Sub

'- actions depending on the packet received
Private Sub DoVersion(Data() As Byte)
    Dim strVersion As String, strProduct As String, lngInSimVer As Long
    
    strVersion = Bytes2String(Data, 4, 8)
    strProduct = Bytes2String(Data, 12, 6)
    lngInSimVer = Data(18) + (Data(19) * 256)
    
    RaiseEvent version(strVersion, strProduct, lngInSimVer)
End Sub
Private Sub DoStateChanged(Data() As Byte)
    Dim sngReplaySpeed As Single, lngFlags As Long
    Dim strTrack As String, strWeather As String, strWind As String
    
    sngReplaySpeed = Bytes2Single(Data, 0)
    lngFlags = Data(8) + (Data(9) * 256)
    strTrack = Bytes2String(Data, 20, 6)
    strWeather = GetWeather(strTrack, Data(26))
    strWind = IIf(Data(27) = 0, "no", IIf(Data(27) = 1, "low", "high")) & " wind"
        
    RaiseEvent StateChanged(sngReplaySpeed, lngFlags, Data(10), Data(11), Data(12), _
        Data(13), Data(14), Data(15), Data(16), Data(17), strTrack, strWeather, strWind)
End Sub
Private Sub DoMultiJoin(Data() As Byte)
    Dim strName As String
    
    strName = Bytes2String(Data, 8, 32)
    
    RaiseEvent MultiJoin(Data(4), strName)
End Sub
Private Sub DoMessageOut(Data() As Byte)
    Dim strMsg As String
    
    strMsg = Bytes2String(Data, 4, 128)
    
    RaiseEvent MessageOut(strMsg)
End Sub
Private Sub DoMessageSplit(Data() As Byte)
    Dim strMsg As String, strLFSName As String, strPlyName As String
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    strMsg = Bytes2String(Data, 52, 64)
    
    RaiseEvent MessageSplit(strMsg, strLFSName, strPlyName)
End Sub

Private Sub DoRaceStart(Data() As Byte)
    Dim strTrack As String, strWeather As String, strWind As String

    strTrack = Bytes2String(Data, 8, 6)
    strWeather = GetWeather(strTrack, Data(14))
    strWind = IIf(Data(15) = 0, "no", IIf(Data(15) = 1, "low", "high")) & " wind"
    
    Call SendISP("ACK", Data(18) + (Data(19) * 256))
    
    RaiseEvent RaceStart(Data(4), Data(5), Data(6), strTrack, strWeather, strWind)
End Sub
Private Sub DoRaceReOrder(Data() As Byte)
    Dim i As Integer, bytPosIds(0 To 27) As Byte
    
    'sort of implemented.. need to go through the PosIds somehow..
    For i = 0 To 27
        bytPosIds(i) = Data(4 + i)
    Next i
    
    Call SendISP("ACK", Data(34) + (Data(35) * 256))

    RaiseEvent RaceReOrder(bytPosIds, Data(33))
End Sub
Private Sub DoConnectionNew(Data() As Byte)
    Dim strLFSName As String, strPlyName As String
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    
    Call SendISP("ACK", Data(58) + (Data(59) * 256))

    RaiseEvent ConnectionNew(strLFSName, strPlyName, Data(52), Data(56), Data(57))
End Sub
Private Sub DoConnectionRename(Data() As Byte)
    Dim strLFSName As String, strOldName As String, strNewName As String, strPlate As String
    
    strLFSName = Bytes2String(Data, 4, 24)
    strOldName = Bytes2String(Data, 28, 24)
    strNewName = Bytes2String(Data, 52, 24)
    strPlate = Bytes2String(Data, 76, 8)
    
    Call SendISP("ACK", Data(85) + (Data(86) * 256))

    RaiseEvent ConnectionRename(strLFSName, strOldName, strNewName, strPlate, Data(84))
End Sub
Private Sub DoConnectionLeave(Data() As Byte)
    Dim strLFSName As String, strPlyName As String
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    
    Call SendISP("ACK", Data(54) + (Data(55) * 256))

    RaiseEvent ConnectionLeave(strLFSName, strPlyName, Data(52), Data(53))
End Sub
Private Sub DoPlayerNew(Data() As Byte)
    Dim strLFSName As String, strPlyName As String, strPlate As String
    Dim strCarName As String, lngFlags As Long
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    strPlate = Bytes2String(Data, 52, 8)
    strCarName = GetShortCarName(Bytes2String(Data, 60, 32))
    lngFlags = Data(92) + (Data(93) * 256)
    
    Call SendISP("ACK", Data(98) + (Data(99) * 256))
    
    RaiseEvent PlayerNew(strLFSName, strPlyName, strPlate, strCarName, lngFlags, _
        Data(94), Data(95), Data(96), Data(97))
End Sub
Private Sub DoPlayerSplit(Data() As Byte)
    Dim bytSplit As Byte, curSeconds As Currency

    bytSplit = Val(Chr(Data(2)))            'gets 1, 2 or 3
    curSeconds = Bytes2Seconds(Data, 4)
    
    Call SendISP("ACK", Data(10) + (Data(11) * 256))
    
    RaiseEvent PlayerSplit(curSeconds, Data(8), Data(9), bytSplit)
End Sub
Private Sub DoPlayerLap(Data() As Byte)
    Dim strLFSName As String, strPlyName As String
    Dim strCarName As String, curSeconds As Currency
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    strCarName = GetShortCarName(Bytes2String(Data, 52, 32))
    curSeconds = Bytes2Seconds(Data, 84)
    
    Call SendISP("ACK", Data(90) + (Data(91) * 256))
    
    RaiseEvent PlayerLap(strLFSName, strPlyName, strCarName, curSeconds, Data(88), Data(89))
End Sub
Private Sub DoPlayerPit(Data() As Byte) 'SAME AS DoPlayerLeave
    Dim strLFSName As String, strPlyName As String
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    
    Call SendISP("ACK", Data(58) + (Data(59) * 256))
    
    RaiseEvent PlayerPit(strLFSName, strPlyName, Data(52), Data(56), Data(57))
End Sub
Private Sub DoPlayerResult(Data() As Byte)
    Dim strLFSName As String, strPlyName As String, strPlate As String, strCarName As String
    Dim lngHours As Long, lngLapsDone As Long, lngFlags As Long, curTotalTime As Currency, curBestLap As Currency
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    strPlate = Bytes2String(Data, 52, 8)
    strCarName = Bytes2String(Data, 60, 4)  'already short
    lngHours = Data(84) + (Data(85) * 256)
    lngLapsDone = Data(88) + (Data(89) * 256)
    lngFlags = Data(90) + (Data(91) * 256)
    curTotalTime = Bytes2Seconds(Data, 96)
    curBestLap = Bytes2Seconds(Data, 100)
    
    Call SendISP("ACK", Data(106) + (Data(107) * 256))
    
    RaiseEvent PlayerResult(strLFSName, strPlyName, strPlate, strCarName, _
        lngLapsDone, lngFlags, Data(92), Data(93), Data(94), Data(95), _
        curTotalTime, curBestLap, Data(104), Data(105))
End Sub
Private Sub DoPlayerLeave(Data() As Byte)
    Dim strLFSName As String, strPlyName As String
    
    strLFSName = Bytes2String(Data, 4, 24)
    strPlyName = Bytes2String(Data, 28, 24)
    
    Call SendISP("ACK", Data(58) + (Data(59) * 256))
    
    RaiseEvent PlayerLeave(strLFSName, strPlyName, Data(52), Data(56), Data(57))
End Sub
Private Sub DoNodeLap(Data() As Byte)
    Debug.Print "InSimClient DoNodeLap"
End Sub
Private Sub DoMultiCarInfo(Data() As Byte)
    Debug.Print "InSimClient DoMultiCarInfo"
End Sub

'helper functions to convert InSim data one way or another
Private Function Bytes2String(bytData() As Byte, intStart As Integer, intLength As Integer) As String
    Dim i As Integer, strString As String
    
    'copy the bytes
    For i = 0 To intLength - 1
        If bytData(intStart + i) = 0 Then
            Exit For
        Else
            strString = strString & Chr$(bytData(intStart + i))
        End If
    Next i
    
    'remove lfs codes, colors first
    For i = 0 To 9
        strString = Replace(strString, "^" & i, "")
    Next i
    
    'special lfs characters
    strString = Replace(strString, "^a", "*")
    strString = Replace(strString, "^c", ":")
    strString = Replace(strString, "^d", "\")
    strString = Replace(strString, "^l", "<")
    strString = Replace(strString, "^q", "?")
    strString = Replace(strString, "^r", ">")
    strString = Replace(strString, "^s", "/")
    strString = Replace(strString, "^t", """")  'double quote
    strString = Replace(strString, "^v", "|")
    
    'language codes
    strString = Replace(strString, "^L", "")   'Latin 1
    strString = Replace(strString, "^G", "")   'Greek
    strString = Replace(strString, "^C", "")   'Cyrillic
    strString = Replace(strString, "^J", "")   'Japanese
    strString = Replace(strString, "^E", "")   'Central Europe
    strString = Replace(strString, "^T", "")   'Turkish
    strString = Replace(strString, "^B", "")   'Baltic
    
    Bytes2String = strString
End Function
Private Function Bytes2Single(bytData() As Byte, intStart As Integer) As Single
    Dim theBytes As FourBytes, theSingle As ASingle
    
    'copy the bytes into the 4-byte UDT
    theBytes.bytOne = bytData(intStart + 0)
    theBytes.bytTwo = bytData(intStart + 1)
    theBytes.bytThree = bytData(intStart + 2)
    theBytes.bytFour = bytData(intStart + 3)
    
    'copy memory the bytes into the single
    LSet theSingle = theBytes
    
    Bytes2Single = theSingle.sngSingle
End Function
Private Function Bytes2Seconds(bytData() As Byte, intStart As Integer) As Currency
    Dim curSeconds As Currency

    curSeconds = bytData(intStart) * 60                     'minutes
    curSeconds = curSeconds + bytData(intStart + 1)         'seconds
    curSeconds = curSeconds + (bytData(intStart + 2) / 100) 'hundreths

    Bytes2Seconds = curSeconds
End Function

Private Function GetShortCarName(ByVal Car As String) As String
    Select Case UCase$(Car)
        Case "UF 1000": GetShortCarName = "UF1"
        Case "XF GTI": GetShortCarName = "XFG"
        Case "XR GT": GetShortCarName = "XRG"
        Case "XR GT TURBO": GetShortCarName = "XRT"
        Case "RB4 GT": GetShortCarName = "RB4"
        Case "FXO TURBO": GetShortCarName = "FXO"
        Case "LX4": GetShortCarName = "LX4"
        Case "LX6": GetShortCarName = "LX6"
        Case "RA": GetShortCarName = "RAC"
        Case "FZ50": GetShortCarName = "FZ5"
        Case "MRT5": GetShortCarName = "MRT"
        Case "XF GTR": GetShortCarName = "XFR"
        Case "UF GTR": GetShortCarName = "UFR"
        Case "FORMULA XR": GetShortCarName = "FOX"
        Case "FORMULA V8": GetShortCarName = "FO8"
        Case "FXO GTR": GetShortCarName = "FXR"
        Case "XR GTR": GetShortCarName = "XRR"
        Case "FZ50 GTR": GetShortCarName = "FZR"
        Case "BMW SAUBER": GetShortCarName = "BF1"
        Case Else: GetShortCarName = UCase$(Car)
    End Select
End Function
Private Function GetWeather(Track As String, Weather As Byte) As String
    Select Case Left$(Track, 2)
        Case "BL"
            Select Case Weather
                Case 0: GetWeather = "Clear Day"
                Case 1: GetWeather = "Cloudy Afternoon"
                Case 2: GetWeather = "Cloudy Sunset"
                Case Else: GetWeather = "Can't See!?"
            End Select
        Case "SO"
            Select Case Weather
                Case 0: GetWeather = "Clear Afternoon"
                Case 1: GetWeather = "Overcast Day"
                Case 2: GetWeather = "Cloudy Sunset"
                Case Else: GetWeather = "Can't See!?"
            End Select
        Case "FE"
            Select Case Weather
                Case 0: GetWeather = "Clear Day"
                Case 1: GetWeather = "Cloudy Sunset"
                Case 2: GetWeather = "Overcast Dusk"
                Case Else: GetWeather = "Can't See!?"
            End Select
        Case "AU"
            Select Case Weather
                Case 0: GetWeather = "Overcast Afternoon"
                Case 1: GetWeather = "Clear Morning"
                Case 2: GetWeather = "Cloudy Sunset"
                Case Else: GetWeather = "Can't See!?"
            End Select
        Case "KY"
            Select Case Weather
                Case 0: GetWeather = "Clear Day"
                Case 1: GetWeather = "Cloudy Afternoon"
                Case 2: GetWeather = "Cloudy Morning"
                Case Else: GetWeather = "Can't See!?"
            End Select
        Case "WE"
            Select Case Weather
                Case 0: GetWeather = "Clear Day"
                Case 1: GetWeather = "Cloudy Afternoon"
                Case 2: GetWeather = "Cloudy Sunset"
                Case Else: GetWeather = "Can't See!?"
            End Select
        Case "AS"
            Select Case Weather
                Case 0: GetWeather = "Clear Day"
                Case 1: GetWeather = "Cloudy Afternoon"
                Case Else: GetWeather = "Can't See!?"
            End Select
        Case Else
            GetWeather = "No track set"
    End Select
End Function

Private Sub Class_Terminate()
    If blnConnected Then
        Call Disconnect
        Call theSocket.Terminate
        Set theSocket = Nothing
    End If
End Sub
