#pragma once

#define FAIL -1
#define OK 0

#define EXIT_OK 0
#define EXIT_FAIL -1

#define IS_PRODUCT_NAME "EconoMeter"
#define VER_NUM "0.051"
#define CODENAME "Polymethylmethacrylate"
#define EC_INSIM_VER_MIN 4
#define EC_INSIM_VER_MAX 5

/* Defines whether the Windows or Linux part of the source will be compiled.
 * Options are CIS_WINDOWS or CIS_LINUX
 */
#define CIS_WINDOWS
#include <iostream>

// Includes for Windows (uses winsock2)
#ifdef CIS_WINDOWS
#include "pthread.h"
#include <winsock2.h>
#include <windows.h>

#pragma comment(lib, "Ws2_32.lib")
#pragma comment(lib, "pthreadVC2.lib")
#endif

// Includes for *NIX (no winsock2, these headers are needed instead)
#ifdef CIS_LINUX
//#include <stdio.h>
#include <pthread.h>
#include <limits.h>
#include <cstring>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fstream>
#include <unistd.h>
#include <fcntl.h>
#endif
