// ==UserScript==
// @name         LFS Forum User Ignore
// @namespace    http://lfs.net/forum
// @version      0.1
// @description  This script automatically hides posts from specific users on LFSForum (http://lfs.net/forum).
// @author       Martin Kapal
// @grant        none
// @include      *lfs.net/forum* 
// ==/UserScript==
/* jshint -W097 */
'use strict';


/***** Configuration *****/

// Example
// var ignored_users = ['username1', 'username2'];

var ignored_users = [];


/***** Script itself *****/

var posts = document.getElementsByClassName("FPost");
for (var i = 0; i < posts.length; i++) {
    var username = posts[i].getElementsByClassName("UserLink")[0].innerHTML;
    if (ignored_users.indexOf(username) !== -1) {
        
        var post_header = posts[i].getElementsByClassName("FPostHeader")[0];
        var post_div = post_header.nextElementSibling;
        post_div.style.display = "none";
        
        var input = post_header.getElementsByTagName("input")[0];
        if (typeof input !== "undefined") {
            input.style.display = "none";
        }
        
        var postheader_inner = post_header.getElementsByClassName("left m_h5 lh_18 mouseDefault")[0];
        if (typeof postheader_inner !== "undefined") {
            postheader_inner.innerHTML = "- (" + username + ') <span style="color: yellow">IGNORED</span>';
            postheader_inner.style.cursor = "pointer";
            postheader_inner.onclick = function () {
                var post_div = this.parentElement.nextElementSibling;
                if (typeof this.parentElement.getElementsByTagName("input")[0] !== "undefined" && typeof post_div !== "undefined") {
                    if (post_div.style.display == "none") {
                        post_div.style.display = "block";
                    } else {
                        post_div.style.display = "none";
                    }
                }
            };
        }
        console.log("Ignored post by " + username);
    }
}
