#include "stdafx.h"
#include "WinMutex.h"

WinMutex::WinMutex(HANDLE mutex, DWORD timeout)
{
	if (mutex == NULL || mutex == INVALID_HANDLE_VALUE)
		status = WAIT_FAILED;
	else {
		m_hMutex = mutex;
		status = WaitForSingleObject(m_hMutex, timeout);
	}
}

VOID WinMutex::Unlock(void)
{
	if (status == WAIT_OBJECT_0) {
		ReleaseMutex(m_hMutex);
		status = WAIT_ABANDONED;
	}
}

WinMutex::~WinMutex(void)
{
	Unlock();
}
