#ifndef LFSINTERFACE_H
#define LFSINTERFACE_H

typedef unsigned char byte;
typedef unsigned short word;
typedef struct NodeLap NodeLap;
typedef struct CompCar CompCar;
typedef struct {
	int x; int y; int z;
} Vec;
typedef struct {
	float x; float y; float z;
} Vector;

#include "insim.h"
#include "Global.h"
#include "G27LEDsApp.h"
#include <vector>

BOOL InitLFSIFace(word isPort, word ogPort, LPCWSTR adminPass);
BOOL InitDLLIFace();
BOOL InitMsgIFace();
VOID ShutdownLFSIFace();

static BOOL InitInSim(word isPort);
static DWORD WINAPI InSimThrFunc(LPVOID lpArg);
static BOOL InitOutGauge(word ogPort);
static VOID LogSocketError(const DWORD errorId, LPCTSTR prefix);
static VOID ProcessISPacket(const char* packBuffer);
static DWORD WINAPI OutGaugeThrFunc(LPVOID lpArg);
static DWORD WINAPI MessageReaderThrFunc(LPVOID lpArg);
static DWORD WINAPI MessageThrFunc(LPVOID lpArg);

/* Packet handlers */
static VOID IS_STAHandler(struct IS_STA* packet);
#endif //LFSINTERFACE_H