#ifndef G27LEDSAPP_H
#define G27LEDSAPP_H

#include "LFSInterface.h"
#include "ConfigLoader.h"
#include "Global.h"

#define MSG_SEVERITY_INFO 1
#define MSG_SEVERITY_DEBUG 2

inline BOOL IsValidPort(UINT port)
{
	return (port > 0) && (port < 65536);
}

VOID LogMessage(LPCWSTR msg, UINT severity);

static BOOL CheckFilesMD5(LPCWSTR filename, LPCWSTR hash);
static INT IntLength(INT i);
static BOOL LaunchLFS(UINT port);
static VOID LogToFile(LPCWSTR msg);
static VOID LogToWindow(LPCWSTR msg);
static BOOL ParseUserInput();
static LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow);

#endif //G27LEDSAPP_H