#include "stdafx.h"
#include <fstream>
#include <sstream>
#include <string>
#include "G27LEDsApp.h"
#include <tchar.h>
#include "WinMutex.h"
#include <WinCrypt.h>


LPCTSTR gszMyClassName = _T("G27LEDS_APP");
LPCTSTR gszWindowCaption = _T("G27 LEDs for LFS " VERSION_MAJ "." VERSION_MIN);
LPCTSTR szMD5ErrCaption = _T("MD5 Check error");
LPCWSTR szDInput8DLLMD5 = L"5721285238dedbc77ba410bc3e691ca6";
WCHAR gszAdminPass[16];
LPWSTR gszInSimPort;
LPWSTR gszOutGaugePort;
HANDLE hLogMutex;
static UINT isPort;
static HINSTANCE myHInstance;
static HWND myHWnd = 0 ;
static UINT ogPort;
static const int winHeight = 400;
static const int winWidth = 300;

/* Window contents */
enum { ID_ISP_CTRL = 1,
	   ID_OGP_CTRL,
	   ID_MSGS_CTRL,
	   ID_ADMP_CTRL };
enum { ID_QUIT_BTN = 1,
	   ID_LAUNCHLFS_BTN };

const int cVertStep = 30;
int lbMaxWidth = 150;

static HWND hBLaunchLFS;
static HWND hBQuit;
static HWND hsCAdminPass;
static HWND hsCInSimPort;
static HWND hsCOutGaugePort;
static HWND hLBMessages;
static HWND hTFAdminPass;
static HWND hTFInSimPort;
static HWND hTFOutGaugePort;

static LPCSTR LOG_FILENAME = "g27log.txt";
static std::wofstream fileLogger;

static INT IntLength(INT i)
{
	int nums = 1;
	while ((i /= 10) > 0)
		nums++;

	return nums;
}

static BOOL CheckFilesMD5(LPCWSTR filename, LPCWSTR hash)
{
	HCRYPTPROV hProv;
	HCRYPTHASH hHash;
	LARGE_INTEGER fileSize;
	LPBYTE lpMap;
	HANDLE hMapping;
	DWORD hashLen = 16;
	HANDLE hFile = CreateFileW(filename, FILE_READ_ACCESS, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);

	if (hFile == INVALID_HANDLE_VALUE) {
		MessageBox(NULL, _T("Cannot open file to check its MD5"), szMD5ErrCaption, MB_OK | MB_ICONERROR);
		return FALSE;
	}
	if (!GetFileSizeEx(hFile, &fileSize)) {
		MessageBox(NULL, _T("Cannot get size of the file."), szMD5ErrCaption, MB_OK | MB_ICONERROR);
		CloseHandle(hFile);
		return FALSE;
	}
	hMapping = CreateFileMappingW(hFile, NULL, PAGE_READONLY, 0, 0, NULL);
	if (!hMapping) {
		MessageBox(NULL, _T("Cannot create file mapping."), szMD5ErrCaption, MB_OK | MB_ICONERROR);
		CloseHandle(hFile);
		return FALSE;
	}
	lpMap = (LPBYTE)MapViewOfFile(hMapping, FILE_MAP_READ, 0, 0, fileSize.LowPart);

	if (!CryptAcquireContextW(&hProv, NULL, NULL, PROV_RSA_FULL, CRYPT_VERIFYCONTEXT)) {
		MessageBox(NULL, _T("CryptAquireContext failed."), _T("Crypto error"), MB_OK | MB_ICONERROR);
		CloseHandle(hMapping);
		CloseHandle(hFile);
		return FALSE;
	}

	if (!CryptCreateHash(hProv, CALG_MD5, 0, 0, &hHash)) {
		MessageBox(NULL, _T("Failed to create MD5 hash."), _T("Crypto error"), MB_OK | MB_ICONERROR);
		CryptReleaseContext(hProv, 0);
		CloseHandle(hMapping);
		CloseHandle(hFile);

		return FALSE;
	}

	if (!CryptHashData(hHash, lpMap, fileSize.LowPart, 0)) {
		MessageBox(NULL, _T("Cannot generate MD5 hash."), szMD5ErrCaption, MB_OK | MB_ICONERROR);
		CryptReleaseContext(hProv, 0);
		UnmapViewOfFile(lpMap);
		CloseHandle(hMapping);
		CloseHandle(hFile);
	}

	std::vector<BYTE> hashBuf(hashLen);
	if (!CryptGetHashParam(hHash, HP_HASHVAL, reinterpret_cast<BYTE*>(&hashBuf[0]), &hashLen, 0)) {
		MessageBox(NULL, _T("Cannot retreive MD5 hash."), szMD5ErrCaption, MB_OK | MB_ICONERROR);
		CryptReleaseContext(hProv, 0);
		UnmapViewOfFile(lpMap);
		CloseHandle(hMapping);
		CloseHandle(hFile);
	}

	std::wostringstream woss;
	for (std::vector<BYTE>::const_iterator cit = hashBuf.begin(); cit != hashBuf.end(); cit++) {
		woss.fill('0');
		woss.width(2);
		woss << std::hex << static_cast<const int>(*cit);
	}
	if (woss.str().compare(std::wstring(hash)) == 0) {
		CryptReleaseContext(hProv, 0);
		UnmapViewOfFile(lpMap);
		CloseHandle(hMapping);
		CloseHandle(hFile);

		return TRUE;
	} else {
		std::wstring msg(_T("Dinput8.dll MD5 hash does not match!\n"));
		msg.append(woss.str());
		MessageBoxW(NULL, msg.c_str(), szMD5ErrCaption, MB_OK | MB_ICONERROR);
		LogToFile(msg.c_str());
	}
	
	UnmapViewOfFile(lpMap);
	CryptReleaseContext(hProv, 0);
	CloseHandle(hMapping);
	CloseHandle(hFile);
	
	return FALSE;
}

static BOOL LaunchLFS(UINT port)
{
	WCHAR launchParams[32];
	ZeroMemory(launchParams, 32);
	wsprintfW(launchParams, L"/insim=%d", port);
	INT ret = (INT)ShellExecuteW(NULL, L"OPEN", L"LFS.exe", launchParams, NULL, SW_SHOW);

	if (ret < 32) {
		switch (ret) {
		case ERROR_FILE_NOT_FOUND:
			MessageBoxW(myHWnd, L"LFS.exe not found in current directory.", L"File not found.", MB_OK | MB_ICONERROR);
			return FALSE;
		}

		return FALSE;
	}

	return TRUE;
}

VOID LogMessage(LPCWSTR msg, UINT severity)
{
	WinMutex lk(hLogMutex, 1000);
	if (lk.status == WAIT_OBJECT_0) {
		if ((severity == MSG_SEVERITY_DEBUG) && (debugLevel & DEBUG_LOG_WINDOW) || severity == MSG_SEVERITY_INFO)
			LogToWindow(msg);	
		LogToFile(msg);
	}
}

static VOID LogToFile(LPCWSTR msg)
{
	if (!(debugLevel & DEBUG_LOG_FILE))
		return;

	if (!fileLogger.is_open())
		return;

	fileLogger << std::wstring(msg) << std::endl;
}

static VOID LogToWindow(LPCWSTR msg)
{
	if (myHWnd) {
		LRESULT idx = SendDlgItemMessageW(myHWnd, ID_MSGS_CTRL, LB_ADDSTRING, 0, (LPARAM)msg);
		SendMessageW(hLBMessages, LB_SETTOPINDEX, idx, 0);

		/* Extend listbox if needed */
		HFONT hF = (HFONT)SendMessage(hLBMessages, WM_GETFONT, 0, 0);
		HDC hDC = GetDC(hLBMessages);
		HGDIOBJ hObj = SelectObject(hDC, hF);
		SIZE sz;
		GetTextExtentPointW(hDC, msg, wcslen(msg), &sz);
		if (sz.cx > lbMaxWidth) {
			lbMaxWidth = sz.cx;
			SendMessage(hLBMessages, LB_SETHORIZONTALEXTENT, (WPARAM)lbMaxWidth, 0);
		}
		SelectObject(hDC, hObj);
		ReleaseDC(hLBMessages, hDC);
	}

}

static BOOL ParseUserInput()
{
	BOOL isPortOK;
	BOOL ogPortOK;

	isPort = GetDlgItemInt(myHWnd, ID_ISP_CTRL, &isPortOK, FALSE);
	if (!isPortOK) {
		MessageBoxW(myHWnd, L"Cannot parse InSim port, check if you entered it correctly.", L"Invalid data", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	if (!IsValidPort(isPort)) {
		MessageBoxW(myHWnd, L"Invalid InSim port number.", L"Invalid data", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

	ogPort = GetDlgItemInt(myHWnd, ID_OGP_CTRL, &ogPortOK, FALSE);
	if (!ogPortOK) {
		MessageBoxW(myHWnd, L"Cannot parse OutGauge port, check if you entered it correctly.", L"Invalid data", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	if (!IsValidPort(ogPort)) {
		MessageBoxW(myHWnd, L"Invalid OutGauge port number.", L"Invalid data", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

	GetDlgItemTextW(myHWnd, ID_ADMP_CTRL, gszAdminPass, 16);

	return TRUE;
}
static LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {
	case WM_CREATE:
		hsCInSimPort = CreateWindowW(L"STATIC", L"InSim port:", WS_VISIBLE | WS_CHILD, 10, 10, 130, 20, hwnd, NULL, myHInstance, NULL);
		hsCOutGaugePort = CreateWindowW(L"STATIC", L"OutGauge port:", WS_VISIBLE | WS_CHILD, 10, 10 + cVertStep, 130, 20, hwnd, NULL, myHInstance, NULL);
		hsCAdminPass = CreateWindow(L"STATIC", L"Admin password:", WS_VISIBLE | WS_CHILD, 10, 10 + (2*cVertStep), 130, 20, hwnd, NULL, myHInstance, NULL);
		
		hTFInSimPort = CreateWindowExW(WS_EX_CLIENTEDGE, L"EDIT", gszInSimPort, WS_VISIBLE | WS_CHILD | WS_EX_RIGHT, 170, 10, 110, 20, hwnd,
			                           (HMENU)ID_ISP_CTRL, myHInstance, NULL);
		hTFOutGaugePort = CreateWindowExW(WS_EX_CLIENTEDGE, L"EDIT", gszOutGaugePort, WS_VISIBLE | WS_CHILD | WS_EX_RIGHT, 170, 10 + cVertStep, 110, 20, hwnd,
							              (HMENU)ID_OGP_CTRL, myHInstance, NULL);
		hTFAdminPass = CreateWindowExW(WS_EX_CLIENTEDGE, L"EDIT", adminPass.c_str(), WS_VISIBLE | WS_CHILD | WS_EX_RIGHT | ES_PASSWORD , 170, 10 + (2*cVertStep),
			                           110, 20, hwnd, (HMENU)ID_ADMP_CTRL, myHInstance, NULL);

		hLBMessages = CreateWindowExW(WS_EX_CLIENTEDGE, L"LISTBOX", L"", WS_VISIBLE | WS_CHILD | WS_VSCROLL | WS_HSCROLL, 10, 10 + (3*cVertStep), 270, 8*cVertStep,
								      hwnd, (HMENU)ID_MSGS_CTRL, myHInstance, NULL);
		
		hBLaunchLFS = CreateWindowW(L"BUTTON", L"Launch LFS", WS_VISIBLE | WS_CHILD | BS_PUSHBUTTON, 10, 10 + (11*cVertStep), 80, 20, hwnd,
			                        (HMENU)ID_LAUNCHLFS_BTN, myHInstance, NULL);
		hBQuit = CreateWindowW(L"BUTTON", L"Quit", WS_VISIBLE | WS_CHILD | BS_PUSHBUTTON, 220, 10 + (11*cVertStep), 60, 20, hwnd,
			                   (HMENU)ID_QUIT_BTN, myHInstance, NULL);

		if (autoLaunch) {
			if (LaunchLFS(insimPort))
				InitLFSIFace(insimPort, outgaugePort, adminPass.c_str());
		}
		break;
	case WM_CLOSE:
		DestroyWindow(hwnd);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	case WM_COMMAND:
		switch (wParam) {
			case ID_QUIT_BTN:
				PostMessage(myHWnd, WM_CLOSE, 0, 0);
				break;
			case ID_LAUNCHLFS_BTN:
				if (ParseUserInput())
					if (LaunchLFS(isPort))
						InitLFSIFace(isPort, ogPort, gszAdminPass); /* Launch using user values */
				break;
		}
		break;
	default:
		return DefWindowProcW(hwnd, msg, wParam, lParam);
	}

	return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	UNREFERENCED_PARAMETER(hInstance);
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);
	UNREFERENCED_PARAMETER(nCmdShow);

	hLogMutex = CreateMutexW(NULL, FALSE, L"G27LEDS_APP_INTERNAL_LOGMUTEX");
	if (hLogMutex == NULL || hLogMutex == INVALID_HANDLE_VALUE) {
		MessageBoxW(NULL, L"Unable to create LogMutex.", L"Initialization error", MB_OK | MB_ICONERROR);
		return 1;
	}
	LoadCfgFromFile();
	if (!InitDLLIFace())
		return 1;

	if (debugLevel & DEBUG_LOG_FILE) {
		remove(LOG_FILENAME);
		fileLogger.open(LOG_FILENAME, std::ios::out);
		if (!fileLogger.is_open())
			MessageBoxW(NULL, L"WARNING: Unable to open \"g27.log\" for writing.", L"File error.", MB_OK | MB_ICONWARNING);
		else
			LogToFile(L"G27 LEDs mod for LFS version " VERSION_MAJ L"." VERSION_MIN);
	}
	if (checkMD5) {
		if (!CheckFilesMD5(L"dinput8.dll", szDInput8DLLMD5))
			return 1;
	} else
		LogToFile(L"(WARN)MD5 checking disabled in the config file.");

	gszInSimPort = new WCHAR[IntLength(insimPort) + 1];
	gszOutGaugePort = new WCHAR[IntLength(outgaugePort) + 1];
	wsprintfW(gszInSimPort, L"%u", insimPort);
	wsprintfW(gszOutGaugePort, L"%u", outgaugePort);

	myHInstance = GetModuleHandleW(NULL);
	WNDCLASSEXW wcx;
	MSG msg;

	//TODO: Check for presence of LFS.exe and dinput8.dll in the current working dir

	wcx.cbSize = sizeof(WNDCLASSEXW);
	wcx.style = 0;
	wcx.lpfnWndProc = &WndProc;
	wcx.cbClsExtra = 0;
	wcx.cbWndExtra = 0;
	wcx.hInstance = myHInstance;
	wcx.hIcon = LoadIconW(NULL, IDI_APPLICATION);
	wcx.hCursor = LoadCursorW(NULL, IDC_ARROW);
	wcx.hbrBackground = (HBRUSH)(COLOR_WINDOW);
	wcx.lpszMenuName = NULL;
	wcx.lpszClassName = gszMyClassName;
	wcx.hIconSm = LoadIconW(NULL, IDI_APPLICATION);

	/* Register window class, exit on failure */
	if (RegisterClassExW(&wcx) == 0) {
		MessageBoxW(NULL, L"Failed to register window class.", L"Critical error", MB_OK | MB_ICONERROR);
		return 1;
	}
	/* Create window */
	myHWnd = CreateWindowExW(WS_EX_CLIENTEDGE, gszMyClassName, gszWindowCaption, WS_MINIMIZEBOX | WS_CAPTION | WS_SYSMENU, CW_USEDEFAULT, CW_USEDEFAULT, winWidth,
		                     winHeight, NULL, NULL, myHInstance, NULL);
	if (myHWnd == 0) {
		MessageBoxW(NULL, L"Failed to create window.", L"Critical error", MB_OK | MB_ICONERROR);
		return 1;
	}

	ShowWindow(myHWnd, nCmdShow);
	UpdateWindow(myHWnd);

	/* Beta version information */
	LogToFile(L"(WARN)This is a testing version!");

	if (!InitMsgIFace()) {
		DestroyWindow(myHWnd);
		return 1;
	}

	while (GetMessageW(&msg, myHWnd, 0, 0) > 0) {
		TranslateMessage(&msg);
		DispatchMessageW(&msg);
	}
	myHWnd = 0;

	ShutdownLFSIFace();
	if (fileLogger.is_open())
		fileLogger.close();

	return 0;
}