#ifndef CONFIGLOADER_H
#define CONFIGLOADER_H

#include "Global.h"
#include <fstream>
#include <iostream>
#include <map>
#include <string>
#include <vector>

#define DEBUG_LOG_WINDOW 0x1
#define DEBUG_LOG_FILE 0x2

typedef VOID (*KeywordHandler)(std::vector<std::string>&);

typedef struct {
	float firstLeds;
	float redline;
} rpmData;

/* Configuration options */
extern std::wstring adminPass;
extern BOOL autoLaunch;
extern BOOL checkMD5;
extern UINT debugLevel;
extern USHORT insimPort;
extern USHORT outgaugePort;
extern USHORT pitLimiterDelay;
extern std::map<std::string, rpmData> rpms;

BOOL LoadCfgFromFile();

static VOID ParseConfig(std::ifstream& file);
static std::vector<std::string> ParseLine(std::string& line);
static inline VOID StrToLower(std::string& str);
static inline VOID StrToUpper(std::string& str);

static VOID KWHAdminPass(std::vector<std::string>& tokens);
static VOID KWHAutoLaunch(std::vector<std::string>& tokens);
static VOID KWHCheckMD5(std::vector<std::string>& tokens);
static VOID KWHDebug(std::vector<std::string>& tokens);
static VOID KWHInSimPort(std::vector<std::string>& tokens);
static VOID KWHOutGaugePort(std::vector<std::string>& tokens);
static VOID KWHPitLimiter(std::vector<std::string>& tokens);
static VOID KWHRpm(std::vector<std::string>& tokens);

#endif