#include "stdafx.h"
#include "ConfigLoader.h"
#include <sstream>

std::map<std::string, KeywordHandler> keywords;
char commentMark = '#';

#define CHECK_LINE(t, num) if (t.size() < num) { return; }

/* Set defaults */
std::wstring adminPass = L"";
BOOL autoLaunch = FALSE;
BOOL checkMD5 = TRUE;
UINT debugLevel = FALSE;
USHORT insimPort = 29999;
USHORT outgaugePort = 30000;
USHORT pitLimiterDelay = 0;
std::map<std::string, rpmData> rpms;

BOOL LoadCfgFromFile()
{
	/* Initialize RPM maps */
	rpms["XFG"].firstLeds = 5000;
	rpms["XFG"].redline = 8000;
	rpms["UF1"].firstLeds = 4000;
	rpms["UF1"].redline = 7000;
	rpms["XRG"].firstLeds = 4000;
	rpms["XRG"].redline = 7000;
	rpms["LX4"].firstLeds = 6000;
	rpms["LX4"].redline = 9000;
	rpms["LX6"].firstLeds = 6000;
	rpms["LX6"].redline = 9000;
	rpms["RB4"].firstLeds = 4500;
	rpms["RB4"].redline = 7500;
	rpms["FXO"].firstLeds = 4500;
	rpms["FXO"].redline = 7500;
	rpms["XRT"].firstLeds = 4500;
	rpms["XRT"].redline = 7500;
	rpms["RAC"].firstLeds = 4000;
	rpms["RAC"].redline = 7000;
	rpms["FZ5"].firstLeds = 5000;
	rpms["FZ5"].redline = 8000;
	rpms["UFR"].firstLeds = 6000;
	rpms["UFR"].redline = 9000;
	rpms["XFR"].firstLeds = 5000;
	rpms["XFR"].redline = 9000;
	rpms["FXR"].firstLeds = 4500;
	rpms["FXR"].redline = 7500;
	rpms["XRR"].firstLeds = 4500;
	rpms["XRR"].redline = 7500;
	rpms["FZR"].firstLeds = 5500;
	rpms["FZR"].redline = 8500;
	rpms["MRT"].firstLeds = 7000;
	rpms["MRT"].redline = 10000;
	rpms["FBM"].firstLeds = 6000;
	rpms["FBM"].redline = 9000;
	rpms["FOX"].firstLeds = 4500;
	rpms["FOX"].redline = 7500;
	rpms["FO8"].firstLeds = 6500;
	rpms["FO8"].redline = 9500;
	rpms["BF1"].firstLeds = 14000;
	rpms["BF1"].redline = 20500;

	std::ifstream cfgFile;
	cfgFile.open("g27leds.cfg", std::ios::in);
	if (!cfgFile.is_open()) {
		MessageBox(NULL, L"Unable to open config file, using defaults.", L"Configuration error", MB_OK | MB_ICONWARNING);
		return FALSE;
	}

	/* Setup keywords */
	keywords.insert(std::make_pair("admin_pass", &KWHAdminPass));
	keywords.insert(std::make_pair("autolaunch", &KWHAutoLaunch));
	keywords.insert(std::make_pair("checkmd5", &KWHCheckMD5));
	keywords.insert(std::make_pair("debug", &KWHDebug));
	keywords.insert(std::make_pair("insim_port", &KWHInSimPort));
	keywords.insert(std::make_pair("outgauge_port", &KWHOutGaugePort));
	keywords.insert(std::make_pair("pit_limiter", &KWHPitLimiter));
	keywords.insert(std::make_pair("rpm", &KWHRpm));

	ParseConfig(cfgFile);

	cfgFile.close();
	return TRUE;
}

static VOID ParseConfig(std::ifstream& file)
{
	while (file.good()) {
		std::string line;
		std::getline(file, line);
		StrToLower(line);

		std::vector<std::string> cfgLine = ParseLine(line);
		if (cfgLine.size() == 0)
			continue;

		std::map<std::string, KeywordHandler>::const_iterator cit = keywords.find(cfgLine.front());
		if (cit != keywords.end())
			cit->second(cfgLine);

	}

}

static std::vector<std::string> ParseLine(std::string& line)
{
	std::vector<std::string> entries;

	/* Cut the commented out section */
	size_t idx = line.find_first_of(commentMark);
	line = line.substr(0, idx);
	if (line.length() == 0)
		return entries;

	while (true) {
		idx = line.find_first_of(' ');
		entries.push_back(line.substr(0, idx));

		OutputDebugStringA(entries.back().c_str());
		OutputDebugStringA("|");

		if (idx == std::string::npos)
			break;

		line = line.substr(idx + 1);
	}
	OutputDebugStringA("\n");

	return entries;
}

static inline VOID StrToLower(std::string& str)
{
	for (UINT i = 0; i < str.length(); i++)
		str[i] = tolower(str.at(i));
}

static inline VOID StrToUpper(std::string& str)
{
	for (UINT i = 0; i < str.length(); i++)
		str[i] = toupper(str.at(i));
}

static VOID KWHAdminPass(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 2);

	std::wstring wsT(tokens[1].begin(), tokens[1].end());
	adminPass = wsT.substr(0, 15);
}

static VOID KWHAutoLaunch(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 2);

	UINT yes = strtoul(tokens[1].c_str(), NULL, 10);
	autoLaunch = (yes > 0) ? TRUE : FALSE;
}

static VOID KWHCheckMD5(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 2);

	UINT yes = strtoul(tokens[1].c_str(), NULL, 10);
	checkMD5 = (yes > 0) ? TRUE : FALSE;
}

static VOID KWHDebug(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 2);

	UINT lvl = strtoul(tokens[1].c_str(), NULL, 10);

	if (lvl > 0 && lvl <= (DEBUG_LOG_FILE | DEBUG_LOG_WINDOW))
		debugLevel = lvl;
	else
		debugLevel = 0;
}

static VOID KWHInSimPort(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 2);

	UINT i = strtoul(tokens[1].c_str(), NULL, 10);

	if (i <= 65536 && i > 0)
		insimPort = i;
}

static VOID KWHOutGaugePort(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 2);

	UINT i = strtoul(tokens[1].c_str(), NULL, 10);

	if (i <= 65536 && i > 0)
		outgaugePort = i;
}

static VOID KWHPitLimiter(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 2);

	UINT val = strtoul(tokens[1].c_str(), NULL, 10);
	pitLimiterDelay = static_cast<USHORT>(val);
}

static VOID KWHRpm(std::vector<std::string>& tokens)
{
	CHECK_LINE(tokens, 4);

	StrToUpper(tokens[1]); /* Convert car ID to upper case */
	std::map<std::string, rpmData>::iterator it = rpms.find(tokens[1]);

	if (it == rpms.end())
		return; /* Invalid car type */

	int first = strtoul(tokens[2].c_str(), NULL, 10);
	int redline = strtoul(tokens[3].c_str(), NULL, 10);
	if (!first || !redline)
		return; /* RPM can't be zero */
	if (first > redline)
		return; /* Redline can't be below first LEDs */

	it->second.firstLeds = first;
	it->second.redline = redline;
}
