#pragma once
#include <iostream>
#include <fstream>
#include <TlHelp32.h>
#include "DInputDll.h"

class myIDirectInput8: public IDirectInput8
{
public:
    myIDirectInput8(IDirectInput8 *pOriginal);
    virtual ~myIDirectInput8(void);
	
	HRESULT  __stdcall QueryInterface(REFIID riid, LPVOID * ppvObj);
    ULONG    __stdcall AddRef(void);
    ULONG    __stdcall Release(void);

    HRESULT  __stdcall CreateDevice(REFGUID,LPDIRECTINPUTDEVICE8W *,LPUNKNOWN);
    HRESULT  __stdcall EnumDevices(DWORD,LPDIENUMDEVICESCALLBACKW,LPVOID,DWORD);
    HRESULT  __stdcall GetDeviceStatus(REFGUID);
    HRESULT  __stdcall RunControlPanel(HWND,DWORD);
    HRESULT  __stdcall Initialize(HINSTANCE,DWORD);
    HRESULT  __stdcall FindDevice(REFGUID,LPCWSTR,LPGUID);
    HRESULT  __stdcall EnumDevicesBySemantics(LPCWSTR,LPDIACTIONFORMATW,LPDIENUMDEVICESBYSEMANTICSCBW,LPVOID,DWORD);
    HRESULT  __stdcall ConfigureDevices(LPDICONFIGUREDEVICESCALLBACK,LPDICONFIGUREDEVICESPARAMSW,DWORD,LPVOID);

private:
	static BOOL CALLBACK MyDevEnumCallBack(const DIDEVICEINSTANCE*, VOID*);
	static const long G27ID = 0xC29B046D;
	static const long G29ID = 0xC24F046D;
	static const long DFPID = 0xC298046D;

	IDirectInput8 *m_pIDirectInput8;

	void LogMessage(LPCWSTR msg);
};

class myIDirectInputDevice8: public IDirectInputDevice8
{
public:
    myIDirectInputDevice8(IDirectInputDevice8 *pOriginal, int iInterfaceNumber, GUID g);
    virtual ~myIDirectInputDevice8(void);

	HRESULT  __stdcall QueryInterface(REFIID riid, LPVOID * ppvObj);
    ULONG    __stdcall AddRef(void);
    ULONG    __stdcall Release(void);
    
    HRESULT  __stdcall GetCapabilities(LPDIDEVCAPS);
    HRESULT  __stdcall EnumObjects(LPDIENUMDEVICEOBJECTSCALLBACKW,LPVOID,DWORD);
    HRESULT  __stdcall GetProperty(REFGUID,LPDIPROPHEADER);
    HRESULT  __stdcall SetProperty(REFGUID,LPCDIPROPHEADER);
    HRESULT  __stdcall Acquire(void);
    HRESULT  __stdcall Unacquire(void);
    HRESULT  __stdcall GetDeviceState(DWORD,LPVOID);
    HRESULT  __stdcall GetDeviceData(DWORD,LPDIDEVICEOBJECTDATA,LPDWORD,DWORD);
    HRESULT  __stdcall SetDataFormat(LPCDIDATAFORMAT);
    HRESULT  __stdcall SetEventNotification(HANDLE);
    HRESULT  __stdcall SetCooperativeLevel(HWND,DWORD);
    HRESULT  __stdcall GetObjectInfo(LPDIDEVICEOBJECTINSTANCEW,DWORD,DWORD);
    HRESULT  __stdcall GetDeviceInfo(LPDIDEVICEINSTANCEW);
    HRESULT  __stdcall RunControlPanel(HWND,DWORD);
    HRESULT  __stdcall Initialize(HINSTANCE,DWORD,REFGUID);
	
	HRESULT  __stdcall CreateEffect(REFGUID,LPCDIEFFECT,LPDIRECTINPUTEFFECT *,LPUNKNOWN);
    HRESULT  __stdcall EnumEffects(LPDIENUMEFFECTSCALLBACKW,LPVOID,DWORD);
    HRESULT  __stdcall GetEffectInfo(LPDIEFFECTINFOW,REFGUID);
    HRESULT  __stdcall GetForceFeedbackState(LPDWORD);
    HRESULT  __stdcall SendForceFeedbackCommand(DWORD);
    HRESULT  __stdcall EnumCreatedEffectObjects(LPDIENUMCREATEDEFFECTOBJECTSCALLBACK,LPVOID,DWORD);
    HRESULT  __stdcall Escape(LPDIEFFESCAPE);
    HRESULT  __stdcall Poll(void);
    HRESULT  __stdcall SendDeviceData(DWORD,LPCDIDEVICEOBJECTDATA,LPDWORD,DWORD);
    HRESULT  __stdcall EnumEffectsInFile(LPCWSTR,LPDIENUMEFFECTSINFILECALLBACK,LPVOID,DWORD);
    HRESULT  __stdcall WriteEffectToFile(LPCWSTR,DWORD,LPDIFILEEFFECT,DWORD);
    HRESULT  __stdcall BuildActionMap(LPDIACTIONFORMATW,LPCWSTR,DWORD);
    HRESULT  __stdcall SetActionMap(LPDIACTIONFORMATW,LPCWSTR,DWORD);
    HRESULT  __stdcall GetImageInfo(LPDIDEVICEIMAGEINFOHEADERW);

private:
    IDirectInputDevice8 *m_pIDirectInputDevice8;
	int                  m_iInterfaceNumber;
	GUID				 m_GUID;

	/* G27 LEDs specific data */
	bool inited;
	bool shmOK;
	volatile bool runTimer;
	volatile bool updateRPM;
	DWORD lfsPID;
	DWORD timerThreadID;
	HANDLE hDataUpdated;
	HANDLE hMapFile;
	WheelData wheelData;
	DIEFFESCAPE escData;

	#pragma pack(1)
	struct SharedData {
		float rpm;
		float firstLeds;
		float redline;
		UINT debug;
	} sharedData;

	bool IsProcessRunning(const WCHAR*);
	void LogMessage(LPCWSTR msg);
	bool ReadFromSharedMem();

	#define ESCAPE_COMMAND_LEDS 0
	#define LEDS_VERSION_NUMBER 0x00000001;
};

class myIDirectInputEffect: public IDirectInputEffect
{
public:
    myIDirectInputEffect(IDirectInputEffect *pOriginal, int iFaceNum);
    virtual ~myIDirectInputEffect(void);
	
	HRESULT  __stdcall QueryInterface(REFIID riid, LPVOID * ppvObj);
    ULONG    __stdcall AddRef(void);
    ULONG    __stdcall Release(void);

    HRESULT  __stdcall Initialize(HINSTANCE,DWORD,REFGUID);
    HRESULT  __stdcall GetEffectGuid(LPGUID);
    HRESULT  __stdcall GetParameters(LPDIEFFECT,DWORD);
    HRESULT  __stdcall SetParameters(LPCDIEFFECT,DWORD);
	HRESULT  __stdcall Start(DWORD,DWORD);
    HRESULT  __stdcall Stop(void);
    HRESULT  __stdcall GetEffectStatus(LPDWORD);
    HRESULT  __stdcall Download(void);
    HRESULT  __stdcall Unload(void);
    HRESULT  __stdcall Escape(LPDIEFFESCAPE);

private:
    IDirectInputEffect *m_pIDirectInputEffect;
	int m_interfaceNumber;

	/* G27 LEDs specific */
	WheelData wheelData;
	DIEFFESCAPE escData;
};
 
//WINMMAPI MMRESULT WINAPI joyConfigChanged( DWORD dwFlags );
//void WINAPI ShowJoyCPL( HWND hWnd );