#include "StdAfx.h"
#include "myIDinput.h"
#include "DInputDll.h"
#include <sstream>
#include <vector>

// ---------------------------------------------------------------------------------------------------
myIDirectInput8::myIDirectInput8(IDirectInput8 *pOriginal)
{	
	m_pIDirectInput8 = pOriginal;

	/* Init output to debug file */
	LogMessage(L"DI> Initializing DirectInput8 interface");
}

myIDirectInput8::~myIDirectInput8(void)
{
}

HRESULT  myIDirectInput8::QueryInterface(REFIID riid, LPVOID * ppvObj)
{ 
	*ppvObj = NULL;

	// call this to increase AddRef at original object
	// and to check if such an interface is there

	HRESULT hRes = m_pIDirectInput8->QueryInterface(riid, ppvObj); 

	if (hRes == NOERROR) // if OK, send our "fake" address
	{
		*ppvObj = this;
	}
	
	return hRes;
}

ULONG    myIDirectInput8::AddRef(void)
{ return(m_pIDirectInput8->AddRef()); }

ULONG    myIDirectInput8::Release(void)
{ 
	extern myIDirectInput8* gl_pmyIDirectInput8;

	// call original routine
	ULONG count = m_pIDirectInput8->Release();
	
    // in case no further Ref is there, the Original Object has deleted itself
	// so do we here
	if (count == 0) 
	{
		LogMessage(L"DI> Disposing DI8.");
		
		gl_pmyIDirectInput8 = NULL;
  	    delete(this); 
	}

	return(count);
}

HRESULT myIDirectInput8::CreateDevice(REFGUID a, LPDIRECTINPUTDEVICE8W *b, LPUNKNOWN c)
{
	extern std::vector<GUID> gl_myG27Instance;
	std::vector<GUID>::const_iterator cit;
	for (cit = gl_myG27Instance.begin(); cit < gl_myG27Instance.end(); cit++) {
		if (IsEqualCLSID(a, *cit)) {
			/* A G27 (or DFP) found, take control over this device */
			// global var
			extern myIDirectInputDevice8* gl_pmyIDirectInputDevice8Array[];

			LogMessage(L"DI::CreateDevice> Creating DIDevice");

			// we intercept this call and provide our own "fake" Device Object
			HRESULT hres = m_pIDirectInput8->CreateDevice(a,b,c);

			// find free Device slot
			int i;
			for (i=0; i<MAXNUMBER_DEVICES; i++)
				if (gl_pmyIDirectInputDevice8Array[i] == NULL) break;
	
			// Create our own Device object and store it in global pointer
			// note: the object will delete itself once Ref count is zero (similar to COM objects)
			gl_pmyIDirectInputDevice8Array[i] = new myIDirectInputDevice8(*b, i, *cit);
	
			// store our pointer (the fake one) for returning it to the calling progam
			*b = gl_pmyIDirectInputDevice8Array[i];

			LPOLESTR guidHash;
			HRESULT guidHRes = StringFromCLSID(a, &guidHash);
			if (guidHRes == S_OK) {
				std::wostringstream oss;
				oss << L"DI::CreateDevice> Creating DIDevice, GUID " << guidHash;
				LogMessage(oss.str().c_str());
				CoTaskMemFree(guidHash);
			} else
				LogMessage(L"(WARN)DI::CreateDevice> Unable to convert GUID to string.");
		
			if (hres == S_OK)
				LogMessage(L"DI::CreateDevice> Device sucessfully created.");
			else
				LogMessage(L"(WARN)DI::CreateDevice> Unable to create device.");

			return(hres);
		}
	}

	/* Not a G27 (or DFP), don't touch this device */
	LogMessage(L"DI::CreateDevice> Not a G27, ignoring.");
	return m_pIDirectInput8->CreateDevice(a, b, c);
}

HRESULT  myIDirectInput8::EnumDevices(DWORD a, LPDIENUMDEVICESCALLBACKW b, LPVOID c, DWORD d)
{
	m_pIDirectInput8->EnumDevices(a, MyDevEnumCallBack, c, d);
	return m_pIDirectInput8->EnumDevices(a, b, c, d);
}

HRESULT  myIDirectInput8::GetDeviceStatus(REFGUID a)
{ return(m_pIDirectInput8->GetDeviceStatus(a)); }

HRESULT  myIDirectInput8::RunControlPanel(HWND a, DWORD b)
{ return(m_pIDirectInput8->RunControlPanel(a, b)); }

HRESULT  myIDirectInput8::Initialize(HINSTANCE a, DWORD b)
{ return(m_pIDirectInput8->Initialize(a, b)); }

HRESULT  myIDirectInput8::FindDevice(REFGUID a, LPCWSTR b, LPGUID c)
{ return(m_pIDirectInput8->FindDevice(a, b, c)); }

HRESULT  myIDirectInput8::EnumDevicesBySemantics(LPCWSTR a, LPDIACTIONFORMATW b, LPDIENUMDEVICESBYSEMANTICSCBW c, LPVOID d, DWORD e)
{ return(m_pIDirectInput8->EnumDevicesBySemantics(a,b,c,d,e)); }

HRESULT  myIDirectInput8::ConfigureDevices(LPDICONFIGUREDEVICESCALLBACK a, LPDICONFIGUREDEVICESPARAMSW b, DWORD c, LPVOID d)
{ return(m_pIDirectInput8->ConfigureDevices(a,b,c,d)); }

BOOL CALLBACK myIDirectInput8::MyDevEnumCallBack(const DIDEVICEINSTANCE* inst, VOID* context)
{
	UNREFERENCED_PARAMETER(context);

	extern std::vector<GUID> gl_myG27Instance;

	if ((inst->guidProduct.Data1 == G27ID) ||
		(inst->guidProduct.Data1 == G29ID) /* || (inst->guidProduct.Data1 == DFPID) */) {
		/* Check if we already have this device added */
		if (gl_myG27Instance.size() > 20)
			return DIENUM_CONTINUE;

		for (std::vector<GUID>::const_iterator cit = gl_myG27Instance.begin(); cit != gl_myG27Instance.end(); cit++) {
			if (IsEqualCLSID(inst->guidProduct, *cit))
				return DIENUM_CONTINUE;
		}
		
		gl_myG27Instance.push_back(inst->guidInstance);
	}

	return DIENUM_CONTINUE;
}

void myIDirectInput8::LogMessage(LPCWSTR msg)
{
	extern HANDLE gl_hMsgEvent;
	extern HANDLE gl_hMsgMutex;
	extern HANDLE gl_hMsgSHM;

	while (gl_hMsgSHM) {
		DWORD dwWait = WaitForSingleObject(gl_hMsgMutex, INFINITE);

		switch (dwWait) {
		case WAIT_OBJECT_0:
		{
			SharedMsg* pMsg = (SharedMsg*)MapViewOfFile(gl_hMsgSHM, FILE_MAP_ALL_ACCESS, 0, 0, sizeof(SharedMsg));
			if (!pMsg) {
				if (!gl_hMsgSHM) /* The handle has already been closed while we were waiting for the mutex */
					return;
				CloseHandle(gl_hMsgSHM);
				gl_hMsgSHM = NULL;
				ReleaseMutex(gl_hMsgMutex);
				return;
			}
			
			/* The main application stopped its receiving thread */
			if (pMsg->fClosed) {
				CloseHandle(gl_hMsgSHM);
				gl_hMsgSHM = NULL;
				ReleaseMutex(gl_hMsgMutex);
				UnmapViewOfFile(pMsg);
				return;
			}

			/* There is an unread message, wait until it is processed */
			if (!pMsg->fPending) {
				wcscpy_s(pMsg->msgTxt, sizeof(WCHAR)*128, msg);
				pMsg->fPending = TRUE;
				ReleaseMutex(gl_hMsgMutex);
				SetEvent(gl_hMsgEvent);

				UnmapViewOfFile(pMsg);
				return;
			}
			ReleaseMutex(gl_hMsgMutex); /* Give the processing thread a chance to read the message from SHM */
			UnmapViewOfFile(pMsg);
			break;
		}
		default:
			return;
		}
	}

	return;
}
// ---------------------------------------------------------------------------------------------------
myIDirectInputDevice8::myIDirectInputDevice8(IDirectInputDevice8 *pOriginal, int iInterfaceNumber, GUID g) :
	shmOK(false)
{   
	m_iInterfaceNumber     = iInterfaceNumber;
	m_pIDirectInputDevice8 = pOriginal;
	m_GUID = g;

	/* G27 LEDS speficic stuff */
	ZeroMemory(&wheelData, sizeof(wheelData));

	wheelData.size = sizeof(WheelData);
	wheelData.versionNbr = LEDS_VERSION_NUMBER;
	wheelData.rpmData.currentRPM = 0.0f;
	wheelData.rpmData.rpmFirstLedTurnsOn = 3000.0f;
	wheelData.rpmData.rpmRedLine = 6950.0f;

	ZeroMemory(&escData, sizeof(escData));
		
	escData.dwSize = sizeof(DIEFFESCAPE);
	escData.dwCommand = ESCAPE_COMMAND_LEDS;
	escData.lpvInBuffer = &wheelData;
	escData.cbInBuffer = sizeof(wheelData);

	/* Access shared memory */
	hMapFile = OpenFileMappingA(FILE_MAP_READ, FALSE, "G27LEDS_SHM");
	if (hMapFile == NULL)
		LogMessage(L"(ERR)DIDEV::> Unable to open SHM.");
	
	hDataUpdated = OpenMutexA(MUTEX_ALL_ACCESS, NULL, "G27LEDS_SHMMUTEX");
	if (hDataUpdated == NULL) {
		LogMessage(L"(ERR)DIDEV::> Unable to open SHM mutex.");
		CloseHandle(hMapFile);
	} else
		shmOK = true;
}

myIDirectInputDevice8::~myIDirectInputDevice8(void)
{
}

HRESULT  myIDirectInputDevice8::QueryInterface(REFIID riid, LPVOID * ppvObj)
{ 
	*ppvObj = NULL;

	// call this to increase AddRef at original object
	// and to check if such an interface is there

	HRESULT hRes = m_pIDirectInputDevice8->QueryInterface(riid, ppvObj); 

	if (hRes == NOERROR) // if OK, send our "fake" address
	{
		*ppvObj = this;
	}
	
	return hRes;
}

ULONG    myIDirectInputDevice8::AddRef(void)
{ return(m_pIDirectInputDevice8->AddRef()); }

ULONG    myIDirectInputDevice8::Release(void)
{ 
    extern myIDirectInputDevice8* gl_pmyIDirectInputDevice8Array[];
	extern myIDirectInputEffect*  gl_pmyIDirectInputEffectArray[];
	extern std::vector<GUID> gl_myG27Instance;

	/* Try to switch the LEDs off */
	wheelData.rpmData.currentRPM = 0.0f;
	wheelData.rpmData.rpmFirstLedTurnsOn = 1.0f;
	wheelData.rpmData.rpmRedLine = 2.0f;

	//Find an active effect we can sent the LEDs command through
	int i;
	for (i = 0; i < MAXNUMBER_EFFECTS; i++) {
		if (gl_pmyIDirectInputEffectArray[i] != NULL) {
			gl_pmyIDirectInputEffectArray[i]->Escape(&escData);
			break;
		}
	}

	// call original routine
	ULONG count = m_pIDirectInputDevice8->Release();

    // in case no further Ref is there, the Original Object has deleted itself
	// so do we here
	if (count == 0) {	
		/* G27 LEDs specific stuff */

		LPOLESTR guidHash;
		HRESULT guidHRes = StringFromCLSID(m_GUID, &guidHash);
		if (guidHRes == S_OK) {
			std::wostringstream oss;
			oss << L"DIDEV::Release> Release requested, cleaning up (GUID " << guidHash << ")";
			LogMessage(oss.str().c_str());
		} else {
			LogMessage(L"(WARN)DIDEV::Release> Unable to convert GUID to string.");
			guidHash = L"N/A";
		}

		/* Remove device from the G27 list */
		std::vector<GUID>::iterator it;
		for (it = gl_myG27Instance.begin(); it != gl_myG27Instance.end(); it++) {
			if (IsEqualCLSID(m_GUID, *it)) {
				gl_myG27Instance.erase(it);

				std::wostringstream oss;
				oss << "DIDEV::Release> Removing device with GUID " << guidHash;
				LogMessage(oss.str().c_str());
				break;
			}
		}
		if (guidHRes == S_OK)
			CoTaskMemFree(guidHash);

		LogMessage(L"DIDEV::Release> Cleanup complete, exiting.");	

		if (hMapFile)
			CloseHandle(hMapFile);
		if (hDataUpdated)
			CloseHandle(hDataUpdated);

		gl_pmyIDirectInputDevice8Array[m_iInterfaceNumber] = NULL;
		delete(this); 
	}

	return(count);
}

HRESULT  myIDirectInputDevice8::GetCapabilities(LPDIDEVCAPS a)
{ return(m_pIDirectInputDevice8->GetCapabilities(a)); }

HRESULT  myIDirectInputDevice8::EnumObjects(LPDIENUMDEVICEOBJECTSCALLBACKW a, LPVOID b, DWORD c)
{ return(m_pIDirectInputDevice8->EnumObjects(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetProperty(REFGUID a,LPDIPROPHEADER b)
{ return(m_pIDirectInputDevice8->GetProperty(a,b)); }

HRESULT  myIDirectInputDevice8::SetProperty(REFGUID a,LPCDIPROPHEADER b)
{ return(m_pIDirectInputDevice8->SetProperty(a,b)); }

HRESULT  myIDirectInputDevice8::Acquire(void)
{ return(m_pIDirectInputDevice8->Acquire()); }

HRESULT  myIDirectInputDevice8::Unacquire(void)
{ return(m_pIDirectInputDevice8->Unacquire()); }

HRESULT  myIDirectInputDevice8::GetDeviceState(DWORD a,LPVOID b)
{
	extern myIDirectInputEffect* gl_pmyIDirectInputEffectArray[];

	if (shmOK) {
		if (!ReadFromSharedMem()) {
			LogMessage(L"(WARN)DIDEV::GetDeviceState> Error reading data from shared memory.");
			return m_pIDirectInputDevice8->GetDeviceState(a, b);
		}

		wheelData.rpmData.currentRPM = sharedData.rpm;
		wheelData.rpmData.rpmFirstLedTurnsOn = sharedData.firstLeds;
		wheelData.rpmData.rpmRedLine = sharedData.redline;

		// WORKING ? (apparently yes)
		/* Find a DirectInputEffect we can use to send the LED command through */
		int i;
		for (i = 0; i < MAXNUMBER_EFFECTS; i++) {
			if (gl_pmyIDirectInputEffectArray[i] != NULL) {
				HRESULT hrEsc = gl_pmyIDirectInputEffectArray[i]->Escape(&escData);
				if (sharedData.debug > 0) {
					std::wostringstream oss;
					oss << std::hex << hrEsc << L" RPM: " << std::dec << sharedData.rpm;
					LogMessage(oss.str().c_str());
				}
				break;
			}
		}
		if (i == MAXNUMBER_EFFECTS) {
			LogMessage(L"(ERR)DIDEV::GetDeviceState> No FFB object found. Make sure Force Feedback is enabled in LFS.");
			return m_pIDirectInputDevice8->GetDeviceState(a,b);
		}

		/** Through the gates of hell,
			as we make our way to heaven... */
	} else
		LogMessage(L"(ERR)DIDEV::>GetDeviceState> SHM not available!");

	return m_pIDirectInputDevice8->GetDeviceState(a,b);
}

HRESULT  myIDirectInputDevice8::GetDeviceData(DWORD a,LPDIDEVICEOBJECTDATA b,LPDWORD c,DWORD d)
{ return(m_pIDirectInputDevice8->GetDeviceData(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::SetDataFormat(LPCDIDATAFORMAT a)
{ return(m_pIDirectInputDevice8->SetDataFormat(a)); }

HRESULT  myIDirectInputDevice8::SetEventNotification(HANDLE a)
{ return(m_pIDirectInputDevice8->SetEventNotification(a)); }

HRESULT  myIDirectInputDevice8::SetCooperativeLevel(HWND a,DWORD b)
{ return(m_pIDirectInputDevice8->SetCooperativeLevel(a,b)); }

HRESULT  myIDirectInputDevice8::GetObjectInfo(LPDIDEVICEOBJECTINSTANCEW a,DWORD b,DWORD c)
{ return(m_pIDirectInputDevice8->GetObjectInfo(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetDeviceInfo(LPDIDEVICEINSTANCEW a)
{ return m_pIDirectInputDevice8->GetDeviceInfo(a); }

HRESULT  myIDirectInputDevice8::RunControlPanel(HWND a,DWORD b)
{ return(m_pIDirectInputDevice8->RunControlPanel(a,b)); }

HRESULT  myIDirectInputDevice8::Initialize(HINSTANCE a,DWORD b,REFGUID c)
{ 
	return m_pIDirectInputDevice8->Initialize(a,b,c);
}

HRESULT myIDirectInputDevice8::CreateEffect(REFGUID a,LPCDIEFFECT b,LPDIRECTINPUTEFFECT *c,LPUNKNOWN d)
{	
	extern myIDirectInputEffect* gl_pmyIDirectInputEffectArray[];

	if (sharedData.debug > 0)
		LogMessage(L"DIDEV::CreateEffect> Called");

	HRESULT hr = m_pIDirectInputDevice8->CreateEffect(a,b,c,d);

	//Find free Effect slot
	int i;
	for (i = 0; i < MAXNUMBER_EFFECTS; i++)
		if (gl_pmyIDirectInputEffectArray[i] == NULL) break;
	if (i == MAXNUMBER_EFFECTS)	{ /* We ran our of effect slots, report failure to the calling application and release the effect */
		(*c)->Release();
		return E_FAIL;
	}

	//Create our "fake" effect
	gl_pmyIDirectInputEffectArray[i] = new myIDirectInputEffect(*c, i);

	//Pass pointer to our "fake" effect back to calling application
	*c = gl_pmyIDirectInputEffectArray[i];
	return hr;
}

HRESULT  myIDirectInputDevice8::EnumEffects(LPDIENUMEFFECTSCALLBACKW a,LPVOID b,DWORD c)
{ return(m_pIDirectInputDevice8->EnumEffects(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetEffectInfo(LPDIEFFECTINFOW a,REFGUID b)
{ return(m_pIDirectInputDevice8->GetEffectInfo(a,b)); }

HRESULT  myIDirectInputDevice8::GetForceFeedbackState(LPDWORD a)
{ return(m_pIDirectInputDevice8->GetForceFeedbackState(a)); }

HRESULT  myIDirectInputDevice8::SendForceFeedbackCommand(DWORD a)
{ return(m_pIDirectInputDevice8->SendForceFeedbackCommand(a)); }

HRESULT  myIDirectInputDevice8::EnumCreatedEffectObjects(LPDIENUMCREATEDEFFECTOBJECTSCALLBACK a,LPVOID b,DWORD c)
{ return(m_pIDirectInputDevice8->EnumCreatedEffectObjects(a,b,c)); }

HRESULT  myIDirectInputDevice8::Escape(LPDIEFFESCAPE a)
{ return(m_pIDirectInputDevice8->Escape(a)); }

HRESULT  myIDirectInputDevice8::Poll(void)
{ return(m_pIDirectInputDevice8->Poll());}

HRESULT  myIDirectInputDevice8::SendDeviceData(DWORD a,LPCDIDEVICEOBJECTDATA b,LPDWORD c,DWORD d)
{ return(m_pIDirectInputDevice8->SendDeviceData(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::EnumEffectsInFile(LPCWSTR a,LPDIENUMEFFECTSINFILECALLBACK b,LPVOID c,DWORD d)
{ return(m_pIDirectInputDevice8->EnumEffectsInFile(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::WriteEffectToFile(LPCWSTR a,DWORD b,LPDIFILEEFFECT c,DWORD d)
{ return(m_pIDirectInputDevice8->WriteEffectToFile(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::BuildActionMap(LPDIACTIONFORMATW a,LPCWSTR b,DWORD c)
{ return(m_pIDirectInputDevice8->BuildActionMap(a,b,c)); }

HRESULT  myIDirectInputDevice8::SetActionMap(LPDIACTIONFORMATW a,LPCWSTR b,DWORD c)
{ return(m_pIDirectInputDevice8->SetActionMap(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetImageInfo(LPDIDEVICEIMAGEINFOHEADERW a)
{ return(m_pIDirectInputDevice8->GetImageInfo(a)); }

void myIDirectInputDevice8::LogMessage(LPCWSTR msg)
{
	extern HANDLE gl_hMsgEvent;
	extern HANDLE gl_hMsgMutex;
	extern HANDLE gl_hMsgSHM;

	while (gl_hMsgSHM) {
		DWORD dwWait = WaitForSingleObject(gl_hMsgMutex, INFINITE);

		switch (dwWait) {
		case WAIT_OBJECT_0:
		{
			SharedMsg* pMsg = (SharedMsg*)MapViewOfFile(gl_hMsgSHM, FILE_MAP_ALL_ACCESS, 0, 0, sizeof(SharedMsg));
			if (!pMsg) {
				if (!gl_hMsgSHM) /* The handle has already been closed while we were waiting for the mutex */
					return;
				CloseHandle(gl_hMsgSHM);
				gl_hMsgSHM = NULL;
				ReleaseMutex(gl_hMsgMutex);
				return;
			}

			/* The main application stopped its receiving thread */
			if (pMsg->fClosed) {
				CloseHandle(gl_hMsgSHM);
				gl_hMsgSHM = NULL;
				ReleaseMutex(gl_hMsgMutex);
				UnmapViewOfFile(pMsg);
				return;
			}

			/* There is an unread message, wait until it is processed */
			if (!pMsg->fPending) {
				wcscpy_s(pMsg->msgTxt, sizeof(WCHAR)*128, msg);
				pMsg->fPending = TRUE;
				ReleaseMutex(gl_hMsgMutex);
				SetEvent(gl_hMsgEvent);

				UnmapViewOfFile(pMsg);
				return;
			}
			ReleaseMutex(gl_hMsgMutex); /* Give the processing thread a chance to read the message from SHM */
			UnmapViewOfFile(pMsg);
			break;
		}
		default:
			return;
		}
	}
}

bool myIDirectInputDevice8::ReadFromSharedMem()
{
	if (sharedData.debug > 0)
		LogMessage(L"DIDEV::ReadFromSharedMem> Called.");

	LPVOID pSharedData = MapViewOfFile(hMapFile, FILE_MAP_READ, 0, 0, sizeof(SharedData));
	if (pSharedData == NULL) {
		LogMessage(L"(ERR)DIDEV::ReadFromSharedMem> Null pointer to SHM.");
		shmOK = false;
		return false;
	}

	DWORD ret = WaitForSingleObject(hDataUpdated, 0);
	switch (ret) {
	case WAIT_OBJECT_0:
	{
		CopyMemory(&sharedData, pSharedData, sizeof(sharedData));

		ReleaseMutex(hDataUpdated);
		UnmapViewOfFile(pSharedData);
		return true;
	}
	case WAIT_TIMEOUT:
		if (sharedData.debug > 0)
			LogMessage(L"DIDEV::ReadFromSharedMem> Mutex locked.");

		UnmapViewOfFile(pSharedData);
		return false;
	default:
		{
			std::wostringstream oss;
			oss << "(ERR)DIDEV::ReadFromSharedMem> Cannot claim mutex " << GetLastError() << " RC " << ret;
			LogMessage(oss.str().c_str());
			shmOK = false;
		}
		UnmapViewOfFile(pSharedData);
		return false;
	}
}

// ---------------------------------------------------------------------------------------------------

myIDirectInputEffect::myIDirectInputEffect(IDirectInputEffect *pOriginal, int iFaceNum)
{
	m_pIDirectInputEffect = pOriginal;
	m_interfaceNumber = iFaceNum;
}

myIDirectInputEffect::~myIDirectInputEffect(void)
{ }

HRESULT  myIDirectInputEffect::QueryInterface(REFIID riid, LPVOID * ppvObj)
{ return(m_pIDirectInputEffect->QueryInterface(riid, ppvObj)); }

ULONG    myIDirectInputEffect::AddRef(void)
{ return(m_pIDirectInputEffect->AddRef()); }

ULONG    myIDirectInputEffect::Release(void)
{ 
	extern myIDirectInputEffect* gl_pmyIDirectInputEffectArray[];

	ULONG count = m_pIDirectInputEffect->Release();
	//Our "fake" effect is no longer referenced anywhere, dispose it
	if (count == 0) {
		gl_pmyIDirectInputEffectArray[m_interfaceNumber] = NULL;
		delete(this);
	}

	return count;
}

HRESULT  myIDirectInputEffect::Initialize(HINSTANCE a,DWORD b,REFGUID c)
{ return(m_pIDirectInputEffect->Initialize(a,b,c)); }

HRESULT  myIDirectInputEffect::GetEffectGuid(LPGUID a)
{ return(m_pIDirectInputEffect->GetEffectGuid(a)); }

HRESULT  myIDirectInputEffect::GetParameters(LPDIEFFECT a,DWORD b)
{ return(m_pIDirectInputEffect->GetParameters(a,b)); }

HRESULT  myIDirectInputEffect::SetParameters(LPCDIEFFECT a,DWORD b)
{ return(m_pIDirectInputEffect->SetParameters(a,b)); }

HRESULT  myIDirectInputEffect::Start(DWORD a,DWORD b)
{ return(m_pIDirectInputEffect->Start(a,b)); }

HRESULT  myIDirectInputEffect::Stop(void)
{ return(m_pIDirectInputEffect->Stop()); }

HRESULT  myIDirectInputEffect::GetEffectStatus(LPDWORD a)
{ return(m_pIDirectInputEffect->GetEffectStatus(a)); }

HRESULT  myIDirectInputEffect::Download(void)
{ return(m_pIDirectInputEffect->Download()); }

HRESULT  myIDirectInputEffect::Unload(void)
{ return(m_pIDirectInputEffect->Unload()); }

HRESULT  myIDirectInputEffect::Escape(LPDIEFFESCAPE a)
{ return(m_pIDirectInputEffect->Escape(a)); }