// DInputDll.cpp
#include "stdafx.h"
#include "DInputDll.h"
#include <iostream>
#include <sstream>
#include <string>
#include <vector>

// global variables
#pragma data_seg (".dinput_shared")
myIDirectInputDevice8*     gl_pmyIDirectInputDevice8Array[MAXNUMBER_DEVICES];
myIDirectInput8*           gl_pmyIDirectInput8;
myIDirectInputEffect*      gl_pmyIDirectInputEffectArray[MAXNUMBER_EFFECTS];
std::vector<GUID>		   gl_myG27Instance;
HINSTANCE                  gl_hOriginalDll;
HINSTANCE                  gl_hThisInstance;
/* G27 LEDs specific */
HANDLE					   gl_hMsgSHM;
HANDLE					   gl_hMsgMutex;
HANDLE					   gl_hMsgEvent;
#pragma data_seg ()
SharedMsg				   lc_sharedMsg;


BOOL APIENTRY DllMain( HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	// to avoid compiler lvl4 warnings 
    LPVOID lpDummy = lpReserved;
    lpDummy = NULL;
    
    switch (ul_reason_for_call)
	{
	    case DLL_PROCESS_ATTACH: InitInstance(hModule); break;
	    case DLL_PROCESS_DETACH: ExitInstance(); break;
        
        case DLL_THREAD_ATTACH:  break;
	    case DLL_THREAD_DETACH:  break;
	}
    return TRUE;
}

// Exported function (faking dinput.dll's exports)
HRESULT WINAPI DirectInput8Create(HINSTANCE hinst, DWORD dwVersion, REFIID riidltf, LPVOID *ppvOut, LPUNKNOWN punkOuter)
{
	if (!gl_hOriginalDll) LoadOriginalDll(); // looking for the "right dinput.dll"
	
	typedef HRESULT (WINAPI* DirectInputCreate_Type)(HINSTANCE hinst, DWORD dwVersion, REFIID riidltf, LPVOID *ppvOut, LPUNKNOWN punkOuter);
	DirectInputCreate_Type DirectInputCreate_fn = (DirectInputCreate_Type) GetProcAddress( gl_hOriginalDll, "DirectInput8Create");
    
    // Debug
	if (!DirectInputCreate_fn) 
    {
        ::ExitProcess(0); // exit the hard way
    }
	
	// REVIEW REVIEW REVIEW Instance Handle ! Original or own ? 
	// REVIEW REVIEW REVIEW Check for UNICODE or ANSI (riidltf) !
	HINSTANCE dummy = hinst;
	dummy = NULL;

	// Create real Interface
	LPVOID pIDirectInput_orig;
	HRESULT hr = DirectInputCreate_fn(gl_hThisInstance, dwVersion, riidltf, (LPVOID*) &pIDirectInput_orig, punkOuter);
	
	// Create my IDirectInput object and store pointer to original object there.
	// note: the object will delete itself once Ref count is zero (similar to COM objects)
	
	if (gl_pmyIDirectInput8) gl_pmyIDirectInput8->AddRef();
	else gl_pmyIDirectInput8 = new myIDirectInput8((IDirectInput8*)pIDirectInput_orig);
	
	// Return pointer to hooking Object instead of "real one"
	*ppvOut = gl_pmyIDirectInput8;
	return(hr);
}

// Exported function (faking dinput.dll's exports)
HRESULT WINAPI DllCanUnloadNow(void)
{
	if (!gl_hOriginalDll) LoadOriginalDll(); // looking for the "right dinput.dll"
	
	typedef HRESULT (WINAPI *DllCanUnloadNow_Type)(void);
	DllCanUnloadNow_Type DllCanUnloadNow_fn = (DllCanUnloadNow_Type) GetProcAddress( gl_hOriginalDll, "DllCanUnloadNow");
    
    // Debug
	if (!DllCanUnloadNow_fn) 
    {
        ::ExitProcess(0); // exit the hard way
    }

	// Call original dll and return
	return(DllCanUnloadNow_fn());
}

HRESULT WINAPI DllGetClassObject (const CLSID &rclsid, const IID &riid, void **ppv)
{
	if (!gl_hOriginalDll) LoadOriginalDll(); // looking for the "right dinput.dll"
	
	typedef HRESULT (WINAPI *DllGetClassObject_Type)(const CLSID &rclsid, const IID &riid, void **ppv);
	DllGetClassObject_Type DllGetClassObject_fn = (DllGetClassObject_Type) GetProcAddress( gl_hOriginalDll, "DllGetClassObject");
    
    // Debug
	if (!DllGetClassObject_fn) 
    {
         ::ExitProcess(0); // exit the hard way
    }

	// Call original dll and return
	return(DllGetClassObject_fn(rclsid, riid, ppv));
}

HRESULT WINAPI DllRegisterServer (void)
{
	if (!gl_hOriginalDll) LoadOriginalDll(); // looking for the "right dinput.dll"
	
	typedef HRESULT (WINAPI *DllRegisterServer_Type)(void);
	DllRegisterServer_Type DllRegisterServer_fn = (DllRegisterServer_Type) GetProcAddress( gl_hOriginalDll, "DllRegisterServer");
    
    // Debug
	if (!DllRegisterServer_fn) 
    {
         ::ExitProcess(0); // exit the hard way
    }

	// Call original dll and return
	return(DllRegisterServer_fn());
}

HRESULT WINAPI DllUnregisterServer (void)
{
	if (!gl_hOriginalDll) LoadOriginalDll(); // looking for the "right dinput.dll"
	
	typedef HRESULT (WINAPI *DllUnregisterServer_Type)(void);
	DllUnregisterServer_Type DllUnregisterServer_fn = (DllUnregisterServer_Type) GetProcAddress( gl_hOriginalDll, "DllUnregisterServer");
    
    // Debug
	if (!DllUnregisterServer_fn) 
    {
        ::ExitProcess(0); // exit the hard way
    }

	// Call original dll and return
	return(DllUnregisterServer_fn());
}

void InitInstance(HANDLE hModule) 
{
	// Initialisation
    gl_pmyIDirectInput8       = NULL;
    
	for (int i=0; i<MAXNUMBER_DEVICES; i++) gl_pmyIDirectInputDevice8Array[i] = NULL;
	for (int i=0; i<MAXNUMBER_EFFECTS; i++) gl_pmyIDirectInputEffectArray[i] = NULL;

    gl_hOriginalDll           = NULL;
    gl_hThisInstance          = NULL;
	
	// Storing Instance handle into global var
	gl_hThisInstance = (HINSTANCE)  hModule;

	/* Initialize messaging shared memory */
	ZeroMemory(&lc_sharedMsg, sizeof(SharedMsg));
	gl_hMsgEvent = NULL;
	
	gl_hMsgMutex = OpenMutexA(MUTEX_ALL_ACCESS, FALSE, "G27LEDS_SHMMSGMUTEX");
	if (!gl_hMsgMutex)
		return;
	gl_hMsgEvent = OpenEventA(EVENT_ALL_ACCESS, FALSE, "G27LEDS_MSGEVENT");
	if (!gl_hMsgEvent)
		return;

	gl_hMsgSHM = OpenFileMappingA(FILE_MAP_ALL_ACCESS, FALSE, "G27LEDS_MSGSHM");
	if (!gl_hMsgSHM)
		return;
}

void LoadOriginalDll(void)
{
	char buffer[MAX_PATH];
    
    // Getting path to system dir and to dinput.dll
	::GetSystemDirectory(buffer,MAX_PATH);

	// Append dll name
	strcat(buffer,"\\dinput8.dll");
	
	// try to load the system's dinput.dll, if pointer empty
	if (!gl_hOriginalDll) gl_hOriginalDll = ::LoadLibrary(buffer);

	// Debug
	if (!gl_hOriginalDll)
	{
		::ExitProcess(0); // exit the hard way
	}
}

void ExitInstance() 
{
	CloseHandle(gl_hMsgSHM);
	CloseHandle(gl_hMsgEvent);
	CloseHandle(gl_hMsgMutex);

	// Release the system's dinput8.dll
	if (gl_hOriginalDll)
	{
		::FreeLibrary(gl_hOriginalDll);
	    gl_hOriginalDll = NULL;  
	}
}