#include <iostream>
#include <iostream>
#include <fstream>
#include "pthread.h"
#include "CInsim.h"
#include <string>
#include <cmath>
#include <sstream>
#include <stdexcept>
#include <algorithm>
#include <vector>

#define AXO_CHALK_LINE 4
#define AXO_CHALK_LINE2 5
#define AXO_CHALK_AHEAD 6
#define AXO_CHALK_AHEAD2 7
#define AXO_CHALK_LEFT 8
#define AXO_CHALK_LEFT2 9
#define AXO_CHALK_LEFT3 10
#define AXO_CHALK_RIGHT 11
#define AXO_CHALK_RIGHT2 12
#define AXO_CHALK_RIGHT3 13

#define KEY_NOT_FOUND "GET_VALUE_KEY_NOT_FOUND"
#define NO_CLOSING_BRACKET "NO_CLOSING_BRACKET"
#define EMPTY_VALUE "EMPTY_VALUE: ()"

void setCameraToPlayer (int playerID);
void takeScreenshot ();
void requestCameraInfo (int ReqI);
void requestReplayInfo ();
void addButton (std::string text, byte clickid, byte left, byte top, byte style);
void makeButtons ();
void buttonClickMessage ();
void setStatusLabel (std::string statusText);
void jumpToReplayTimeStamp (unsigned timeStamp);
void printHelpText ();
void log (std::string text, std::string filepath);
std::string stringChain (int n, std::string s);
std::string removeColorCodes (std::string s);
std::string tyresString (byte tyres[]);
std::string get_value (std::string s, std::string key);

//------------------
#define MAXPLAYERID 256 //FIXME: use map, vector or something

//request-constants
#define PLACE_CAMERA 177
#define SAVE_CAMERA 171
//0 - 100 = cameras (for saving)
//mode constansts
#define EDIT 1
#define PLAY 2
int mode = EDIT;
bool showGUI = true;
//button constants
//0 - 100 = reserved for camera buttons
#define BUTTON_STATUS_LABEL 111
#define BUTTON_NEW_CAMERA 112
//#define BUTTON_ACTIVE_CAMERA 100
//#define BUTTON_PREV_CAMERA 101
//#define BUTTON_NEXT_CAMERA 101
//#define BUTTON_CAMERA_INFO 102


CInsim insim;			//CInsim object, handles the communication with LFS
std::ofstream collisionCoordinates;
std::ofstream output; //coordinates logging of all cars into one file "output.txt"
std::ofstream babbler; //general messages and debug
std::ofstream pitstops; //for logging type of tyres
std::ofstream autocrossLayout; //coordinates of pylones, tyres etc

int lookAt = -1;
bool isPaused = false;
bool isTracking = false;
//Kyoto Oval + Ky2
//int camX = -100*65536;
//int camY = 500*65536;
//int camH = 75*65536;
//AS die mit den 2 180
//int camX = -500*65536;
//int camY = -100*65536;
//int camH = 60*65536;
//AS Cadet
int camX = -200*65536;
int camY = 200*65536;
int camH = 60*65536;

//int camX = 0*65536;
//int camY = 0*65536;
//int camH = 60*65536;
//float angle = atan2(p1.y - p2.y, p1.x - p2.x)
//carpark:
//int camX = 0*65536;
//int camY = -800*65536;
//int camH = 25*65536;
//carpark, weiter unten, gebude nicht im weg:
//int camX = -50*65536;
//int camY = -1000*65536;
//int camH = 5*65536;
//BL North ab 7min gutes racing
//int camX = 50*65536;
//int camY = 550*65536;
//int camH = 30*65536;
//BL2 rallye
//int camX = 150*65536;
//int camY = -100*65536;
//int camH = 60*65536;
//BL2 special
//int camX = 100*65536;
//int camY = 300*65536;
//int camH = 40*65536;
//aston spitzkehrenbanane
//int camX = -1000*65536;
//int camY = -1040*65536;
//int camH = 50*65536;
//raceway green, naja
/*
int camX = 0*65536;
int camY = -950*65536;
int camH = 10*65536;
int camMaxX= 10*65536;
int camMinX= -10*65536;
int camMaxY= -950*65536;
int camMinY= -950*65536;
*/
//kyoto oval
/*int camX = 0*65536;
int camY = -950*65536;
int camH = 40*65536;
int camMaxX= 0*65536;
int camMinX= -200*65536;
int camMaxY= 500*65536;
int camMinY= 300*65536;
*/
//zielgerade
/*int camX = 0*65536;
int camY = -950*65536;
int camH = 14*65536;
int camMaxX= -500*65536;
int camMinX= -500*65536;
int camMaxY= 250*65536;
int camMinY= 250*65536;*/

/*int camX = -25*65536;
int camY = 425*65536;
int camH = 65*65536;*/
int camMaxX= camX;
int camMinX= camX;
int camMaxY= camY;
int camMinY= camY;

unsigned currentReplayTime = 0;
unsigned currentCamera = 0;
///////multiple camera positions
struct savedCamera
{
    unsigned timeStamp;
    IS_CPP CPP;
};


std::vector<savedCamera> myCameras;

IS_CPP myCPP;
///////

std::string itos(int i) // convert int to string
{
    std::stringstream s;
    s << i;
    return s.str();
}

class BadConversion : public std::runtime_error {
public:
  BadConversion(std::string const& s)
    : std::runtime_error(s)
    { }
};
inline std::string ntos(double x) //number to string
{
  std::ostringstream o;
  if (!(o << x))
    throw BadConversion("ntos(double)");
  return o.str();
}

bool pointInRect (int pX, int pY, int x1,int y1,int x2,int y2)
{
    //if (pX < x1) return false;
    //if (pX > x2) return false;
    //if (pY < y1) return false;
    //if (pY > y2) return false;
    //return true;
    if (pX < x2) {return true;} else {return false; }
}

std::string timeString (unsigned seconds_in)
{
    int minutes_res = (seconds_in / 60) % 60;
    int seconds_res = seconds_in % 60;
    return itos(minutes_res) +"min"+itos(seconds_res);
}



int camType=0;
int prevCamType=0;
void calculateNewCameraPos (int targetX, int targetY)
{
/*
  //different camera position on oval s/f straight
    if (pointInRect (targetX, targetY, -600*65536,700*65536,  -300*65536,-300*65536 ))
        {
        camX= -500*65536;
        camY= 250*65536;
        camH=14*65536;
        int camType=1;
        return;
        }
*/
    int camSpeed = 1*65536;
    if (camX < targetX) camX+=camSpeed;
    if (camX > targetX) camX-=camSpeed;
    if (camY < targetY) camY+=camSpeed;
    if (camY > targetY) camY-=camSpeed;
    camX=std::min (camX, camMaxX);
    camX=std::max (camX, camMinX);
    camY=std::min (camY, camMaxY);
    camY=std::max (camY, camMinY);
    //camH=40*65536;
    int camType=2;
}

void moveCamera (int xp , int yp, int hp, word heading, word pitch, word roll, float FOV, word time)
{
    //std::cout << "changing camera...";
    struct IS_CPP camera_packet;
    memset(&camera_packet, 0, sizeof(struct IS_CPP));
    camera_packet.Size = sizeof(struct IS_CPP);
    camera_packet.Type = ISP_CPP;
    camera_packet.FOV = FOV;
    camera_packet.InGameCam = 255; //255=unchanged
    camera_packet.ViewPLID = 255;
    camera_packet.Flags=ISS_SHIFTU;
	camera_packet.Time=time;
	camera_packet.Pos.x=xp;		// Position vector
	camera_packet.Pos.y=yp;
	camera_packet.Pos.z=hp;
	camera_packet.H=heading;			// heading - 0 points along Y axis
	camera_packet.P=pitch;			// pitch   - 0 means looking at horizon
	camera_packet.R=roll;			// roll    - 0 means no roll
    camera_packet.ReqI = 66;
    insim.send_packet(&camera_packet);
}

void saveCamera (int number)
{
requestCameraInfo (number);
}


void loadCamera (unsigned camNumber, float speedMulti)
{
    std::cout << "myCameras.size= " << myCameras.size() << std::endl;
    std::cout << "trying to RESTORE camera..\n";
    if (camNumber > myCameras.size())
        {
        std::cout << "ERROR: camNumber > myCameras.size" << std::endl;
        return;
        }
    //myCPP.ReqI = 0;
    //insim.send_packet(&myCPP);
    IS_CPP cam = myCameras[camNumber].CPP;
    cam.ReqI = 0;
    cam.Time = 0;
    if (mode==PLAY) {
    cam.Time = (myCameras[camNumber].timeStamp - myCameras[camNumber-1].timeStamp) *10*speedMulti; //1/100s to 1/1000s
    }
    insim.send_packet(&cam);
    setStatusLabel ("loaded camera #" +itos (camNumber));
    makeButtons (); //update camera list to show active camera
}

float distance (int x1, int y1, int x2, int y2)
{
	float distx=x1-x2;
	float disty=y1-y2;
	return (sqrtf((float) (distx*distx)+(float) (disty*disty)));
}

void mci_message ()
{
    struct IS_MCI* mciPacket = (struct IS_MCI*)insim.get_packet(); //packet abholen
    //ein mci enthaelt mehere autos
    for (int i=0; i < mciPacket->NumC; i++)
    {
        int playerid = mciPacket->Info[i].PLID;
        //if (lookAt == -1) { lookAt=playerid;}
        if (playerid == lookAt && isTracking)
        {
        float posX = mciPacket->Info[i].X;// / 65536.0f; //in meters
        float posY = mciPacket->Info[i].Y;// / 65536.0f;
        float posH = mciPacket->Info[i].Z;
        float speed = (mciPacket->Info[i].Speed / 327.68f) * 3.6f; //in km/h   (32768 = 100 m/s)
        word lap = mciPacket->Info[i].Lap;
        int position = mciPacket->Info[i].Position;
        float heading = mciPacket->Info[i].Heading / 182.04f; // / 32768.0f*180.0f;
        float direction = mciPacket->Info[i].Direction /182.04f; // 32768.0f*180.0f;

        //camX = posX + (65536.0f*10);
        calculateNewCameraPos (posX, posY);
        float ANGLE_CONSTANT = 65536.0f/360.0f;
        int camHeading = (atan2(camX-posX,camY-posY))*-ANGLE_CONSTANT*(180/3.145f) ;

         float d = distance(camX,camY, posX,posY);
        //int camPitch = (atan2 (d ,posH-camH))*ANGLE_CONSTANT*(180/3.145f) ;
int camPitch = (tan ((posH-camH)/d*0.9))*-ANGLE_CONSTANT*(180/3.145f);
//camPitch-=65536.0f*90;
//camH+=5000;
//        std::cout << "camera:" << camX/65536 <<" " << camY/65536<<std::endl;
//        std::cout << "target:" << posX/65536 <<" " << posY/65536<<std::endl;
        //moveCamera (camX,camY,camH, camHeading, camPitch, 0, 20, 400);
        float fov = 975*65536/d; // *2000 oder 1000
        if (fov>60.0f) {fov=60.0f;}
        int smoothtime=250;//300-900
        if (camType != prevCamType) smoothtime=0;
        moveCamera (camX,camY,camH, camHeading, camPitch, 0, fov, smoothtime);
        prevCamType = camType;
        break;
        }
    }
}


void state_message ()
{
    struct IS_STA* statePacket = (struct IS_STA*)insim.get_packet(); //packet abholen
    word Flags = statePacket->Flags;
    float ReplaySpeed = statePacket->ReplaySpeed;
    std::cout << "Flags:" << Flags <<std::endl;
    std::cout << "ReplaySpeed:" << ReplaySpeed <<std::endl;

    if (Flags & ISS_PAUSED)
    {
        std::cout << "paused!" << std::endl;
        isPaused = true;
    }
    else {isPaused=false; lookAt=statePacket->ViewPLID;}
}

//recieve camera position (after calling requestCameraInfo) and update x,y,z of camera, to place camera on new position
void camera_message ()
{
    struct IS_CPP *cp = (struct IS_CPP*)insim.get_packet();
    int ReqI = (int) cp->ReqI;
    std::cout << "ReqI=" << ReqI << std::endl;
    if (ReqI-1==PLACE_CAMERA) //HACK
        {
        std::cout << "/o message: placing camera here." << std::endl;
        int x= cp->Pos.x;
        int y= cp->Pos.y;
        int z= cp->Pos.z;
        std::cout<<"x:"<<x<<"\ty:"<<y<<"\tz:"<<z<<std::endl;

        camX = x;
        camY = y;
        camH = z;
        camMaxX= camX;
        camMinX= camX;
        camMaxY= camY;
        camMinY= camY;
        return;
        }
    //if (ReqI==SAVE_CAMERA) //ReqI = 0-100 = cameraNumber
    {
        std::cout << "SAVING CAMERA" << std::endl;
        /* //this works:
        myCPP = *cp;
        int x= myCPP.Pos.x;
        int y= myCPP.Pos.y;
        int z= myCPP.Pos.z;
        std::cout<<"myCPP - x:"<<x<<"\ty:"<<y<<"\tz:"<<z<<std::endl;*/

        int camNumber = ReqI-1;   //removes the +1 that was adding on sending because camera indexes start from 0 but ReqI can not be zero
        savedCamera newCam;
        newCam.CPP = *cp;
        newCam.timeStamp = currentReplayTime;
        if (camNumber < myCameras.size()) {
            //overwrite existing camera
            myCameras[camNumber] = newCam;
            setStatusLabel ("camera updated!");
            }
            else { //create new camera
            //insert new camera based on timeStamps
            for(std::vector<int>::size_type i = 0; i != myCameras.size(); i++)
                {
                if (currentReplayTime < myCameras[i].timeStamp) {
                    myCameras.insert(myCameras.begin()+i, newCam);
                    makeButtons();
                    setStatusLabel ("camera inserted at "+itos(i));
                    return;
                    }
                }
            //..or just insert at end:
            myCameras.push_back(newCam);
            setStatusLabel ("created new camera!");
            }

        //std::cout << "myCameras.size = " << myCameras.size() << std::endl;
        //addButton ("saved cameras:"+itos(myCameras.size()), BUTTON_ACTIVE_CAMERA, 10,20);
        makeButtons();

    }
}

// NOTE : Typing "/o MESSAGE" into LFS will send an IS_MSO with UserType = MSO_O
void text_message ()
{
    struct IS_MSO* textPacket = (struct IS_MSO*)insim.get_packet(); //packet abholen
    byte UserType = textPacket->UserType;
    if (UserType == MSO_O)
    {
        char *msg;
        msg = textPacket->Msg; //[128]
        std::cout<<"IS_MSO textmessage:" <<msg<<std::endl;
        if (strcmp (msg, "placecamera")==0)
            {
            std::cout << "msg==placecamera" << std::endl;
            requestCameraInfo (PLACE_CAMERA);
            }
        if (strcmp (msg, "stoptracking")==0)
            {
            std::cout << "msg==stoptracking" << std::endl;
            isTracking = false;
            }
        if (strcmp (msg, "starttracking")==0)
            {
            std::cout << "msg==starttracking" << std::endl;
            showGUI=false; makeButtons();
            isTracking = true;
            }
        if (strcmp (msg, "gettime")==0)
            {
            requestReplayInfo();
            }
        //if (strcmp (msg, "loadcam")==0)
        //{
        //loadCamera (0,0);
        //}
        if (strcmp (msg, "newcam")==0)
            {
            saveCamera (myCameras.size());
            }
        if (strcmp (msg, "play")==0) {currentCamera = 0; mode=PLAY; showGUI=false; makeButtons(); loadCamera(0,0);} //1.5f}
        if (strcmp (msg, "edit")==0) {mode=EDIT; showGUI=true; makeButtons();}
        if (strcmp (msg, "help")==0) {printHelpText();}
    }
}

void sendLocalMessage (std::string text)
{
    struct IS_MSL localMsg;
    memset(&localMsg, 0, sizeof(struct IS_MSL));
    localMsg.Size = 132;
    localMsg.Type = ISP_MSL;
    localMsg.ReqI = 0;
    memcpy(localMsg.Msg,text.c_str(),text.size());
    localMsg.Msg[text.size()]=0;
    insim.send_packet(&localMsg);
}

//use like: addButton ("caption bla", 66);
void addButton (std::string text, byte clickid, byte left, byte top, byte style)
{
    if (!showGUI) return;
    struct IS_BTN button;
    memset(&button, 0, sizeof(struct IS_BTN));
    button.Size = sizeof(struct IS_TINY) + text.length();
    button.Type = ISP_BTN;
    button.ReqI = 1;
    button.BStyle = style; //ISB_LIGHT + ISB_CLICK;
    button.ClickID = clickid;
    //as bytes:
    button.L=left;			// left   : 0 - 200
	button.T=top;			// top    : 0 - 200
	button.W=40;			// width  : 0 - 200
	button.H=10;			// height : 0 - 200

    memcpy(button.Text,text.c_str(),text.size());
    button.Text[text.size()]=0;
    insim.send_packet(&button);
    return;
}

void requestCameraInfo (int ReqI)
{
// To GET a CamPosPack from LFS, send this IS_TINY :

// ReqI : non-zero		(returned in the reply)
// SubT : TINY_SCP		(Send Cam Pos)
    struct IS_TINY request;
    request.ReqI = ReqI +1; //camera indexes start from 0 but ReqI can not be zero
    request.SubT = TINY_SCP;
    request.Type = ISP_TINY;
    request.Size = sizeof(struct IS_TINY);
    insim.send_packet(&request);
}


void requestReplayInfo ()
{
    struct IS_TINY request;
    request.ReqI = 666;
    request.SubT = TINY_RIP;
    request.Type = ISP_TINY;
    request.Size = sizeof(struct IS_TINY);
    insim.send_packet(&request);
}


void replayMessage ()
{
    struct IS_RIP *cp = (struct IS_RIP*)insim.get_packet();
    unsigned CTime = (unsigned) cp->CTime;  //replay position in 1/100s
    //std::cout << "replay at: " << CTime << std::endl;
    currentReplayTime = CTime;
}


void *timer_loop_thread()
{
    while (1)
    {
    Sleep (10);
    //std::cout << "timer_loop_thread is alive!" << std::endl;
    requestReplayInfo ();

    if (isPaused == false && mode == PLAY && isTracking == false)
        {
        std::cout << "current camera=" << currentCamera << std::endl;
        std::cout << "savec Cameras=" << myCameras.size() << std::endl;
        int timeDiff = myCameras[currentCamera/*+1*/].timeStamp - currentReplayTime; //vorher: ohne +1
        std::cout << "loading next camera in " << timeDiff << std::endl;
        if (timeDiff < 0)
            {
            currentCamera++;
            //loadCamera(currentCamera,5.0f); //anti-wobble test
            loadCamera(currentCamera,2.0f); //1.5f
            continue;
            }
        if (timeDiff < 100) //attempt to smooth out the "woobling" with an extra kick
            {
            loadCamera(currentCamera+1,2.0f);
            }
        }
    }
}

void *timer_loop_thread_v2()
{
    while (1)
    {
    Sleep (25);
    //std::cout << "timer_loop_thread is alive!" << std::endl;
    requestReplayInfo ();

    if (isPaused == false && mode == PLAY)
        {
        std::cout << "current camera=" << currentCamera << " of " << myCameras.size();
        int timeDiff = myCameras[currentCamera/*+1*/].timeStamp - currentReplayTime; //vorher: ohne +1
        //void moveCamera (int xp , int yp, int hp, word heading, word pitch, word roll, float FOV, word time)

        if (timeDiff < 0)
            {
            currentCamera++;
            //moveCamera (xp , yp, hp, heading, pitch, roll, FOV,  5);
            timeDiff = myCameras[currentCamera].timeStamp - currentReplayTime;
            }

        int muss = (myCameras[currentCamera+1].timeStamp - myCameras[currentCamera].timeStamp);
        float p = 1-(((float (timeDiff)) / (float (muss))));
        if (p>1.0f) {p=1.0f;} //FIXME: why can this happen anyway? it causes jerky over-shooting
        int xp = myCameras[currentCamera].CPP.Pos.x
            + ((myCameras[currentCamera+1].CPP.Pos.x - myCameras[currentCamera].CPP.Pos.x)*p);
        int yp = myCameras[currentCamera].CPP.Pos.y
            + ((myCameras[currentCamera+1].CPP.Pos.y - myCameras[currentCamera].CPP.Pos.y)*p);
        int hp = myCameras[currentCamera].CPP.Pos.z
            + ((myCameras[currentCamera+1].CPP.Pos.z - myCameras[currentCamera].CPP.Pos.z)*p);

        word heading = myCameras[currentCamera].CPP.H;
        word pitch = myCameras[currentCamera].CPP.P;
        word roll = myCameras[currentCamera].CPP.R;
        float FOV = myCameras[currentCamera].CPP.FOV;
        moveCamera (xp , yp, hp, heading, pitch, roll, FOV,  500);

        std::cout << ", next in: " << timeDiff << "\tp=" <<p<< " muss:" << muss << std::endl;

        }




    }
}


int main(int argc, char* argv[])
{
    int retVal = 0;
    struct IS_VER verPack;	//LFS can tell us info about it's version and InSim version, store that info in this struct.
    //Try to connect to LFS
    retVal = insim.init("127.0.0.1",	//LFS will run on local machine
              (word)29999,	//InSim will accept connection on port 29999
              "Cameronaut!",	//Short name for our app, will appear in LFS
              "",		//No admin password
              &verPack,		//Pointer to IS_VERSION packet
              '!',		//InSim command character
            //what kind of packets to recieve:
              ISF_MCI,  //multi car information (positions, speed)
              //ISF_MSO, //message out from lfs (text chat) gibts nicht?
              //ISF_CON+ //player (dis) connecting
              //ISF_OBH+  //autocross object hit
              //ISF_AXM_LOAD+ //autocross loaded
              //ISP_LAP,
              //ISF_PIT,
  //            ISP_LAP+  //lap times
  //            ISP_SPX,  //split times
              50,		//Receive updates every x msecs //75
              0);		//No UDP today

    //Could we connect to LFS?
    if(retVal < 0) //We could not
    {
        //Tell the user and exit
        std::cout << "Error connecting to LFS!" << std::endl;
        return -555;
    }
    //All OK, report version of LFS and InSim.
    std::cout << "Its happening! Connected to LFS " << verPack.Version << ", InSim ver. " << verPack.InSimVer << std::endl;


    //addButton ("active camera:", BUTTON_ACTIVE_CAMERA, 10,20);
    setStatusLabel ("Cameronaut active");
    makeButtons();
    sendLocalMessage("^1type ^3/o help^1 for keys and help!");
    //create a thread that will send IS_RIP packets in regular intervals, to get replay position - works
    int rc;
    pthread_t thread;
    rc = pthread_create(&thread, NULL, timer_loop_thread_v2, NULL);
    if (rc)
    {
        insim.isclose();
        std::cout << "\n * Error creating  timer_loop_thread * " << std::endl;
        std::cout << "\n PRESS RETURN KEY TO FINISH" << std::endl;
        getchar();
        return rc;
    }


    while (true)
    {
        int errorReturn = insim.next_packet();  //get next packet in queue
        if(errorReturn < 0)	//Something went wrong
        {
            std::cout<<"insim.next_packet() failed:" << errorReturn<< std::endl;
            return -666;
        }
        int packetType = insim.peek_packet();   //what type of packet is it? (this just tells the type but does not actuelly get the package)
        //    std::cout<<packetType<<std::endl;


        if (packetType == ISP_CPP) {
            camera_message ();
        }


        if (packetType == ISP_MCI &&!isPaused) { //multi car information. isPaused: attempt to not make crash when fastforward
            mci_message ();
        }

        if (packetType == ISP_STA) { //status (track name, amount of laps)
            std::cout<<"IS_STA (state)"<<std::endl;
            state_message ();
        }
        if (packetType == ISP_MSO) {
            text_message ();
        }

        if (packetType == ISP_RIP) {
            replayMessage ();
        }
        if (packetType == ISP_BTC) {
            buttonClickMessage ();
        }


    //Sleep(500);
    //h+=1000;
    //std::cout<<"h:"<<h<<std::endl;
    //moveCamera (50*65536,50*65536, 400*65536, h, 0, 0, 60, 1000*4);
    }
    return 0;
}



void buttonClickMessage ()
{
    struct IS_BTC* packet = (struct IS_BTC*)insim.get_packet(); //packet abholen
    byte ClickID = packet->ClickID;
    byte CFlags = packet->CFlags;  // ISB_LMB   ISB_RMB   ISB_CTRL  ISB_SHIFT
    std::cout << "ClickID="<<(int)ClickID<<std::endl;
    if (ClickID <= 100)
    {
        if (CFlags == ISB_LMB) //left click : go to camera
            {
            currentCamera = ClickID;
            makeButtons();
            jumpToReplayTimeStamp (myCameras[ClickID].timeStamp);
            loadCamera(ClickID,0);
            }
        if (CFlags == ISB_RMB) //right click : save new values for camera
            {
            saveCamera(ClickID);
            makeButtons();
            }
        if (CFlags == ISB_LMB + ISB_CTRL) //CTRL = delete camera
            {
            myCameras.erase (myCameras.begin()+ClickID);
            makeButtons();
            setStatusLabel("camera deleted");
            }
        return;
    }
    if (ClickID == BUTTON_NEW_CAMERA) { saveCamera (myCameras.size());}
    std::cout << "CFlags="<<(int)CFlags<<std::endl;
}

//clear all buttons, then generate new ones
void makeButtons ()
{
//first clear all buttons
    struct IS_BFN butts;
    memset(&butts, 0, sizeof(struct IS_BFN));
    butts.Size = sizeof(struct IS_BFN);
    butts.Type = ISP_BFN;
    butts.SubT = BFN_CLEAR;
    butts.ReqI = 0;
    insim.send_packet(&butts);

//the "New cam" button
    int x=IS_X_MIN;
    int y=IS_Y_MIN+40; //+30 so under minimap
    addButton ("^2add new cam here", BUTTON_NEW_CAMERA, x, y, ISB_CLICK+ISB_DARK);
    y+=10;
//the camera buttons
    for(std::vector<int>::size_type i = 0; i != myCameras.size(); i++)
        {
        byte style = ISB_LIGHT + ISB_CLICK;
        std::string camColor = "^1";
        if (i==currentCamera) {style = ISB_DARK + ISB_CLICK; camColor="^5";}

        std::string s = "cam "+camColor+itos(i) + " ^3at " + itos(myCameras[i].timeStamp)
        + "^4("+ timeString(myCameras[i].timeStamp/100)+"^4)";
        /*if (i==10) {x=x+40;y=0;}
        if (i==20) {x=x+40;y=0;}
        if (i==30) {x=x+40;y=0;}
        if (i==40) {x=x+40;y=0;}*/
        if (y>IS_Y_MAX) {x+=40; y=IS_Y_MIN;}
        addButton(s, i, x, y, style);
        y=y+10;
        }
}

void setStatusLabel (std::string statusText)
{
    addButton (statusText, BUTTON_STATUS_LABEL, 100, 0, ISB_LIGHT);
}


void jumpToReplayTimeStamp (unsigned timeStamp)
{
    std::cout << "jumping to replay time "<< itos(timeStamp)<<std::endl;
    struct IS_RIP rp;
    memset(&rp, 0, sizeof(struct IS_RIP));
    rp.Size = sizeof(struct IS_RIP);
    rp.Type = ISP_RIP;
    rp.CTime = timeStamp;
    rp.ReqI = 123;
    rp.Paused = true;
    insim.send_packet(&rp);
}

void printHelpText ()
{
    sendLocalMessage("^1[New Camera] = ^3insert new camera with current view at current time");
    sendLocalMessage("^1[LEFT-click camera] = ^3go to clicked camera's view & time");
    sendLocalMessage("^1[RIGHT-click camera] = ^3update clicked camera with current view & time");
    sendLocalMessage("^1CTRL + [click camera] = ^3delete clicked camera");
}


//***atomlol= und lol= mssen unterschieden werden, zB dass vor dem key immer noch ien leerzeichen stehen muss oder so
//jetzt mit < > stat ( )
std::string get_value (std::string s, std::string key)
{
key+="=<";
//cout << key;
int keypos = s.find (key);
//cout << "keypos=" << keypos;
if (keypos == std::string::npos) { return KEY_NOT_FOUND; }
s = s.substr(keypos+key.length(), -1); //alles vor value abschneiden zB "lol=(123)blabla" -> "123) blabla"
int endvalue = s.find (">");
if (endvalue==0) return EMPTY_VALUE;
if (endvalue==std::string::npos) {return NO_CLOSING_BRACKET;}
return s.substr (0, endvalue);
}

void log (std::string text, std::string filepath)
{
std::string fn = filepath + "log.txt";
static std::ofstream logdatei (fn.c_str());
logdatei << text << std::endl;
logdatei.flush ();
}
