//  
//  reorder.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections;
using System.Text;

namespace LFSLapper
{
    partial class LFSClient 
    {
//        public reorder currReorder = new reorder();
//        int start = 130;
        InfoGrid gridInfo = new InfoGrid();

/*        void showReorderGui( infoPlayer currInfoPlayer ){
            foreach (DictionaryEntry de in listOfPlayers.playersUCID)
            {
                infoPlayer myInfoPlayer = (infoPlayer)de.Value;
                if (!currReorder.existInListReo(myInfoPlayer.userName) && myInfoPlayer.UCID != 0 )
                {
                    currReorder.Add(myInfoPlayer.PLID,myInfoPlayer.nickName, myInfoPlayer.userName,0 );
                }
            }
            for (int i = 0; i < currReorder.listReorderPlayer.Count; i++)
            {
                if( listOfPlayers.getPlayerByUserName( ( currReorder.listReorderPlayer[i] as reorder.UN ).userName ) == null )
                    currReorder.listReorderPlayer.RemoveAt(i);
            }

            int last_i = 0;
            for (int i = 0; i < currReorder.listReorderPlayer.Count; i++)
            {
                currInfoPlayer.playerBox.create("reo" + i, currInfoPlayer.UCID, 85, 30 + 5 * i, 30, 5, 5, -1, 0, (int)InSim.BTN_style.ISB_DARK, "", (currReorder.listReorderPlayer[i] as reorder.UN).nickName);
                currInfoPlayer.playerBox.show("reo" + i, currInfoPlayer.UCID);
                string toto = "";
                for( int j = 8364;  j < 8370; j ++ )
                    toto += InSim.CodePage.chr('L', j);
                currInfoPlayer.playerBox.create("up" + i, currInfoPlayer.UCID, 85 + 30, 30 + 5 * i, 30, 5, 5, -1, 0, (int)InSim.BTN_style.ISB_DARK | (int)InSim.BTN_style.ISB_CLICK, "", toto);
                currInfoPlayer.playerBox.show("up" + i, currInfoPlayer.UCID);
                last_i = i;
            }

            for (int i = 0; i < 30; i++)
            {
                string toto = "";
                int nb = 50;
                for (int j = start + i * nb; j < start + i * nb + nb; j++)
                    toto += InSim.CodePage.chr('L', j);
                currInfoPlayer.playerBox.create("up" + i, currInfoPlayer.UCID, 10 + 30, 30 + 5 * i, 100, 5, 5, -1, 0, (int)InSim.BTN_style.ISB_DARK , "", (start + i * nb).ToString() + " - " + toto, next);
                currInfoPlayer.playerBox.show("up" + i, currInfoPlayer.UCID);
            }
//            currInfoPlayer.playerBox.create("close", currInfoPlayer.UCID, 85, 30 + 5 * (last_i + 2), 30, 5, 5, -1, 0, (int)InSim.BTN_style.ISB_DARK | (int)InSim.BTN_style.ISB_CLICK, "", "Close", closeReorder);
//            currInfoPlayer.playerBox.show("close", currInfoPlayer.UCID);


        }
        void next(ISMB.typExeFunc typ, infoPlayer currInfoPlayer, int click, string idButton)
        {
            start = start + 1500;
            for (int i = 0; i < 30; i++)
            {
                string toto = "";
                int nb = 50;
                for (int j = start + i * nb; j < start + i * nb + nb; j++)
                    toto += InSim.CodePage.chr('L', j);
                currInfoPlayer.playerBox.create("up" + i, currInfoPlayer.UCID, 10 + 30, 30 + 5 * i, 100, 5, 5, -1, 0, (int)InSim.BTN_style.ISB_DARK , "", (start + i * nb).ToString() + " - " + toto,next);
                currInfoPlayer.playerBox.show("up" + i, currInfoPlayer.UCID);
            }
        }
        void closeReorder(ISMB.typExeFunc typ, infoPlayer currInfoPlayer, int click, string idButton)
        {
            Console.WriteLine(idButton);
        }
        public int[] getListReorder(string typReorder)
        {
            int[] arPLID = new int[32];
            if (typReorder.ToLower() == "lfs")
                return null;
            
            if (newCfg.varsLapper.PubStatIdk == "") // If no pubstat, use local PB
                typReorder = "PB";

            long insVal = 0;
            foreach (DictionaryEntry de in listOfPlayers.playersUCID)
            {
                infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                if (currInfoPlayer.UCID == 0 || currInfoPlayer.OnTrack == false)
                    continue;
                switch (typReorder.ToLower())
                {
                    case "pb":
                        insVal = currInfoPlayer.gripDriverLapInfo.personalBestLapTime;
                        if (currInfoPlayer.gripDriverLapInfo.personalBestLapTime != 0)
                            insVal = currInfoPlayer.gripDriverLapInfo.personalBestLapTime;
                        else
                            insVal = 3600000;
                        currReorder.Add(currInfoPlayer.PLID, currInfoPlayer.nickName, currInfoPlayer.userName, insVal);
                        break;
                    case "wr":
                        insVal = currInfoPlayer.wr;
                        if (insVal == -1)
                            insVal = 3600000;
                        currReorder.Add(currInfoPlayer.PLID, currInfoPlayer.nickName, currInfoPlayer.userName, insVal);
                        break;
                }
            }
            currReorder.listReorderPlayer.Sort();

            for (int i = 0; i < 32; i++)
                arPLID[i] = 0;
            for (int i = 0; i < currReorder.listReorderPlayer.Count; i++)
            {
                arPLID[i] = (currReorder.listReorderPlayer[i] as reorder.UN).PLID;
            }
            return arPLID;

        }
        public void setReorder( string typReorder )  // Set the reorder for next race
        {
            currReorder.Clear();
            byte[] arPLID = getListReorder(typReorder);
            if (arPLID == null)
                return;
            byte[] reo = myEncoder.REO(1, currReorder.listReorderPlayer.Count,arPLID );
            insimConnection.Send(reo, reo.Length);
        }

        public class reorder 
        {
            public class UN : System.IComparable
            {
                public string userName;
                public string nickName;
                public int PLID = 0;
                public long orderValue = 0;
                public UN(int PLID, string nickName, string userName, long orderValue)
                {
                    this.PLID = PLID;
                    this.userName = userName;
                    this.nickName = nickName;
                    this.orderValue = orderValue;
                }
                public int CompareTo(object x)
                {
                    if ((x as UN).orderValue < orderValue)
                        return 1;
                    else if (((x as UN).orderValue > orderValue) )
                        return -1;
                    else
                        return 0;
                }

            }
            public ArrayList listReorderPlayer = new ArrayList();

            public reorder()
            {

            
            }

            public void Add(int PLID, string nickName, string userName, long orderValue )
            {
                listReorderPlayer.Add( new UN( PLID, nickName, userName,orderValue) );
            }
            public void Remove(string userName)
            {
                for (int i = 0; i < listReorderPlayer.Count; i++)
                {
                    if (userName == ( listReorderPlayer[i] as UN ).userName )
                        listReorderPlayer.RemoveAt(i);
                }
            }
            public void Clear()
            {
                listReorderPlayer.Clear();
            }
            public bool existInListReo(string userName)
            {
                for (int i = 0; i < listReorderPlayer.Count; i++)
                {
                    if (userName == ( listReorderPlayer[i] as UN ).userName )
                        return true;
                }
                return false;
            }
        }
*/
        public class InfoGrid
		{
			// Create 2 new 32 element arrays for Grid Reordering
			public byte[] LapperOrder = new byte[32];
			public byte[] LfsOrder = new byte[32];
			public int startMode = 0;
			public string RaceOrder = "";
            
            public string PLIDsToString(byte[] PLIDs)
            {
				string List = "";
                for (int i = 0; i < PLIDs.Length; i++)
                {
					List = List + PLIDs[i] + ",";
                }
                List = List.TrimEnd(',');
//                Console.WriteLine("Trimmed REO list =  " + List);
                return List;
            }
            public byte[] StringToPLIDs(string ListOfPLIDs)
            {
                byte[] PLIDs = new byte[32];
                string[] strings = ListOfPLIDs.Split(',');
//                PLIDs = (byte)List.Split(',');
                for (int i = 0; i < strings.Length; i++)
                {
                    PLIDs[i] = byte.Parse(strings[i]);
                }
                return PLIDs;
            }
            /*			public void setReorder( string typReorder )  // Set the reorder for next race
                        {
                            currReorder.Clear();
                            int[] arPLID = getListReorder(typReorder);
                            if (arPLID == null)
                                return;
                            byte[] reo = myEncoder.REO(1, currReorder.listReorderPlayer.Count,arPLID );
                            insimConnection.Send(reo, reo.Length);
                        }
            */
		}
   }
}
