//  
//  scriptFunctions.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections;
using UTILS;

namespace LFSLapper
{
    partial class LFSClient
    {
		class LOP
		{
			public string userName = "";
			public string nickName = "";
			public LOP(string pUN, string pNN)
			{
				userName = pUN;
				nickName = pNN;
			}
		}
		public class sortByUName : IComparer
		{
			int IComparer.Compare(object a, object b)
			{
				if (string.Compare((a as LOP).userName, (b as LOP).userName) > 0)
					return 1;
				else if (string.Compare((a as LOP).userName, (b as LOP).userName) < 0)
					return -1;
				else
					return 0;
			}
		}
		public class sortByNName : IComparer
		{
			int IComparer.Compare(object a, object b)
			{
				if (string.Compare((a as LOP).nickName, (b as LOP).nickName) > 0)
					return 1;
				else if (string.Compare((a as LOP).nickName, (b as LOP).nickName) < 0)
					return -1;
				else
					return 0;
			}
		}

        public void initScriptFunction()
        {
            //            newCfg.CurrApp.addCallBackFunction("test", test);
            newCfg.CurrApp.registerCallBackFunction("getplayerinfo", getplayerinfo);
			newCfg.CurrApp.registerCallBackFunction("openprivbutton", openprivbutton);
			newCfg.CurrApp.registerCallBackFunction("closeprivbutton", closeprivbutton);
			newCfg.CurrApp.registerCallBackFunction("openbutton", openbutton);
			newCfg.CurrApp.registerCallBackFunction("closebutton", closebutton);
			newCfg.CurrApp.registerCallBackFunction("setracegrid", setracegrid);
			newCfg.CurrApp.registerCallBackFunction("requestreo", requestreo);
			newCfg.CurrApp.registerCallBackFunction("getlistofplayers", getlistofplayers);
			newCfg.CurrApp.registerCallBackFunction("setplayervar", setplayervar);
			newCfg.CurrApp.registerCallBackFunction("getplayervar", getplayervar);
			newCfg.CurrApp.registerCallBackFunction("getplayervarbyucid", getplayervarbyucid);
			newCfg.CurrApp.registerCallBackFunction("getplayervarbyplid", getplayervarbyplid);
			newCfg.CurrApp.registerCallBackFunction("getlappervar", getlappervar);
			newCfg.CurrApp.registerCallBackFunction("getconfigvar", getconfigvar);
			newCfg.CurrApp.registerCallBackFunction("setconfigvar", setconfigvar);
			newCfg.CurrApp.registerCallBackFunction("numtomsh", numtomsh);
            newCfg.CurrApp.registerCallBackFunction("numtoms", numtoms);
			newCfg.CurrApp.registerCallBackFunction("mshtonum", mshtonum);
			newCfg.CurrApp.registerCallBackFunction("tokph", tokph);
			newCfg.CurrApp.registerCallBackFunction("tomph", tomph);
			newCfg.CurrApp.registerCallBackFunction("toplayerunit", toplayerunit);
			newCfg.CurrApp.registerCallBackFunction("langtranslate", langtranslate);
			newCfg.CurrApp.registerCallBackFunction("langengine", langengine);
			newCfg.CurrApp.registerCallBackFunction("forcerotation", forcerotation);
			newCfg.CurrApp.registerCallBackFunction("termlapper", termlapper);
			newCfg.CurrApp.registerCallBackFunction("groupcmdlfs", groupcmdlfs);
			newCfg.CurrApp.registerCallBackFunction("cmdlfs", cmdlfs);
			newCfg.CurrApp.registerCallBackFunction("setlicense", setlicense);
			newCfg.CurrApp.registerCallBackFunction("setcurrentplayervar", setcurrentplayervar);
			newCfg.CurrApp.registerCallBackFunction("getcurrentplayervar", getcurrentplayervar);

			newCfg.CurrApp.registerCallBackFunction("closetop", closetop);
			newCfg.CurrApp.registerCallBackFunction("closedrf", closetop);
			newCfg.CurrApp.registerCallBackFunction("closetopuser", closetop);

			newCfg.CurrApp.registerCallBackFunction("privmsg", privmsg);
			newCfg.CurrApp.registerCallBackFunction("globalmsg", globalmsg);
			newCfg.CurrApp.registerCallBackFunction("cleanspb", cleanspb);
			newCfg.CurrApp.registerCallBackFunction("showspb", showspb);
			newCfg.CurrApp.registerCallBackFunction("showhand", showhand);
			newCfg.CurrApp.registerCallBackFunction("lapperversion", lapperversion);
			newCfg.CurrApp.registerCallBackFunction("stats", stats);
			newCfg.CurrApp.registerCallBackFunction("dstats", dstats);
			newCfg.CurrApp.registerCallBackFunction("statsqual", statsqual);
			newCfg.CurrApp.registerCallBackFunction("dstatsqual", dstatsqual);
			newCfg.CurrApp.registerCallBackFunction("topuser", topuser);
			newCfg.CurrApp.registerCallBackFunction("nearuser", nearuser);
			newCfg.CurrApp.registerCallBackFunction("currentplayerlfsworldpb", currentplayerlfsworldpb);
			newCfg.CurrApp.registerCallBackFunction("currentplayerlfsworldpbfrom", currentplayerlfsworldpbfrom);

			newCfg.CurrApp.registerCallBackFunction("top", top);
			newCfg.CurrApp.registerCallBackFunction("near", near);
			newCfg.CurrApp.registerCallBackFunction("topqual", topqual);
			newCfg.CurrApp.registerCallBackFunction("nearqual", nearqual);

			newCfg.CurrApp.registerCallBackFunction("getlisttop", getlisttop);
			newCfg.CurrApp.registerCallBackFunction("drf", drf);
			newCfg.CurrApp.registerCallBackFunction("drfqual", drfqual);
			newCfg.CurrApp.registerCallBackFunction("drfnearqual", drfnearqual);
			newCfg.CurrApp.registerCallBackFunction("drfnear", drfnear);
			newCfg.CurrApp.registerCallBackFunction("privrcm", privrcm);
			newCfg.CurrApp.registerCallBackFunction("textprivbutton", textprivbutton);
			newCfg.CurrApp.registerCallBackFunction("textprivbuttonall", textprivbuttonall);
			newCfg.CurrApp.registerCallBackFunction("openprivtextbutton", openprivtextbutton);
			newCfg.CurrApp.registerCallBackFunction("opentextbutton", opentextbutton);
			newCfg.CurrApp.registerCallBackFunction("removeprivdelayedcommand", removeprivdelayedcommand);
			newCfg.CurrApp.registerCallBackFunction("privdelayedcommand", privdelayedcommand);
			newCfg.CurrApp.registerCallBackFunction("removehostdelayedcommand", removehostdelayedcommand);
			newCfg.CurrApp.registerCallBackFunction("hostdelayedcommand", hostdelayedcommand);
			newCfg.CurrApp.registerCallBackFunction("myconfig", myconfig);
			newCfg.CurrApp.registerCallBackFunction("setuserstoredvalue", setuserstoredvalue);
			newCfg.CurrApp.registerCallBackFunction("setuserstorednum", setuserstoredvalue);
			newCfg.CurrApp.registerCallBackFunction("getuserstoredvalue", getuserstoredvalue);
			newCfg.CurrApp.registerCallBackFunction("getuserstorednum", getuserstorednum);
			newCfg.CurrApp.registerCallBackFunction("openglobalbutton", openglobalbutton);
			newCfg.CurrApp.registerCallBackFunction("globalrcm", globalrcm);
			newCfg.CurrApp.registerCallBackFunction("closeglobalbutton", closeglobalbutton);
			newCfg.CurrApp.registerCallBackFunction("http", http);
			newCfg.CurrApp.registerCallBackFunction("moveusertogroup", moveusertogroup);
			newCfg.CurrApp.registerCallBackFunction("getlistofusersgroup", getlistofusersgroup);
			newCfg.CurrApp.registerCallBackFunction("usergroupfromfile", usergroupfromfile);
			newCfg.CurrApp.registerCallBackFunction("usergrouptofile", usergrouptofile);
			newCfg.CurrApp.registerCallBackFunction("removeuserfromgroup", removeuserfromgroup);
			newCfg.CurrApp.registerCallBackFunction("cleargroup", cleargroup);
			newCfg.CurrApp.registerCallBackFunction("userisadmin", userisadmin);
			newCfg.CurrApp.registerCallBackFunction("userisserveradmin", userisserveradmin);
			newCfg.CurrApp.registerCallBackFunction("useringroup", useringroup);
			newCfg.CurrApp.registerCallBackFunction("getusergrippb", getusergrippb);
			newCfg.CurrApp.registerCallBackFunction("getuserdriftpb", getuserdriftpb);
			newCfg.CurrApp.registerCallBackFunction("setstoredvalue", setstoredvalue);
			newCfg.CurrApp.registerCallBackFunction("getstoredvalue", getstoredvalue);
			newCfg.CurrApp.registerCallBackFunction("getstorednum", getstorednum);
			newCfg.CurrApp.registerCallBackFunction("removedelayedcommand", removedelayedcommand);
			newCfg.CurrApp.registerCallBackFunction("delayedcommand", delayedcommand);
			newCfg.CurrApp.registerCallBackFunction("getlongtrackname", getlongtrackname);
			newCfg.CurrApp.registerCallBackFunction("getlengthtrack", getlengthtrack);
			newCfg.CurrApp.registerCallBackFunction("getgrouptrack", getgrouptrack);
			newCfg.CurrApp.registerCallBackFunction("getexttrack", getexttrack);
			newCfg.CurrApp.registerCallBackFunction("registerscheduleaction", registerscheduleaction);
			newCfg.CurrApp.registerCallBackFunction("removescheduleaction", removescheduleaction);
			newCfg.CurrApp.registerCallBackFunction("registernodeaction", registernodeaction);
			newCfg.CurrApp.registerCallBackFunction("removenodeaction", removenodeaction);
			newCfg.CurrApp.registerCallBackFunction("registerzoneaction", registerzoneaction);
			newCfg.CurrApp.registerCallBackFunction("removezoneaction", removezoneaction);
			newCfg.CurrApp.registerCallBackFunction("reload", reload);
			newCfg.CurrApp.registerCallBackFunction("crash", crash);
            newCfg.CurrApp.registerCallBackFunction("getlistoflang", getlistoflang);
            newCfg.CurrApp.registerCallBackFunction("getlistofplayerbuttons", getlistofplayerbuttons);
            newCfg.CurrApp.registerCallBackFunction("striplfscolor", striplfscolor);
            newCfg.CurrApp.registerCallBackFunction("getwr", getwr);


		}

		void testArgs(string ident, string pattern, System.Collections.ArrayList args)
		{
			if (pattern.Length != args.Count)
			{
				throw new GLScript.GLApp.GLScriptException("Command '" + ident + "' incorrect number of parameter");
			}
			for (int i = 0; i < pattern.Length; i++)
			{
				if (pattern[i] == 'I')
				{
					try
					{
						int val = int.Parse(args[i].ToString());

					}
					catch
					{
						throw new GLScript.GLApp.GLScriptException("'" + ident + "' parameter #" + i.ToString() + "(" + args[i] + ") is wrong type at line #");
					}
				}
				if (pattern[i] == 'F')
				{
					try
					{
						float val = float.Parse(args[i].ToString());

					}
					catch
					{
						throw new GLScript.GLApp.GLScriptException("'" + ident + "' parameter #" + i.ToString() + "(" + args[i] + ") is wrong type at line #");
					}
				}
			}
		}
		public void retreiveVarLapper(GLScript.unionVal val, string idVar)
		{
			#region globalVar
			switch (idVar.ToLower())
			{

				case "rotatein":
					val.typVal = GLScript.typVal.num;
					if (newCfg.varsLapper.EnableRotation)
						val.fval = newCfg.varsLapper.RotateEveryNbRaces - currRace.racesDone;
					else
						val.fval = 0;
					return;
				case "racelapsleft":
					val.typVal = GLScript.typVal.num;
					if (currRace.inRace)
						val.fval = currRace.raceLapsLeft;
					else
						val.fval = 0;
					return;

				case "hostname":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(currentHName);
					return;
				case "shorttrackname":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(currState.ShortTrackName);
					return;
				case "longtrackname":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(UTILS.utils.getLongTrackName(currState.ShortTrackName));
					return;
				case "trackid":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(UTILS.utils.convTrackShortnameToId(currState.ShortTrackName));
					return;
				case "shorttime":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(System.DateTime.Now.ToShortTimeString());
					return;
				case "longtime":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(System.DateTime.Now.ToLongTimeString());
					return;
				case "shortdate":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(System.DateTime.Now.ToString(newCfg.varsLapper.DateFormat));
					return;
				case "longdate":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(System.DateTime.Now.ToString(newCfg.varsLapper.LongDateFormat));
					return;
				case "nextrotatecar":
					{
						val.typVal = GLScript.typVal.str;
						int nextCar = currRace.currRotateCar + 1;
						string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
						if (nextCar > tmpCars.Length - 1)
							nextCar = 0;
						val.sval = utils.quote(tmpCars[nextCar]);
					}
					return;
				case "nextrotatetrack":
				case "nextlongrotatetrack":
					{
						val.typVal = GLScript.typVal.str;
						int nextTrack = currRace.currRotateTrack + 1;
						string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
						if (nextTrack > tmpTracks.Length - 1)
							nextTrack = 0;
						if (idVar == "nextrotatetrack")
							val.sval = utils.quote(tmpTracks[nextTrack]);
						else
							val.sval = utils.quote(UTILS.utils.getLongTrackName(tmpTracks[nextTrack]));

					}
					return;
				case "currrotatecar":
					{
						val.typVal = GLScript.typVal.str;
						int nextCar = currRace.currRotateCar;
						string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
						if (nextCar > tmpCars.Length - 1)
							nextCar = 0;
						val.sval = utils.quote(tmpCars[nextCar]);
					}
					return;
				case "currrotatetrack":
				case "currlongrotatetrack":
					{
						val.typVal = GLScript.typVal.str;
						int nextTrack = currRace.currRotateTrack;
						string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
						if (nextTrack > tmpTracks.Length - 1)
							nextTrack = 0;
						if (idVar == "CurrRotateTrack")
							val.sval = utils.quote(tmpTracks[nextTrack]);
						else
							val.sval = utils.quote(UTILS.utils.getLongTrackName(tmpTracks[nextTrack]));
					}
					return;
				case "requiredflags":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(sFlagsRequired);
					return;
				case "nbplayersontrack":
					val.typVal = GLScript.typVal.num;
					val.fval = listOfPlayers.nbPlayerOnTrack;
					return;
				case "raceid":
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote(currRace.started.ToString("yyyy-MM-dd-hh-mm-ss"));
					return;
				case "racelaps":
					val.typVal = GLScript.typVal.num;
					val.fval = currRace.raceLaps;
					return;
				case "raceinprog":
					val.typVal = GLScript.typVal.num;
					val.fval = currState.RaceInProg;
					return;
				case "racemins":
					val.typVal = GLScript.typVal.num;
					val.fval = currRace.raceMins;
					return;
/*                case "elapsedmins":
                    TimeSpan interval = DateTime.Now.Subtract(currRace.started);
                    val.typVal = GLScript.typVal.num;
                    val.fval = (float)interval.TotalMinutes;
                    return;
                case "elapsedsecs":
                    TimeSpan interval2 = DateTime.Now.Subtract(currRace.started);
					val.typVal = GLScript.typVal.num;
                    val.fval = (float)interval2..TotalSeconds;
					return;
*/
                case "elapsedms":
                    TimeSpan intervalms = DateTime.Now.Subtract(currRace.started);
					val.typVal = GLScript.typVal.num;
                    val.fval = (float)intervalms.TotalMilliseconds;
					return;
				case "qualmins":
					val.typVal = GLScript.typVal.num;
					val.fval = currRace.qualMins;
					return;
				case "numconns":
					val.typVal = GLScript.typVal.num;
					val.fval = currState.NumConns;
					return;
				case "numplayers":
					val.typVal = GLScript.typVal.num;
					val.fval = currState.NumP;
					return;
				case "mustpit":
					val.typVal = GLScript.typVal.num;
					if ((currRace.raceFlags & 64) == 64)
						val.fval = 1;
					else
						val.fval = 0;
					return;
				default:
					val.typVal = GLScript.typVal.str;
					val.sval = utils.quote("");
					return;
			}
			#endregion
		}
        public void getplayerinfo(GLScript.unionVal val, ArrayList args)
        {
            infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
            infoPlayer currPly = null;
            if (args.Count > 0)
            {
                testArgs("getplayerinfo", "S", args);
                currPly = listOfPlayers.getPlayerByUserName((string)args[0]);
            }
            else
            {
                currPly = listOfPlayers.getPlayerByUserName((string)currInfoPlayer.userName);
            }
            if (currPly == null)
            {
                val.typVal = GLScript.typVal.str;
                val.sval = utils.quote("");
                return;
            }
            val.typVal = GLScript.typVal.setOfVar;
            val.setVars = new GLScript.SetOfVars();

            foreach (string pvar in Enum.GetNames(typeof(playerVars)))
            {
                val.setVars.Set(utils.quote(pvar), currPly.playerVars.Get(utils.quote(pvar)));
            }
        }
		public void openprivbutton(GLScript.unionVal val, ArrayList args)
		{

			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			if (currInfoPlayer == null)
				throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
			if (args.Count == 9)
				args.Add("");
			testArgs(ident, "SIIIIIIISS", args);
			string text = args[8].ToString();
			if (text == "[[TranslateEngine]]")
				text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
			currInfoPlayer.playerBox.create(
												args[0].ToString(), // ID du boutton
												currInfoPlayer.UCID,
												int.Parse(args[1].ToString()), // X
												int.Parse(args[2].ToString()), // Y
												int.Parse(args[3].ToString()),  // Largeur
												int.Parse(args[4].ToString()),  // Hauteur
												int.Parse(args[5].ToString()),  // Interligne
												int.Parse(args[6].ToString()), // Sec Visible
												0,                              // TypeIn
												int.Parse(args[7].ToString()),  // Bstyle
												"",                             // Caption
												text,             // Button Text
												args[9].ToString()              // BackCall
			);
			currInfoPlayer.playerBox.show(args[0].ToString(), currInfoPlayer.UCID);

		}
		public void closeprivbutton(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			if (currInfoPlayer == null)
				throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
			testArgs(ident, "S", args);
			currInfoPlayer.privateButtonClose(args[0].ToString());
		}
		public void openbutton(GLScript.unionVal val, ArrayList args)
		{

			infoPlayer currPly;
			string ident = val.nameFunction;
            currPly = listOfPlayers.getPlayerByUserName((string)args[0]);
			if (currPly == null)
			{
				throw new GLScript.GLApp.GLScriptException("Player name " + (string)args[0] + " in function " + ident + " not a player");
			}
			args.RemoveAt(0);
			if (args.Count == 9)
				args.Add("");
			testArgs(ident, "SIIIIIIISS", args);
			string text = args[8].ToString();
			if (text == "[[TranslateEngine]]")
				text = lfsLang.replaceParmsLangStr(currPly.idLang);
			currPly.playerBox.create(
												args[0].ToString(), // ID du boutton
												currPly.UCID,
												int.Parse(args[1].ToString()), // X
												int.Parse(args[2].ToString()), // Y
												int.Parse(args[3].ToString()),  // Largeur
												int.Parse(args[4].ToString()),  // Hauteur
												int.Parse(args[5].ToString()),  // Interligne
												int.Parse(args[6].ToString()), // Sec Visible
												0,                              // TypeIn
												int.Parse(args[7].ToString()),  // Bstyle
												"",                             // Caption
												text,             // Button Text
												args[9].ToString()              // BackCall
			);
			currPly.playerBox.show(args[0].ToString(), currPly.UCID);

		}
		public void opentextbutton(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currPly = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			currPly = listOfPlayers.getPlayerByUserName((string)args[0]);
			if (currPly == null)
			{
				throw new GLScript.GLApp.GLScriptException("Player name " + (string)args[0] + " in function " + ident + " not a player");
			}
			args.RemoveAt(0);
			testArgs(ident, "SIIIIIISSIS", args);
			string text = args[8].ToString();
			if (text == "[[TranslateEngine]]")
				text = lfsLang.replaceParmsLangStr(currPly.idLang);

			currPly.playerBox.create(args[0].ToString(), // ID du boutton
												currPly.UCID,
												int.Parse(args[1].ToString()),  // X
												int.Parse(args[2].ToString()),  // Y
												int.Parse(args[3].ToString()),  // Largeur
												int.Parse(args[4].ToString()),  // Hauteur
												int.Parse(args[5].ToString()),  // Interligne
												-1,                              // Sec Visible
												int.Parse(args[9].ToString()),  // TypeIn
												int.Parse(args[6].ToString()),  // Bstyle
												args[7].ToString(),             // Caption
												text,            // Button Text
												args[10].ToString()             // BackCall
			);
			currPly.playerBox.show(args[0].ToString(), currPly.UCID);
		}
		public void closebutton(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currPly;
			string ident = val.nameFunction;
			currPly = listOfPlayers.getPlayerByUserName((string)args[0]);
			if (currPly == null)
			{
				throw new GLScript.GLApp.GLScriptException("Player name " + (string)args[0] + " in function " + ident + " not a player");
			}
			args.RemoveAt(0);
			testArgs(ident, "S", args);
			currPly.privateButtonClose(args[0].ToString());
		}
		public void getlistoflang(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;

			string[] lang = lfsLang.getAllLang();

			val.typVal = GLScript.typVal.setOfVar;
			val.setVars = new GLScript.SetOfVars();
			for (int i = 0; i < lang.Length; i++)
			{
				val.setVars.Set(i.ToString(), new GLScript.unionVal(0, utils.quote(lang[i]), GLScript.typVal.str));
			}
		}
		public void getwr(GLScript.unionVal val, ArrayList args)
		{
            string ident = val.nameFunction;

            infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");

			val.typVal = GLScript.typVal.setOfVar;
			val.setVars = new GLScript.SetOfVars();

            wr.wrInfo wi = currWr.getWR(currState.ShortTrackName, currInfoPlayer.CName);
            if (wi == null)
            {
                val.setVars.Set(utils.quote("CName"), new GLScript.unionVal(0, utils.quote(""), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Track"), new GLScript.unionVal(0, utils.quote(""), GLScript.typVal.str));
                val.setVars.Set(utils.quote("racerName"), new GLScript.unionVal(0, utils.quote(""), GLScript.typVal.str));
                val.setVars.Set(utils.quote("WRTime"), new GLScript.unionVal(0, utils.quote("0"), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Split1"), new GLScript.unionVal(0, utils.quote("0"), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Split2"), new GLScript.unionVal(0, utils.quote("0"), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Split3"), new GLScript.unionVal(0, utils.quote("0"), GLScript.typVal.str));
                val.setVars.Set(utils.quote("SectorLast"), new GLScript.unionVal(0, utils.quote("0"), GLScript.typVal.str));
            }
            else
            {
                val.setVars.Set(utils.quote("CName"), new GLScript.unionVal(0, utils.quote(wi.CName), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Track"), new GLScript.unionVal(0, utils.quote(wi.track), GLScript.typVal.str));
                val.setVars.Set(utils.quote("racerName"), new GLScript.unionVal(0, utils.quote(wi.racerName), GLScript.typVal.str));
                val.setVars.Set(utils.quote("WRTime"), new GLScript.unionVal(0, utils.quote(wi.WRTime.ToString()), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Split1"), new GLScript.unionVal(0, utils.quote(wi.split[0].ToString()), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Split2"), new GLScript.unionVal(0, utils.quote(wi.split[1].ToString()), GLScript.typVal.str));
                val.setVars.Set(utils.quote("Split3"), new GLScript.unionVal(0, utils.quote(wi.split[2].ToString()), GLScript.typVal.str));
                val.setVars.Set(utils.quote("SectorLast"), new GLScript.unionVal(0, utils.quote(wi.sectorSplitLast.ToString()), GLScript.typVal.str));
            }
        }
		public void striplfscolor(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			val.typVal = GLScript.typVal.str;
			val.sval = utils.quote(UTILS.utils.stripLFSColor( (string)args[0] ));
		}
		public void setracegrid(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;

            if (args.Count == 1)
            {
                testArgs(ident, "S", args);
				string subF = "";
            }
            else if (args.Count == 2)
            {
                testArgs(ident, "SS", args);
				string subF = (string)args[1];
			}

//            for (int i = 0; i < currGridOrder.Length - 1; i++)
//                currGridOrder[i] = 0;


/*			// Loop through the comma separated string provided for new race order as PLIDs
			string[] thisPLID = args[0].ToString().Split(',');
			for (int i = 0; i < thisPLID.Length; i++)
			{
				try
				{
                    currGridOrder[i] = int.Parse(thisPLID[i].ToString());
				}
				catch
				{
					throw new GLScript.GLApp.GLScriptException("'" + ident + "' parameter #" + i.ToString() + "(" + thisPLID[i] + ") is wrong type at line #");
				}
			}
*/
			val.typVal = GLScript.typVal.str;
			val.sval = utils.quote("");
		}
		public void requestreo(GLScript.unionVal val, ArrayList args)
		{
			// Request an REO packet
			byte[] reo = myEncoder.REO(250);
			insimConnection.Send(reo, reo.Length);
            val.typVal = GLScript.typVal.str;
            val.sval = utils.quote("");
		}
		public void getlistofplayers(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
			ArrayList lply = new ArrayList();
            
			val.typVal = GLScript.typVal.setOfVar;
            val.setVars = new GLScript.SetOfVars( );
            foreach (DictionaryEntry de in listOfPlayers.playersUCID)
            {
                infoPlayer CI = (infoPlayer)de.Value;
                if (CI.UCID == 0)
                    continue;
                lply.Add(new LOP(CI.userName, UTILS.utils.stripLFSColor( CI.nickName )));
            }
            lply.Sort(new sortByUName());
            if (args.Count == 1)
            {
                string sort = (string)args[0];
                if (sort.ToLower() == "n")
                    lply.Sort(new sortByNName());
            }
            for (int i = 0; i < lply.Count; i++)
            {
				val.setVars.Set(i.ToString(), new GLScript.unionVal(0, utils.quote((lply[i] as LOP).userName), GLScript.typVal.str));
            }
		}
		public void setplayervar(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "SSS", args);
			SetVarPlayer(val, utils.quote((string)args[1]), (string)args[0], (string)args[2]);
		}
		public void getplayervar(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);

			infoPlayer currInfoPlayer = listOfPlayers.getPlayerByUserName((string)args[0]);
			if (currInfoPlayer == null)
			{
				val.typVal = GLScript.typVal.str;
				val.sval = utils.quote("");
				return;
			}
			GLScript.unionVal retVal = currInfoPlayer.playerVars.Get(utils.quote((string)args[1]));
			val.typVal = retVal.typVal;
			val.sval = retVal.sval;
			val.fval = retVal.fval;
		}
		public void getplayervarbyucid(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "IS", args);

			infoPlayer currInfoPlayer = listOfPlayers.getPlayerByUCID(int.Parse(args[0].ToString()));
			if (currInfoPlayer == null)
			{
				val.typVal = GLScript.typVal.str;
				val.sval = utils.quote("");
				return;
			}
			GLScript.unionVal retVal = currInfoPlayer.playerVars.Get(utils.quote((string)args[1]));
			val.typVal = retVal.typVal;
			val.sval = retVal.sval;
			val.fval = retVal.fval;
		}
		public void getplayervarbyplid(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "IS", args);

			infoPlayer currInfoPlayer = listOfPlayers.getPlayerByPLID(int.Parse(args[0].ToString()));
			if (currInfoPlayer == null)
			{
				val.typVal = GLScript.typVal.str;
				val.sval = utils.quote("");
				return;
			}
			GLScript.unionVal retVal = currInfoPlayer.playerVars.Get(utils.quote((string)args[1]));
			val.typVal = retVal.typVal;
			val.sval = retVal.sval;
			val.fval = retVal.fval;
		}
		public void getlappervar(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            retreiveVarLapper(val, (string)args[0]);
		}
		public void getconfigvar(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            getConfigVar(val, (string)args[0]);

		}
		public void setconfigvar(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            setConfigVar(val, (string)args[0], (string)args[1]);
		}
		public void numtomsh(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            val.typVal = GLScript.typVal.str;
            try
            {
                val.sval = utils.quote(unitConv.LongToHMS(long.Parse((string)args[0])));
            }
            catch
            {
                val.sval = "";
            }
		}
        public void numtoms(GLScript.unionVal val, ArrayList args)
        {
            string ident = val.nameFunction;
            testArgs(ident, "S", args);
            val.typVal = GLScript.typVal.str;
            try
            {
                val.sval = utils.quote(unitConv.LongToMS(long.Parse((string)args[0])));
            }
            catch
            {
                val.sval = "";
            }
        }
		public void mshtonum(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			val.typVal = GLScript.typVal.num;
			val.fval = unitConv.HMSToLong(args[0].ToString());
		}
		public void tokph(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "F", args);
            val.typVal = GLScript.typVal.num;
            val.fval = (float)unitConv.toKph(float.Parse(args[0].ToString()));
		}
		public void tomph(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "F", args);
            val.typVal = GLScript.typVal.num;
            val.fval = (float)unitConv.toMph(float.Parse(args[0].ToString()));
		}
		public void toplayerunit(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "F", args);
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            val.typVal = GLScript.typVal.num;
            val.fval = float.Parse(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, float.Parse(args[0].ToString()))));
		}
		public void langtranslate(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            string lang = "en";
            if (args.Count < 1)
                throw new GLScript.GLApp.GLScriptException("Command '" + ident + "' incorrect number of parameter");
            if (currInfoPlayer != null)
                lang = currInfoPlayer.idLang;
            string tmpStr = (string)args[0];
            tmpStr = lfsLang.replaceLangStr(lang, tmpStr);
            args.RemoveAt(0);
            try
            {
                val.sval = "\"" + string.Format(tmpStr, args.ToArray()) + "\"";
            }
            catch
            {
                val.sval = "\"" + "Wrong format " + tmpStr + "\"";
            }
            val.typVal = GLScript.typVal.str;
		}
		public void langengine(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            if (args.Count < 1)
                throw new GLScript.GLApp.GLScriptException("Command '" + ident + "' incorrect number of parameter");
            string tmpStr = (string)args[0];
            args.RemoveAt(0);
            lfsLang.setParmsTranslate(tmpStr, args);
            val.sval = "\"" + "[[TranslateEngine]]" + "\"";
            val.typVal = GLScript.typVal.str;
		}
		public void forcerotation(GLScript.unionVal val, ArrayList args)
		{
            ForceRotation = 1;
            val.typVal = GLScript.typVal.str;
            val.sval = utils.quote("");
		}
		public void termlapper(GLScript.unionVal val, ArrayList args)
		{
            TermProg = true;
            val.typVal = GLScript.typVal.str;
            val.sval = utils.quote("");
		}
		public void groupcmdlfs(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
            outgoingCmdStack.Enqueue(args[0]);                
		}
		public void cmdlfs(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            SendMsg(args[0].ToString()); 
		}
		public void setlicense(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            {
                string arg = args[0].ToString().Trim().ToLower();
                if (arg == "on")
                {
                    SendMsg("License ON");
                    SystemAuth.AuthOn = true;
                }
                if (arg == "off")
                {
                    SendMsg( "License OFF");
                    SystemAuth.AuthOn = false;
                }
                if (arg == "?" || arg == "")
                {
                    if (SystemAuth.AuthOn)
                        SendMsg("License Status = ON");
                    else
                        SendMsg("License Status = OFF");
                }
            }
		}
		public void setcurrentplayervar(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            SetVarPlayer(val, utils.quote((string)args[0]), currInfoPlayer.userName, (string)args[1]);
		}
		public void getcurrentplayervar(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");

			GLScript.unionVal retVal = currInfoPlayer.playerVars.Get( utils.quote((string)args[0]));
			val.typVal = retVal.typVal;
			val.sval = retVal.sval;
			val.fval = retVal.fval;
		}
		public void closetop(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "", args);
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            closeAllTop(currInfoPlayer);
		}
		public void privmsg(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (args.Count == 1)
            {
                testArgs(ident, "S", args);
                if (currInfoPlayer == null)
                    throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
                string text = args[0].ToString();
                if (text == "[[TranslateEngine]]")
                    text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);

                SendMsgToConnection(currInfoPlayer.UCID, text);
            }
            else if (args.Count == 2)
            {
                testArgs(ident, "SS", args);
				infoPlayer sendToPlayer;
                sendToPlayer = listOfPlayers.getPlayerByUserName((string)args[0]);
                if (sendToPlayer == null)
					SendMsgToConnection(currInfoPlayer.UCID, "^6Unable to send private message. Unknown player: " + (string)args[0]);
			    else{
					string text = args[1].ToString();
                    if (text == "[[TranslateEngine]]")
                        text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                    SendMsgToConnection(sendToPlayer.UCID, text);
				}
            }
		}
		public void globalmsg(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer;
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            string text = args[0].ToString();
            string newText = "";
            foreach (DictionaryEntry de in listOfPlayers.playersUCID)
            {
                currInfoPlayer = (infoPlayer)de.Value;
                if (text == "[[TranslateEngine]]")
                    newText = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                else
                    newText = text;
                SendMsgToConnection(currInfoPlayer.UCID, newText);
            }
		}
		public void cleanspb(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            currInfoPlayer.splitLast = 0;
            for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                currInfoPlayer.sessBestSplitDiff[i] = 0;
            currInfoPlayer.sessBestSplitDiffLast = 0;
            currInfoPlayer.bestSpeed = (double)0;
            SendMsgToConnection(currInfoPlayer.UCID, currInfoPlayer.nickName + "^8 SPB Cleaned");

		}
		public void showspb(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            string spb = "";
            try
            {
                switch (currInfoPlayer.viewSPBSplit)
                {
                    case "W":
                    case "P":
                        spb = "PB ";
                        for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                        {
                            if (currInfoPlayer.gripDriverLapInfo.PBBestSplitDiff[i] != 0)
                                spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currInfoPlayer.gripDriverLapInfo.PBBestSplitDiff[i]);
                        }
                        if (currInfoPlayer.gripDriverLapInfo.PBBestSplitDiffLast != 0)
                            spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currInfoPlayer.gripDriverLapInfo.PBBestSplitDiffLast);
                        break;
                    case "S":
                        spb = "Sess ";
                        for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                        {
                            if (currInfoPlayer.sessBestSplitDiff[i] != 0)
                                spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currInfoPlayer.sessBestSplitDiff[i]);
                        }
                        if (currInfoPlayer.sessBestSplitDiffLast != 0)
                            spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currInfoPlayer.sessBestSplitDiffLast);
                        break;
                }
                SendMsgToConnection(currInfoPlayer.UCID, spb);
                SendMsgToConnection(currInfoPlayer.UCID, unitConv.LongToHMS(currInfoPlayer.TPb));
            }
            catch (Exception) { }

		}
		public void showhand(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            if (newCfg.varsLapper.RefreshHandicapUsers)
                UpdateHandicapUsers(newCfg.varsLapper.HandicapUsers);
            ShowHand(currInfoPlayer, args[0].ToString());
		}
		public void lapperversion(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            Ver(currInfoPlayer.UCID);
		}
		public void stats(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            ShowStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false);
		}
		public void dstats(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            ShowDriftStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false);
		}
		public void statsqual(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            ShowStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true);
		}
		public void dstatsqual(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            ShowDriftStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true);
		}
		public void topuser(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            bool flagDesc = false;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "SSSS", args);
            flagDesc = false;
            if (args[2].ToString().ToLower() == "desc")
                flagDesc = true;
            TopStoredUser(currInfoPlayer.UCID, args[0].ToString(), args[1].ToString(), currInfoPlayer.userName, currInfoPlayer.nickName, args[3].ToString(), false, flagDesc);
		}
		public void nearuser(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            bool flagDesc = false;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "SSSS", args);
            flagDesc = false;
            if (args[2].ToString().ToLower() == "desc")
                flagDesc = true;
            TopStoredUser(currInfoPlayer.UCID, args[0].ToString(), args[1].ToString(), currInfoPlayer.userName, currInfoPlayer.nickName, args[3].ToString(), true, flagDesc);
		}
		public void currentplayerlfsworldpb(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            lfsWorldPB(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), 0);
		}
		public void currentplayerlfsworldpbfrom(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "SI", args);
            lfsWorldPB(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), int.Parse(args[1].ToString()));
		}
		public void top(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            TopGrip(currInfoPlayer.userName,args[0].ToString(), false, false);
		}
		public void getlisttop(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			bool flagQual = false;
			bool flagNear = false;
			if (currInfoPlayer == null)
				throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
			testArgs(ident, "SII", args);
			if (int.Parse((string)args[1]) == 1)
				flagQual = true;
			if (int.Parse((string)args[2]) == 1)
				flagNear = true;
			ArrayList list = GetListTopGrip(currInfoPlayer.userName, args[0].ToString(), flagQual, flagNear);

			val.typVal = GLScript.typVal.setOfVar;
			val.setVars = new GLScript.SetOfVars();
			for (int i = 0; i < list.Count; i++)
			{
				LFSDbs.gripDbs.DriverLapEntry elem = (LFSDbs.gripDbs.DriverLapEntry)list[i];
				val.setVars.Set(i.ToString()+"," + utils.quote("UserName"), new GLScript.unionVal(0, utils.quote(elem.userName), GLScript.typVal.str));
				val.setVars.Set(i.ToString() + "," + utils.quote("NickName"), new GLScript.unionVal(0, utils.quote(elem.nickName), GLScript.typVal.str));
				val.setVars.Set(i.ToString() + "," + utils.quote("CName"), new GLScript.unionVal(0, utils.quote(elem.carName), GLScript.typVal.str));
				val.setVars.Set(i.ToString() + "," + utils.quote("DatePb"), new GLScript.unionVal(0, utils.quote(elem.datePb), GLScript.typVal.str));
				string sgroup = "";
                if (elem.group != -1)
                {
					sgroup = ((char)(elem.group + 65)).ToString();
                }
				val.setVars.Set(i.ToString() + "," + utils.quote("Group"), new GLScript.unionVal(0, utils.quote(sgroup), GLScript.typVal.str));
				val.setVars.Set(i.ToString() + "," + utils.quote("Laps"), new GLScript.unionVal(elem.laps, utils.quote(""), GLScript.typVal.num));
				for( int j = 0; j < elem.PBBestSplitDiff.Length;j++ )
					val.setVars.Set(i.ToString() + "," + utils.quote("PbBestSplitDiff" + j.ToString()), new GLScript.unionVal(elem.PBBestSplitDiff[j], utils.quote(""), GLScript.typVal.num));
				val.setVars.Set(i.ToString() + "," + utils.quote("PbBestSplitDiffLast"), new GLScript.unionVal(elem.PBBestSplitDiffLast, utils.quote(""), GLScript.typVal.num));
				val.setVars.Set(i.ToString() + "," + utils.quote("PbLapTime"), new GLScript.unionVal(elem.personalBestLapTime, utils.quote(""), GLScript.typVal.num));
				val.setVars.Set(i.ToString() + "," + utils.quote("Pos"), new GLScript.unionVal(elem.pos, utils.quote(""), GLScript.typVal.num));
				for( int j = 0; j < elem.splitTime.Length;j++ )
					val.setVars.Set(i.ToString() + "," + utils.quote("SplitTime" + j.ToString()), new GLScript.unionVal(elem.splitTime[j], utils.quote(""), GLScript.typVal.num));
				val.setVars.Set(i.ToString() + "," + utils.quote("TimePb"), new GLScript.unionVal(0, utils.quote(elem.timePb), GLScript.typVal.str));
				val.setVars.Set(i.ToString() + "," + utils.quote("Total"), new GLScript.unionVal(elem.total, utils.quote(""), GLScript.typVal.num));
				string ListPb = "";
				string sep = "";
				for (int j = 0; j < elem.listPB.Count; j++)
				{
					ListPb += sep + (elem.listPB[j] as LFSDbs.gripDbs.PbLapEntry).personalBestLapTime;
					sep = ",";
				}
				val.setVars.Set(i.ToString() + "," + utils.quote("ListPb"), new GLScript.unionVal(0, utils.quote(ListPb), GLScript.typVal.str));

			}

		}
		public void drf(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(),false, false);
		}
		public void topqual(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            if (newCfg.varsLapper.RefreshQualUsers)
                UpdateQualUsers(newCfg.varsLapper.QualUsers);
            TopGrip(currInfoPlayer.userName, args[0].ToString(), true,false);
		}
		public void drfqual(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            if (newCfg.varsLapper.RefreshQualUsers)
                UpdateQualUsers(newCfg.varsLapper.QualUsers);
            TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true,false);
		}
		public void nearqual(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            TopGrip( currInfoPlayer.userName, args[0].ToString(), true, true);
		}
		public void drfnearqual(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true, true);
		}
		public void near(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            TopGrip(currInfoPlayer.userName, args[0].ToString(), false, true);
		}
		public void drfnear(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false, true);
		}
		public void privrcm(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            string text = args[0].ToString();
            if (text == "[[TranslateEngine]]")
                text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
            SendMsg("/rcm " + text);
            SendMsg("/rcm_ply " + currInfoPlayer.nickName);
            /*
                                currInfoPlayer.playerBox.create("rcmpriv", currInfoPlayer.UCID, 31, 36, 140, 17, 17, 6, 0, 0, "", "^0" + UTILS.utils.stripLFSColor(args[0].ToString()));
                                currInfoPlayer.playerBox.show("rcmpriv", currInfoPlayer.UCID);
                                currInfoPlayer.playerBox.create("rcmpriv2",currInfoPlayer.UCID, 30, 36, 140, 17, 17, 6, 0, 0, "", args[0].ToString());
                                currInfoPlayer.playerBox.show("rcmpriv2", currInfoPlayer.UCID);
             */
		}
		public void textprivbutton(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            if (args.Count == 9)
                args.Add("");
            testArgs(ident, "SS", args);
            string text = args[1].ToString();
            if (text == "[[TranslateEngine]]")
                text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);

            currInfoPlayer.playerBox.update(
                                                args[0].ToString(), // ID du boutton
                                                currInfoPlayer.UCID,
                                                text  // Button Text
            );
            currInfoPlayer.playerBox.show(args[0].ToString(), currInfoPlayer.UCID);
		}
		public void textprivbuttonall(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);

            string text = args[1].ToString();
            string newText = "";

            foreach (DictionaryEntry de in listOfPlayers.playersUCID)
            {
                infoPlayer CI = (infoPlayer)de.Value;
                newText = text;
                if (newText == "[[TranslateEngine]]")
                    newText = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                else
                CI.playerBox.update(
                        args[0].ToString(), // ID du boutton
                        CI.UCID,
                        newText);  // Button Text
				CI.playerBox.show(args[0].ToString(), CI.UCID);
            }
		}
		public void openprivtextbutton(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "SIIIIIISSIS", args);
            string text = args[8].ToString();
            if (text == "[[TranslateEngine]]")
                text = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);

            currInfoPlayer.playerBox.create(args[0].ToString(), // ID du boutton
                                                currInfoPlayer.UCID,
                                                int.Parse(args[1].ToString()),  // X
                                                int.Parse(args[2].ToString()),  // Y
                                                int.Parse(args[3].ToString()),  // Largeur
                                                int.Parse(args[4].ToString()),  // Hauteur
                                                int.Parse(args[5].ToString()),  // Interligne
                                                -1,                              // Sec Visible
                                                int.Parse(args[9].ToString()),  // TypeIn
                                                int.Parse(args[6].ToString()),  // Bstyle
                                                args[7].ToString(),             // Caption
                                                text,            // Button Text
                                                args[10].ToString()             // BackCall
            );
            currInfoPlayer.playerBox.show(args[0].ToString(), currInfoPlayer.UCID);
		}
		public void myconfig(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            showConfigPlayer(currInfoPlayer);
		}
		public void setuserstoredvalue(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (args.Count > 2)
            {
                testArgs(ident, "SSS", args);
                infoPlayer storedInfoPlayer;
                storedInfoPlayer = listOfPlayers.getPlayerByUserName((string)args[0]);
                if (storedInfoPlayer != null)
                    storedSqlDbs.updateRowUser( args[1].ToString(), storedInfoPlayer.userName, storedInfoPlayer.nickName, args[2].ToString() );
            }
            else
            {
				if (currInfoPlayer == null)
					throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
				testArgs(ident, "SS", args);
                storedSqlDbs.updateRowUser( args[0].ToString(), currInfoPlayer.userName,currInfoPlayer.nickName, args[1].ToString() );
            }
		}
		public void getuserstorednum(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			string tempStr;
			if (args.Count > 1)
			{
				testArgs(ident, "SS", args);
				tempStr = storedSqlDbs.retreiveRowUser(args[1].ToString(), args[0].ToString() );
			}
			else
			{
				if (currInfoPlayer == null)
					throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
				testArgs(ident, "S", args);
				tempStr = storedSqlDbs.retreiveRowUser( args[0].ToString(),currInfoPlayer.userName);
			}
			val.typVal = GLScript.typVal.num;
			try
			{
				val.fval = float.Parse(tempStr);
			}
			catch
			{
				val.fval = -1;
			}
			return;

		}
		public void getuserstoredvalue(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            val.typVal = GLScript.typVal.str;
            if (args.Count > 1)
            {
                testArgs(ident, "SS", args);
                val.sval = utils.quote(storedSqlDbs.retreiveRowUser(args[1].ToString(), args[0].ToString() ));
            }
            else
            {
				if (currInfoPlayer == null)
					throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
				testArgs(ident, "S", args);
                val.sval = utils.quote(storedSqlDbs.retreiveRowUser(args[0].ToString(), currInfoPlayer.userName ));
            } 
		}
		public void openglobalbutton(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (args.Count == 9)
                args.Add("");
            testArgs(ident, "SIIIIIIISS", args);
            listOfPlayers.globalButtonMessage(args[0].ToString(),
                                                int.Parse(args[1].ToString()),
                                                int.Parse(args[2].ToString()),
                                                int.Parse(args[3].ToString()),
                                                int.Parse(args[4].ToString()),
                                                int.Parse(args[5].ToString()),
                                                int.Parse(args[6].ToString()),
                                                0,
                                                int.Parse(args[7].ToString()),
                                                "",
                                                args[8].ToString(),
                                                args[9].ToString()
            );
		}
		public void globalrcm(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);

            string newText = "";
            string text = args[0].ToString();
            foreach (DictionaryEntry de in listOfPlayers.playersUCID)
            {
                currInfoPlayer = (infoPlayer)de.Value;
                if (text == "[[TranslateEngine]]")
                    newText = lfsLang.replaceParmsLangStr(currInfoPlayer.idLang);
                else
                    newText = text;
                SendMsg("/rcm " + newText);
                SendMsg("/rcm_ply " + currInfoPlayer.nickName);
            }
		}
		public void closeglobalbutton(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            listOfPlayers.globalButtonClose( args[0].ToString() );
		}
		public void http(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            if (currInfoPlayer == null)
                throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
            testArgs(ident, "S", args);
            objWebCmd.sendWebCmd( currInfoPlayer.UCID, args[0].ToString() );
		}
		public void moveusertogroup(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            uGroup.addUser(args[0].ToString(), args[1].ToString());
		}
        public void getlistofusersgroup(GLScript.unionVal val, ArrayList args)
        {
            infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
            string ident = val.nameFunction;
            testArgs(ident, "S", args);
            val.clear();
            val.typVal = GLScript.typVal.str;
            val.typArray = true;
            string[] arRet = uGroup.listOfUsersGroup(args[0].ToString());
            for (int i = 0; i < arRet.Length; i++)
                val.add(utils.quote(arRet[i]));
            val.strSort();
            val.add(utils.quote(""));
        }
        public void getlistofplayerbuttons(GLScript.unionVal val, ArrayList args)
        {
            infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
            string ident = val.nameFunction;

            testArgs(ident, "S", args);
            val.clear();
            val.typVal = GLScript.typVal.str;
            val.typArray = true;
            string userName = args[0].ToString();
            currInfoPlayer = listOfPlayers.getPlayerByUserName(userName);
            if (currInfoPlayer == null)
			{
				throw new GLScript.GLApp.GLScriptException("Player name " + (string)args[0] + " in function " + ident + " not a player");
			}
            string[] lob = currInfoPlayer.playerBox.listOfbutton( );
            if( lob.Length == 0 )
                val.add(utils.quote(""));
            for (int i = 0; i < lob.Length; i++)
                val.add(utils.quote(lob[i]));
            val.strSort();
        }
        public void usergroupfromfile(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            uGroup.clear(args[0].ToString());
            uGroup.addUserFromFile(args[0].ToString(), newCfg.varsLapper.WorkingDir + "/" + args[1].ToString());
		}
		public void usergrouptofile(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            uGroup.addUserToFile(args[0].ToString(), newCfg.varsLapper.WorkingDir + "/" + args[1].ToString());
		}
		public void removeuserfromgroup(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            uGroup.removeUser(args[0].ToString(), args[1].ToString());
		}
		public void cleargroup(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            uGroup.clear(args[0].ToString());
		}
		public void userisserveradmin(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			val.typVal = GLScript.typVal.num;
			if (currInfoPlayer.isServerAdmin == true)
				val.fval = 1;
			else
				val.fval = 0;
		}
		public void userisadmin(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			val.typVal = GLScript.typVal.num;
            uGroup.clear( "admin");
            uGroup.addUserFromFile("admin",newCfg.varsLapper.WorkingDir + "/" + newCfg.varsLapper.AdminFile );
			if (uGroup.userExist("admin", args[0].ToString()) || currInfoPlayer.UCID == 0 || currInfoPlayer.isServerAdmin == true)
				val.fval = 1;
			else
				val.fval = 0;
		}
		public void useringroup(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            val.typVal = GLScript.typVal.num;
            if (uGroup.userExist(args[0].ToString(), args[1].ToString()))
                val.fval = 1;
            else
                val.fval = 0;
		}
		public void getusergrippb(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            val.typVal = GLScript.typVal.num;
            val.fval = gripSqlDbs.retreivePB(args[0].ToString(), args[0].ToString(), args[1].ToString(), args[2].ToString());
		}
		public void getuserdriftpb(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            val.typVal = GLScript.typVal.num;
            val.fval = (float)driftSqlDbs.retreiveDriftPoint(args[0].ToString(), args[0].ToString(), args[1].ToString(), args[2].ToString());
		}
		public void setstoredvalue(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "SS", args);
            storedSqlDbs.updateRow(args[0].ToString(), args[1].ToString());
		}
		public void getstoredvalue(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			val.typVal = GLScript.typVal.str;
			val.sval = utils.quote(storedSqlDbs.retreiveRow(args[0].ToString()));
		}
		public void getstorednum(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			string tempStr;
			tempStr = storedSqlDbs.retreiveRow(args[0].ToString());
			val.typVal = GLScript.typVal.num;
			try
            {
				val.fval = float.Parse(tempStr);
			}
			catch
			{
				val.fval = -1;
			}
			return;
		}
		public void removeprivdelayedcommand(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			if (currInfoPlayer == null)
				throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");

			string idTask = "delayed_" + (string)args[0];
			for (int i = currInfoPlayer.tasks.Count - 1; i >= 0; i--)
			{
				if ((currInfoPlayer.tasks[i] as Task).idTask == idTask)
					currInfoPlayer.tasks.RemoveAt(i);
			}
		}
		public void privdelayedcommand(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			string idTask = "";
			if (args.Count == 3)
			{
				testArgs(ident, "SIS", args);
				idTask = args[0].ToString();
				args.RemoveAt(0);
			}
			if (currInfoPlayer == null)
				throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, not a player event");
			testArgs(ident, "IS", args);
			currInfoPlayer.tasks.Add(new Task("delayed_" + idTask, args[1].ToString(), System.DateTime.Now + new System.TimeSpan(0, 0, int.Parse(args[0].ToString()))));
		}
		public void removehostdelayedcommand(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = listOfPlayers.getPlayerByUCID(0);
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			if (currInfoPlayer == null)
				throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, no valid host found");

			string idTask = "delayed_" + (string)args[0];
			for (int i = currInfoPlayer.tasks.Count - 1; i >= 0; i--)
			{
				if ((currInfoPlayer.tasks[i] as Task).idTask == idTask)
					currInfoPlayer.tasks.RemoveAt(i);
			}
		}
		public void hostdelayedcommand(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = listOfPlayers.getPlayerByUCID(0);
			string ident = val.nameFunction;
			string idTask = "";
			if (args.Count == 3)
			{
				testArgs(ident, "SIS", args);
				idTask = args[0].ToString();
				args.RemoveAt(0);
			}
			if (currInfoPlayer == null)
				throw new GLScript.GLApp.GLScriptException("You can't use " + ident + " in this context, no valid host found");
			testArgs(ident, "IS", args);
			currInfoPlayer.tasks.Add(new Task("delayed_" + idTask, args[1].ToString(), System.DateTime.Now + new System.TimeSpan(0, 0, int.Parse(args[0].ToString()))));
		}
		public void removedelayedcommand(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			string idTask = "delayed_" + (string)args[0];
			for (int i = Tasks.Count - 1; i >= 0; i--)
			{
				if ((Tasks[i] as Task).idTask == idTask)
					Tasks.RemoveAt(i);
			}
		}
		public void delayedcommand(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			string idTask = "";
			if (args.Count == 3)
			{
				testArgs(ident, "SIS", args);
				idTask = args[0].ToString();
				args.RemoveAt(0);
			}
            testArgs(ident, "IS", args);
            Tasks.Add(new Task("delayed_" + idTask,args[1].ToString(), System.DateTime.Now + new System.TimeSpan(0, 0, int.Parse( args[0].ToString()) )));
		}
		public void getlongtrackname(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            val.typVal = GLScript.typVal.str;
            val.sval = utils.quote(UTILS.utils.getLongTrackName(args[0].ToString()));
		}
		public void getlengthtrack(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            val.typVal = GLScript.typVal.num;
            if (args.Count > 0)
            {
				testArgs(ident, "S", args);
				val.fval = utils.getLenTrack(args[0].ToString());
            }
            else
            {
				val.fval = utils.getLenTrack(currState.ShortTrackName);
            }
		}
		public void getgrouptrack(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            val.typVal = GLScript.typVal.str;
            val.sval = utils.quote(UTILS.utils.getGroupTrack(args[0].ToString()));
		}
		public void getexttrack(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
            testArgs(ident, "S", args);
            val.typVal = GLScript.typVal.str;
            val.sval = utils.quote(UTILS.utils.getExtTrack(args[0].ToString()));
		}
		public void removescheduleaction(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
			testArgs(ident, "S", args);
			string idTask = (string)args[0];
			for (int i = Tasks.Count-1; i >= 0; i--)
			{
				if ((Tasks[i] as Task).idTask == idTask)
					Tasks.RemoveAt(i);
			}
		}
		public void registerscheduleaction(GLScript.unionVal val, ArrayList args)
		{
			string ident = val.nameFunction;
			string idTask = "";
			string strCmd = "";
			string strCron = "";
			if (args.Count == 2) 
			{
				testArgs(ident, "SS", args);
				strCron = (string)args[0];
				strCmd = (string)args[1];
			}
			else if (args.Count == 3)
			{
				testArgs(ident, "SSS", args);
				idTask = (string)args[0];
				strCron = (string)args[1];
				strCmd = (string)args[2];
			}
			string[] cronTimer = strCron.ToString().Split(':');
            for (int i = 0; i < cronTimer.Length; i++)
                Tasks.Add(new Task(idTask,strCmd, cronTimer[i]));
		}
		public void removenodeaction(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			testArgs(ident, "SS", args); // ident Task, track
            listOfNodeEvent.Remove( args[0].ToString(), args[1].ToString() );
		}
		public void registernodeaction(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			string idTask = "";
			if (args.Count == 5)
			{
				testArgs(ident, "SSISS", args);
				idTask = args[0].ToString();
				args.RemoveAt(0);
			}
			testArgs(ident, "SISS", args);
			listOfNodeEvent.Add(idTask, args[0].ToString(), int.Parse(args[1].ToString()), args[2].ToString(), args[3].ToString());
		}
		public void registerzoneaction(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			string idTask = "";
			if (args.Count == 7)
			{
				testArgs(ident, "SSIIISS", args);
				idTask = args[0].ToString();
				args.RemoveAt(0);
			}
            testArgs(ident, "SIIISS", args);
            int x1 = int.Parse(args[1].ToString());
            int y1 = int.Parse(args[2].ToString());
            int dist = int.Parse(args[3].ToString());
			listOfZoneEvent.Add(idTask, args[0].ToString(), x1, y1, dist, args[4].ToString(), args[5].ToString());
		}
		public void removezoneaction(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			testArgs(ident, "SS", args); // ident Task, track
			listOfZoneEvent.Remove(args[0].ToString(), args[1].ToString());
		}
		public void reload(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = newCfg.getCurrInfoPlayer();
			string ident = val.nameFunction;
			this.TermProg = true;
			this.RestartProg = true;
		}
		public void crash(GLScript.unionVal val, ArrayList args)
		{
			infoPlayer currInfoPlayer = null;
			Console.WriteLine(currInfoPlayer.userName);
		}
    }

}