#############################################################################
# Common Interface Framework (c) by Krayy
#############################################################################
# This Lapper addon is a framework for providing a common look & feel menu based interface.
#
# This can be used by scripters to create multi-paged interfaces that have a
# common look and feel so that Lapper becomes easier to use and promotes a
# clean style of coding to make scripts easier to edit and maintain.
#
# New modules should follow the following naming guidelines and .lpr
# heirarchy to keep in sync with other available modules:
#
# cif.lpr (this module that always exists)
#   |-> /cif/<module_name>.lpr
#      |-> /cif/<module_name>_<sub_module_name>.lpr
#
#############################################################################
# Ver 0.1.0 - 20 October 2010, Rewrite based on older GUI framework using new name and code
# Ver 0.1.1 - 02 Feb 2011, 	Updated display to show all modules on tab pane. 
#							Also new redraw method to speed up display
#############################################################################

CatchEvent OnLapperStart()

	# Set CIF specific globals
	GlobalVar $cifEnabled; $cifEnabled = TRUE;	# This is set when CIF has been loaded
	
	GlobalVar $cifGroups;			# Create global array to hold list of CIF modules
	$cifGroups = "";		# Initialise array with index items
	GlobalVar $cifModules;			# Create global array to hold list of CIF modules
	$cifModules["CIF"] = "CIF";		# Initialise array with index items


	### Set initial dialog coordinates & size ###
	GlobalVar $CifOrigT; $CifOrigT = 34;			# Top edge of window
	GlobalVar $CifOrigL; $CifOrigL = 68;	# Left edge of main content window
	GlobalVar $CifWidth; $CifWidth = 100;			# ...width of Dialog box
	GlobalVar $CifTabOrigL; $CifTabOrigL = 42;			# Left edge of Tab
	GlobalVar $CifTabWidth; $CifTabWidth = 23;			# ...width of Tab
	GlobalVar $CifRowHeight; $CifRowHeight = 6;			# ...height of row of text
	GlobalVar $CifHeight; $CifHeight = $CifRowHeight * 19;			# ...height of window
	GlobalVar $CifCommandTop; $CifCommandTop = $CifOrigT + $CifHeight - ($CifRowHeight + 2);
	GlobalVar $CifCommandWidth; $CifCommandWidth = $CifTabWidth + 2;

EndCatchEvent

Sub CifRegisterModule(  $cifGroupName, $cifModuleName, $CifModuleVersion )
	# Register a new CIF Group if it does not already exist
	IF ( indexOf( $cifGroups, $cifGroupName) < 0 ) THEN
		$cifGroups = $cifGroups . "," . $cifGroupName;
	ENDIF

	# Register a new module if it does not already exist
	IF ( indexOf( $cifModules[$cifGroupName], $cifModuleName) < 0 ) THEN
		$cifModules[$cifGroupName] = $cifModules[$cifGroupName] . "," . $cifModuleName;
	ENDIF
EndSub

Sub CifDraw(  $cifGroupName, $cifModuleName, $cifTitle )

	$HostName = getLapperVar( "HostName" );

	$currPly = GetPlayerInfo();
	$isCifRunning = GetCurrentPlayerVar("cifRunning");
	IF ( ButtonExists( $currPly["UserName"], "cMain_main") == FALSE) THEN
		$isCifRunning = FALSE;
	ENDIF

	# Redraw the dialogs tabs only if the GroupName is different so that it clears the buttons
	IF ( $isCifRunning == FALSE) THEN
		closeButtonRegex ( $currPly["UserName"], "CIF.*");

		# Draw the background and the title bar
		openPrivButton ( "cMain_AllBg1", $CifTabOrigL - 2, $CifOrigT - 8, $CifTabWidth + $CifWidth + 7, $CifHeight + ($CifRowHeight * 1.5), 1, -1,ISB_LIGHT,"");
		openPrivButton ( "cMain_AllBg2", $CifTabOrigL - 2, $CifOrigT - 8, $CifTabWidth + $CifWidth + 7, $CifHeight + ($CifRowHeight * 1.5), 1, -1,ISB_LIGHT,"");
		openPrivButton ( "cMain_Version", $CifTabOrigL + $CifTabWidth + $CifWidth - 17, $CifOrigT - 8, 20, 4, 4, -1, ISB_RIGHT + 7, "CIF Framework%nl%v1.0.1 by Krayy");
		# Draw the main contents window on top of the titles and clear them
		openPrivButton( "cMain_main",$CifOrigL,$CifOrigT,$CifWidth,$CifHeight-(($CifRowHeight*2)-3),5,-1,32," " );

		# Tab background and tab names to click on
		openPrivButton ( "cMain_TabMain", $CifTabOrigL, $CifOrigT, $CifTabWidth + 2, $CifHeight - (($CifRowHeight * 2) - 3), 5, -1, 32," " );
	ELSE
		closeButtonRegex ( $currPly["UserName"], "CIF" . GetCurrentPlayerVar("cifGroupName") . ".*");
		closeButtonRegex ( $currPly["UserName"], "CIFCmdButton.*");
	ENDIF

	# Add the title & Close Command Button
	openPrivButton ( "cMain_TabbedGuiTitle", $CifTabOrigL, $CifOrigT - 8, $CifTabWidth + $CifWidth + 7, 8, 1, -1, ISB_LEFT + 2, $HostName . "^0 - " . $cifTitle );
	CifCmdButton( 0, "Close", CloseCifAll );

	SetCurrentPlayerVar("cifGroupName", $cifGroupName);
	SetCurrentPlayerVar("cifRunning", TRUE);

	$CIF_GROUPS = SplitTOArray( $cifGroups , "," );
	$CIF_GROUPS_MAX = arrayCount( $CIF_GROUPS );
	$j=0;
	$ButOrigT = $CifOrigT + 1;

	$CifTabRowHeight = $CifRowHeight - 1;
	WHILE ($j <= $CIF_GROUPS_MAX)
		$thisCifGroupName = $CIF_GROUPS[$j];
		IF ( $thisCifGroupName != "" ) THEN
	
		IF ( $isCifRunning == FALSE) THEN
			openPrivButton ( "CIFTab_" . $thisCifGroupName,$CifTabOrigL+1,$ButOrigT,$CifTabWidth,$CifTabRowHeight,5,-1,32,"^7" . $thisCifGroupName );
		ENDIF
		$ButOrigT = $ButOrigT + $CifTabRowHeight + 1;
		
		$CIF_MODULES = SplitTOArray( $cifModules[$thisCifGroupName] , "," );
		$CIF_MODULES_MAX = arrayCount( $CIF_MODULES );
		$i=0;
		WHILE ($i <= $CIF_MODULES_MAX)
			$thisCifModule = $CIF_MODULES[$i];
			IF ( $thisCifModule != "" ) THEN
				IF ( ($thisCifModule == $cifModuleName) && ($thisCifGroupName == $cifGroupName) ) THEN
					IF ( $isCifRunning == FALSE) THEN
						openPrivButton ( "CIFTab_" . $thisCifGroupName . $thisCifModule,$CifTabOrigL+1,$ButOrigT,$CifTabWidth,$CifTabRowHeight,4,-1,16,"^3" . StrReplace( $thisCifModule, "_", " " ), "DoCif" . $thisCifGroupName . $thisCifModule );
					ELSE
						TextPrivButton( "CIFTab_" . $thisCifGroupName . $thisCifModule, "^3" . StrReplace( $thisCifModule, "_", " " ));
					ENDIF
				ELSE
					IF ( $isCifRunning == FALSE) THEN
						openPrivButton ( "CIFTab_" . $thisCifGroupName . $thisCifModule,$CifTabOrigL+1,$ButOrigT,$CifTabWidth,$CifTabRowHeight,4,-1,16, StrReplace( $thisCifModule, "_", " " ), "DoCif" . $thisCifGroupName . $thisCifModule );
					ELSE
						TextPrivButton( "CIFTab_" . $thisCifGroupName . $thisCifModule, StrReplace( $thisCifModule, "_", " " ));
					ENDIF
				ENDIF
				$ButOrigT = $ButOrigT + $CifTabRowHeight + 1;
			ENDIF
			$i = $i + 1;
		ENDWHILE
		ENDIF
		$j = $j + 1;
	ENDWHILE

EndSub

# CIF Command Buttons can be numbered from 0 to 4, with 0 being reserved for the Close button.
Sub CifCmdButton( $CcbNum, $CcbText, $CcbCallBack )
	IF ( $CcbNum == 0 ) THEN
		openPrivButton( "cMain_CmdClose", ($CifTabOrigL+1)+($CifCommandWidth*$CcbNum), $CifCommandTop, $CifCommandWidth-2, $CifRowHeight, 4, -1, 32, "^7Close", CloseCifAll );
	ELSE
		openPrivButton( "CIFCmdButton_" . $CcbNum, ($CifTabOrigL+1)+($CifCommandWidth*$CcbNum), $CifCommandTop, $CifCommandWidth-2, $CifRowHeight, 4, -1, 32, "^7" . $CcbText, $CcbCallBack );
	ENDIF
EndSub

Sub CloseCifAll ($KeyFlags, $id )
	$currPly = GetPlayerInfo();
	closeButtonRegex ( $currPly["UserName"], "CIF.*");
	closeButtonRegex ( $currPly["UserName"], "cMain.*");
	SetCurrentPlayerVar("cifRunning", FALSE);
EndSub

Sub CountItems ( $ItemList )
	$ItemArray = SplitTOArray(  $ItemList , "," );
	$ItemCount = arrayCount( $ItemArray );
	return ( $ItemCount );
EndSub
