#ifndef _LFSORDLL_H_
#define _LFSORDLL_H_
////////////////////

#ifdef LFSOR_EXPORT
	#define LFSOR_API extern "C" __declspec(dllexport)
#endif

struct OVR_FovPort // same as ovrFovPort
{
    float UpTan;
    float DownTan;
    float LeftTan;
    float RightTan;
};

struct OVR_Recti // same as ovrRecti
{
	int x;
	int y;
	int w;
	int h;
};

struct OVR_EyeRenderDesc
{
	OVR_FovPort		Fov;				// the field of view to use when rendering this eye view.
	OVR_Recti		DistortedViewport;	// viewport to use when applying the distortion to the render target
};

struct OVR_Vector2f // exact copy of ovr
{
    float x, y;
};

struct OVR_DistortionVertex // exact copy of ovr
{
    OVR_Vector2f	ScreenPosNDC;    // [-1,+1],[-1,+1] over the entire framebuffer.
    float			TimeWarpFactor;  // Lerp factor between time-warp matrices. Can be encoded in Pos.z.
    float			VignetteFactor;  // Vignette fade factor. Can be encoded in Pos.w.
    OVR_Vector2f	TanEyeAnglesR;
    OVR_Vector2f	TanEyeAnglesG;
    OVR_Vector2f	TanEyeAnglesB;    
};

struct OVR_DistortionMesh // exact copy of ovr
{
    OVR_DistortionVertex	*pVertexData;
    unsigned short			*pIndexData;
    unsigned int			VertexCount;
    unsigned int			IndexCount;
};

struct OVR_UVScaleOffset
{
	OVR_Vector2f	UVScaleOffset[2]; // 0:scale 1:offset
};

struct OVR_MeshInfo
{
	OVR_DistortionMesh	DistortionMesh	[2];
	OVR_UVScaleOffset	UVScaleOffset	[2];
};

struct OVR_HMDStart
{
	char		ProductName				[32];
	char		DisplayDeviceName		[32];

	unsigned	HResolution;
	unsigned	VResolution;
	unsigned	SpareU2;
	unsigned	SpareU3;
};

struct OVR_HMDInfo
{   
    unsigned	Caps;
    unsigned	Spare1;
    unsigned	Spare2;
	unsigned	Spare3;

	int			RTRecommendedW;
	int			RTRecommendedH;
	int			RTSpare2;
	int			RTSpare3;

	OVR_EyeRenderDesc	EyeRenderDesc	[2];

	float		IPD;
	float		SpareF1;
	float		SpareF2;
	float		SpareF3;
};

struct OVR_FrameTiming // exact copy of ovr
{
	float		DeltaSeconds;
	double		ThisFrameSeconds;
	double		TimewarpPointSeconds;
	double		NextFrameSeconds;
	double		ScanoutMidpointSeconds;
	double		EyeScanoutSeconds		[2];    
};

struct OVR_Matrix4f // exact copy of ovr
{
	float M[4][4];
};

struct OVR_HSWDisplayState
{
	byte	Displayed;			// If true then the warning should be currently visible and the following variables have meaning.
	byte	Sp1;
	byte	Sp2;
	byte	Sp3;
	double	StartTime;			// Absolute time when the warning was first displayed. See ovr_GetTimeInSeconds().
	double	DismissibleTime;	// Earliest absolute time when the warning can be dismissed. May be a time in the past.
};


// return values

const int LFSOR_VERSION = 6;

enum
{
	LFSOR_OPEN_FAIL,
	LFSOR_OPEN_START,
	LFSOR_OPEN_NO_SENSOR,
	LFSOR_OPEN_SENSOR,
	LFSOR_OPEN_NUM
};

enum
{
	OR_FAIL_NONE,
	OR_FAIL_INITIALIZE,
	OR_FAIL_HMD_CREATE,
	OR_FAIL_NOT_PRESENT,
	OR_FAIL_NOT_EXTENDED,
	OR_FAIL_NUM
};

#define OR_CAPS_LOWPERSISTENCE		0x00000001
#define OR_CAPS_DYNAMICPREDICTION	0x00000002
#define OR_CAPS_NOVSYNC				0x00000004

#define OR_TRACK_ORIENTATION		0x00000100
#define OR_TRACK_POSITION			0x00000200

#define OR_DIST_FLIPINPUT			0x00010000
#define OR_DIST_VIGNETTE			0x00020000

#ifdef LFSOR_EXPORT

LFSOR_API int		LFSOR_GetVersion			();
LFSOR_API int		LFSOR_Open					(OVR_HMDStart *start_info, int *error);
LFSOR_API void		LFSOR_Close					();
LFSOR_API int		LFSOR_QueryHMD				(OVR_HMDInfo *info, int want_tracking);
LFSOR_API void		LFSOR_CreateMeshes			(OVR_MeshInfo *info, int tex_width, int tex_height);
LFSOR_API void		LFSOR_FreeMeshes			(OVR_MeshInfo *info);
LFSOR_API double	LFSOR_GetTimeInSeconds		();
LFSOR_API int		LFSOR_Peek					(double abs_time, float *yaw, float *pitch, float *roll, float *x, float *y, float *z);
LFSOR_API void		LFSOR_Reset					();
LFSOR_API unsigned	LFSOR_GetCaps				();
LFSOR_API void		LFSOR_SetCaps				(unsigned lfs_caps);
LFSOR_API void		LFSOR_BeginFrameTiming		(OVR_FrameTiming *timing);
LFSOR_API void		LFSOR_EndFrameTiming		();
LFSOR_API void		LFSOR_GetTimewarpMatrices	(OVR_Matrix4f *four_mats);
LFSOR_API void		LFSOR_GetHSWInfo			(OVR_HSWDisplayState *state);
LFSOR_API int		LFSOR_DismissHSWDisplay		();

#endif

//////
#endif