// LFS Vertex Shader : CAR1


#define SHINY


// Vertex shader input structure

struct VS_INPUT
{
	float4	v0		: POSITION;
	float3	v3		: NORMAL;
	float4	v5		: COLOR;
	float2	v8		: TEXCOORD0;
};


// Vertex shader output structure

struct VS_OUTPUT
{
    float4	oPos	: POSITION;

	float4	oD0		: COLOR0;
	float4	oD1		: COLOR1;
	float3 Normal   :	TEXCOORD4;	
	float3 EyeVec : TEXCOORD5;
	float3 LightDir : TEXCOORD6;

#ifdef SHINY
	float2	EnvA	: TEXCOORD3; // using TEXCOORD3 to pass envmap alpha to pixel shader
#endif

	float2	oT0		: TEXCOORD0;
	float2	oT1		: TEXCOORD1;

#ifdef SHINY
	float2	oT2		: TEXCOORD2;
#endif

    float	oFog	: FOG;
};


// Global variables

float4x4	lightinfo_mat	: register(c0);
float4		sun_col			: register(c6);
float4		up_dir			: register(c7);
float4		basecolamb		: register(c8);
float4		diffcolamb		: register(c9);
float4		light_dir		: register(c10);
float4x4	local_to_texel	: register(c12);
float4		fog_info		: register(c90);
float4		clampmin		: register(c16);
float4		clampmax		: register(c17);

#ifdef SHINY
float4		eye_local		: register(c30);
float4x4	local_to_view	: register(c31);
float4		envmaplevel		: register(c36);
#endif

// Main function

VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;

	// Pos and Fog

	Out.oPos = mul(In.v0, lightinfo_mat);
	Out.oFog = Out.oPos.z * fog_info.x + fog_info.y; // SKIP this line if no fog

	// CAR_LIGHTMAPTEX0

	Out.oT0 = clamp(mul(In.v0, local_to_texel), clampmin, clampmax).xy;

	// CAR_LIGHT_TO_D0

	//float	ld_dot_n = max(0.0f, dot(In.v3, light_dir.xyz)); // In.v3 is dcl_normal
	//float4	direct_light_col = sun_col * ld_dot_n;

	Out.oD0.rgb = sun_col.rgb * In.v5.rgb; // In.v5 is dcl_color;
	//Out.oD0.rgb = direct_light_col.rgb; // In.v5 is dcl_color;
	//Out.oD0.rgb *= 2.0f; // mul2x
	Out.oD0.a = 1.0f;
	Out.Normal = In.v3;
	Out.LightDir = light_dir.xyz;

	// DEFAULTTEX1

	Out.oT1 = In.v8;

	// CAR_AMBIENT_TO_D0

	float	up_dot_n = dot(In.v3, up_dir.xyz); // In.v3 is dcl_normal
	float4	ambient_light_col = basecolamb + up_dot_n * diffcolamb;

	Out.oD1.rgb = ambient_light_col.rgb * In.v5.rgb; // In.v5 is dcl_color;
	Out.oD1.rgb *= 2.0f; // mul2x
	Out.oD1.a = 1.0f;
	Out.EyeVec = normalize(eye_local.xyz - In.v0.xyz);

#ifdef SHINY

	// CAR_ENVMAP_TO_D0_TEX0

	float3 E = normalize(eye_local.xyz+ - In.v0.xyz);

	float3 r3 = E - 2.0f * dot(E, In.v3.xyz) * In.v3.xyz; // Calculate E - 2*(E dot N)*N

	float4 r4 = mul(float4(r3.x, r3.y, r3.z, 1.0f), local_to_view);//*fresnelTerm(In.v3,eye_local);

	Out.oT2 = r4.xy;

	Out.EnvA = float2(envmaplevel.a * clamp(0.0f, r4.z, 1.0f), 0.0f);
	//float3 viewdir = normalize(eye_local.xyz+In.v0.xyz);
	

#endif
    return Out;
}