#include <iostream>
#include <iostream>
#include <fstream>
#include "pthread.h"
#include "CInsim.h"
#include <string>
#include <cmath>
#include <sstream>
#include <stdexcept>
#include <algorithm>

#define AXO_CHALK_LINE 4
#define AXO_CHALK_LINE2 5
#define AXO_CHALK_AHEAD 6
#define AXO_CHALK_AHEAD2 7
#define AXO_CHALK_LEFT 8
#define AXO_CHALK_LEFT2 9
#define AXO_CHALK_LEFT3 10
#define AXO_CHALK_RIGHT 11
#define AXO_CHALK_RIGHT2 12
#define AXO_CHALK_RIGHT3 13


void setCameraToPlayer (int playerID);
void takeScreenshot ();
void requestCameraInfo ();
std::string stringChain (int n, std::string s);
std::string removeColorCodes (std::string s);
std::string tyresString (byte tyres[]);
//------------------
#define MAXPLAYERID 256 //FIXME: use map, vector or something



CInsim insim;			//CInsim object, handles the communication with LFS
std::ofstream collisionCoordinates;
std::ofstream output; //coordinates logging of all cars into one file "output.txt"
std::ofstream babbler; //general messages and debug
std::ofstream pitstops; //for logging type of tyres
std::ofstream autocrossLayout; //coordinates of pylones, tyres etc

int lookAt = -1;
bool isPaused = false;
bool isTracking = false;
//Kyoto Oval + Ky2
//int camX = -100*65536;
//int camY = 500*65536;
//int camH = 75*65536;
//AS die mit den 2 180
//int camX = -500*65536;
//int camY = -100*65536;
//int camH = 60*65536;
//AS Cadet
int camX = -200*65536;
int camY = 200*65536;
int camH = 60*65536;

//int camX = 0*65536;
//int camY = 0*65536;
//int camH = 60*65536;
//float angle = atan2(p1.y - p2.y, p1.x - p2.x)
//carpark:
//int camX = 0*65536;
//int camY = -800*65536;
//int camH = 25*65536;
//carpark, weiter unten, gebude nicht im weg:
//int camX = -50*65536;
//int camY = -1000*65536;
//int camH = 5*65536;
//BL North ab 7min gutes racing
//int camX = 50*65536;
//int camY = 550*65536;
//int camH = 30*65536;
//BL2 rallye
//int camX = 150*65536;
//int camY = -100*65536;
//int camH = 60*65536;
//BL2 special
//int camX = 100*65536;
//int camY = 300*65536;
//int camH = 40*65536;
//aston spitzkehrenbanane
//int camX = -1000*65536;
//int camY = -1040*65536;
//int camH = 50*65536;
//raceway green, naja
/*
int camX = 0*65536;
int camY = -950*65536;
int camH = 10*65536;
int camMaxX= 10*65536;
int camMinX= -10*65536;
int camMaxY= -950*65536;
int camMinY= -950*65536;
*/
//kyoto oval
/*int camX = 0*65536;
int camY = -950*65536;
int camH = 40*65536;
int camMaxX= 0*65536;
int camMinX= -200*65536;
int camMaxY= 500*65536;
int camMinY= 300*65536;
*/
//zielgerade
/*int camX = 0*65536;
int camY = -950*65536;
int camH = 14*65536;
int camMaxX= -500*65536;
int camMinX= -500*65536;
int camMaxY= 250*65536;
int camMinY= 250*65536;*/

/*int camX = -25*65536;
int camY = 425*65536;
int camH = 65*65536;*/
int camMaxX= camX;
int camMinX= camX;
int camMaxY= camY;
int camMinY= camY;

std::string itos(int i) // convert int to string
{
    std::stringstream s;
    s << i;
    return s.str();
}

class BadConversion : public std::runtime_error {
public:
  BadConversion(std::string const& s)
    : std::runtime_error(s)
    { }
};
inline std::string ntos(double x) //number to string
{
  std::ostringstream o;
  if (!(o << x))
    throw BadConversion("ntos(double)");
  return o.str();
}

bool pointInRect (int pX, int pY, int x1,int y1,int x2,int y2)
{
    //if (pX < x1) return false;
    //if (pX > x2) return false;
    //if (pY < y1) return false;
    //if (pY > y2) return false;
    //return true;
    if (pX < x2) {return true;} else {return false; }
}

int camType=0;
int prevCamType=0;
void calculateNewCameraPos (int targetX, int targetY)
{
/*
  //different camera position on oval s/f straight
    if (pointInRect (targetX, targetY, -600*65536,700*65536,  -300*65536,-300*65536 ))
        {
        camX= -500*65536;
        camY= 250*65536;
        camH=14*65536;
        int camType=1;
        return;
        }
*/
    int camSpeed = 1*65536;
    if (camX < targetX) camX+=camSpeed;
    if (camX > targetX) camX-=camSpeed;
    if (camY < targetY) camY+=camSpeed;
    if (camY > targetY) camY-=camSpeed;
    camX=std::min (camX, camMaxX);
    camX=std::max (camX, camMinX);
    camY=std::min (camY, camMaxY);
    camY=std::max (camY, camMinY);
    //camH=40*65536;
    int camType=2;
}

void moveCamera (int xp , int yp, int hp, word heading, word pitch, word roll, float FOV, word time)
{
    //std::cout << "changing camera...";
    struct IS_CPP camera_packet;
    memset(&camera_packet, 0, sizeof(struct IS_CPP));
    camera_packet.Size = sizeof(struct IS_CPP);
    camera_packet.Type = ISP_CPP;
    camera_packet.FOV = FOV;
    camera_packet.InGameCam = 255; //255=unchanged
    camera_packet.ViewPLID = 255;
    camera_packet.Flags=ISS_SHIFTU;
	camera_packet.Time=time;
	camera_packet.Pos.x=xp;		// Position vector
	camera_packet.Pos.y=yp;
	camera_packet.Pos.z=hp;
	camera_packet.H=heading;			// heading - 0 points along Y axis
	camera_packet.P=pitch;			// pitch   - 0 means looking at horizon
	camera_packet.R=roll;			// roll    - 0 means no roll
    camera_packet.ReqI = 66;
    insim.send_packet(&camera_packet);
}


float distance (int x1, int y1, int x2, int y2)
{
	float distx=x1-x2;
	float disty=y1-y2;
	/*if (x1>=x2)  distx= x1-x2;
	else  distx= x2-x1;
	if (y1>=y2)  disty= y1-y2;
	else  disty= y2-y1;*/
	return (sqrtf((float) (distx*distx)+(float) (disty*disty)));
}




void mci_message ()
{
    struct IS_MCI* mciPacket = (struct IS_MCI*)insim.get_packet(); //packet abholen
    //ein mci enthaelt mehere autos
    for (int i=0; i < mciPacket->NumC; i++)
    {
        int playerid = mciPacket->Info[i].PLID;
        //if (lookAt == -1) { lookAt=playerid;}
        if (playerid == lookAt && isTracking)
        {
        float posX = mciPacket->Info[i].X;// / 65536.0f; //in meters
        float posY = mciPacket->Info[i].Y;// / 65536.0f;
        float posH = mciPacket->Info[i].Z;
        float speed = (mciPacket->Info[i].Speed / 327.68f) * 3.6f; //in km/h   (32768 = 100 m/s)
        word lap = mciPacket->Info[i].Lap;
        int position = mciPacket->Info[i].Position;
        float heading = mciPacket->Info[i].Heading / 182.04f; // / 32768.0f*180.0f;
        float direction = mciPacket->Info[i].Direction /182.04f; // 32768.0f*180.0f;

        //camX = posX + (65536.0f*10);
        calculateNewCameraPos (posX, posY);
        float ANGLE_CONSTANT = 65536.0f/360.0f;
        int camHeading = (atan2(camX-posX,camY-posY))*-ANGLE_CONSTANT*(180/3.145f) ;

         float d = distance(camX,camY, posX,posY);
        //int camPitch = (atan2 (d ,posH-camH))*ANGLE_CONSTANT*(180/3.145f) ;
int camPitch = (tan ((posH-camH)/d*0.9))*-ANGLE_CONSTANT*(180/3.145f);
//camPitch-=65536.0f*90;
//camH+=5000;
//        std::cout << "camera:" << camX/65536 <<" " << camY/65536<<std::endl;
//        std::cout << "target:" << posX/65536 <<" " << posY/65536<<std::endl;
        //moveCamera (camX,camY,camH, camHeading, camPitch, 0, 20, 400);
        float fov = 2000*65536/d;
        if (fov>60.0f) {fov=60.0f;}
        int smoothtime=300;
        if (camType != prevCamType) smoothtime=0;
        moveCamera (camX,camY,camH, camHeading, camPitch, 0, fov, smoothtime);
        prevCamType = camType;
        break;
        }
    }
}


void state_message ()
{
    struct IS_STA* statePacket = (struct IS_STA*)insim.get_packet(); //packet abholen
    word Flags = statePacket->Flags;
    float ReplaySpeed = statePacket->ReplaySpeed;
    std::cout << "Flags:" << Flags <<std::endl;
    std::cout << "ReplaySpeed:" << ReplaySpeed <<std::endl;

    if (Flags & ISS_PAUSED)
    {
        std::cout << "paused!" << std::endl;
        isPaused = true;
    }
    else {isPaused=false; lookAt=statePacket->ViewPLID;}
}

//recieve camera position (after calling requestCameraInfo) and update x,y,z of camera, to place camera on new position
void camera_message ()
{
    struct IS_CPP *cp = (struct IS_CPP*)insim.get_packet();
    int ReqI = (int) cp->ReqI;
    std::cout << "ReqI=" << ReqI << std::endl;
    if (ReqI==70)
        {
        std::cout << "/o message: placing camera here." << std::endl;
        int x= cp->Pos.x;
        int y= cp->Pos.y;
        int z= cp->Pos.z;
        std::cout<<"x:"<<x<<"\ty:"<<y<<"\tz:"<<z<<std::endl;

        camX = x;
        camY = y;
        camH = z;
        camMaxX= camX;
        camMinX= camX;
        camMaxY= camY;
        camMinY= camY;
        }
}

void text_message ()
{
    struct IS_MSO* textPacket = (struct IS_MSO*)insim.get_packet(); //packet abholen
    byte UserType = textPacket->UserType;
    // NOTE : Typing "/o MESSAGE" into LFS will send an IS_MSO with UserType = MSO_O
    if (UserType == MSO_O)
    {
        char *msg;
        msg = textPacket->Msg; //[128]
        std::cout<<"IS_MSO textmessage:" <<msg<<std::endl;
        if (strcmp (msg, "placecamera")==0)
            {
            std::cout << "msg==placecamera" << std::endl;
            requestCameraInfo ();
            }
        if (strcmp (msg, "stoptracking")==0)
            {
            std::cout << "msg==stoptracking" << std::endl;
            isTracking = false;
            }
        if (strcmp (msg, "starttracking")==0)
            {
            std::cout << "msg==starttracking" << std::endl;
            isTracking = true;
            }

    }

}

//use like: addButton ("caption bla", 66);
void addButton (std::string text, byte clickid)
{
    struct IS_BTN button;
    memset(&button, 0, sizeof(struct IS_BTN));
    button.Size = sizeof(struct IS_TINY) + text.length();
    button.Type = ISP_BTN;
    button.ReqI = 1;
    button.BStyle = ISB_LIGHT + ISB_CLICK;
    //as bytes:
    button.L=100;			// left   : 0 - 200
	button.T=0;			// top    : 0 - 200
	button.W=10;			// width  : 0 - 200
	button.H=10;			// height : 0 - 200

    memcpy(button.Text,text.c_str(),text.size());
    button.Text[text.size()]=0;
    insim.send_packet(&button);
    return;
}

void requestCameraInfo ()
{

// To GET a CamPosPack from LFS, send this IS_TINY :

// ReqI : non-zero		(returned in the reply)
// SubT : TINY_SCP		(Send Cam Pos)
    struct IS_TINY request;
    request.ReqI = 70;
    request.SubT = TINY_SCP;
    request.Type = ISP_TINY;
    request.Size = sizeof(struct IS_TINY);
    insim.send_packet(&request);
}



int main(int argc, char* argv[])
{
    int retVal = 0;
    struct IS_VER verPack;	//LFS can tell us info about it's version and InSim version, store that info in this struct.
    //Try to connect to LFS
    retVal = insim.init("127.0.0.1",	//LFS will run on local machine
              (word)29999,	//InSim will accept connection on port 29999
              "Cameronaut guckt!",	//Short name for our app, will appear in LFS
              "",		//No admin password
              &verPack,		//Pointer to IS_VERSION packet
              '!',		//InSim command character
            //what kind of packets to recieve:
              ISF_MCI,  //multi car information (positions, speed)
              //ISF_MSO, //message out from lfs (text chat) gibts nicht?
              //ISF_CON+ //player (dis) connecting
              //ISF_OBH+  //autocross object hit
              //ISF_AXM_LOAD+ //autocross loaded
              //ISP_LAP,
              //ISF_PIT,
  //            ISP_LAP+  //lap times
  //            ISP_SPX,  //split times
              75,		//Receive updates every x msecs
              0);		//No UDP today

    //Could we connect to LFS?
    if(retVal < 0) //We could not
    {
        //Tell the user and exit
        std::cout << "Error connecting to LFS!" << std::endl;
        return -555;
    }
    //All OK, report version of LFS and InSim.
    std::cout << "Its happening! Connected to LFS " << verPack.Version << ", InSim ver. " << verPack.InSimVer << std::endl;


    //addButton ("Place Camera", 1);
    while (true)
    {
        int errorReturn = insim.next_packet();  //get next packet in queue
        if(errorReturn < 0)	//Something went wrong
        {
            std::cout<<"insim.next_packet() failed:" << errorReturn<< std::endl;
            return -666;
        }
        int packetType = insim.peek_packet();   //what type of packet is it? (this just tells the type but does not actuelly get the package)
        //    std::cout<<packetType<<std::endl;


        if (packetType == ISP_CPP)
        {
            camera_message ();
        }

        if (packetType == ISP_MCI &&!isPaused)  //multi car information. isPaused: attempt to not make crash when fastforward
        {
            mci_message ();
        }

        if (packetType == ISP_STA) //status (track name, amount of laps)
        {
            std::cout<<"IS_STA (state)"<<std::endl;
            state_message ();
        }
        if (packetType == ISP_MSO)
        {
            text_message ();
        }

    //Sleep(500);
    //h+=1000;
    //std::cout<<"h:"<<h<<std::endl;
    //moveCamera (50*65536,50*65536, 400*65536, h, 0, 0, 60, 1000*4);
    }
    return 0;
}
