from System import Int16

import sys
import socket
import struct



global sockOS,		outsim
global exitKey,	exitCnt

global steerIn,	steerOut,	lastOut
global ana_max,	ana_min,	outSmooth,	sInLin,	linSwh


global frontAxleDist,		steerLock,	ackermannEft
global minSpd,	fullSpd,	lmtAngle,	lmtHdns

global vel_x,	vel_y,	vel_z,	angvel_x,	angvel_y,	angvel_z,	header,	pitch,	roll	
global fVel_x,	fVel_y, fSpd,	fHead,		fAttack,	assistLvl

global missPkgCnt



def resetFun():
	global steerIn,		steerOut,			lastOut
	global vel_x,	vel_y,	vel_z,	angvel_x,	angvel_y,	angvel_z,	header,	pitch,	roll	
	global fVel_x,	fVel_y, fSpd,	fHead,		fAttack,	assistLvl
	steerOut		= 0.0
	lastOut			= 0.0
	vel_x			= 0.0
	vel_y			= 0.0
	vel_z			= 0.0
	angvel_x		= 0.0
	angvel_y		= 0.0
	angvel_z		= 0.0
	header			= 0.0
	pitch			= 0.0
	roll			= 0.0
	fVel_x			= 0.0
	fVel_y			= 0.0
	fSpd			= 0.0
	fHead			= 0.0
	fAttack			= 0.0
	assistLvl		= 0.0
	return


def angleCompare(val):
	tmpC = val
	while (tmpC > math.pi):
		tmpC -= 2*math.pi
	while (tmpC < -math.pi):
		tmpC += 2*math.pi
	return tmpC


def checkOutput():
	global steerIn, steerOut, lastOut
	global ana_max, ana_min, outSmooth
	if (steerOut < lastOut-outSmooth):
		steerOut = lastOut-outSmooth
	elif (steerOut > lastOut+outSmooth):
		steerOut = lastOut+outSmooth
	
	if (steerOut > ana_max):
		steerOut = ana_max
	elif (steerOut < ana_min):
		steerOut = ana_min
	
	lastOut = steerOut
	return


def linearityFun(val):
	global sInLin
	tmpL = val
	tmpSwh = False
	if (tmpL<0):
		tmpL = -tmpL
		tmpSwh = True
	tmpL = (sInLin/(sInLin-1))*(1-(1/math.sqrt(sInLin))/(math.sqrt(sInLin)*(tmpL*((sInLin-1)/sInLin)+(1/sInLin))))
	if (tmpSwh):
		tmpL = -tmpL
	return tmpL


if starting:
	system.setThreadTiming(TimingTypes.HighresSystemTimer)
	system.threadExecutionInterval = 5
	
	
	#################### REMOVE THIS FOR REAL CONTROLLER ####################
	testInput		= 0
	senTestInput	= 200
	tAnaMax			=  Int16.MaxValue*0.5-0.5
	tAnaMin			= -Int16.MaxValue*0.5-0.5
	steerLeftKey	= Key.LeftArrow
	steerRightKey	= Key.RightArrow
	#################### REMOVE THIS FOR REAL CONTROLLER ####################
	
	
	
	################################# EDIT BELOW #################################
	outSmooth		=  900		# maximum steering output value shift per tick
	
	frontAxleDist	=  1.3		# front axle center to car center distance in meters, usually about half wheelbase
	steerLock		= 36.0		# steering angle of setup in degrees
	ackermannEft	= 1.20		# ackermann effect, multiplier for steerLock
	
	minSpd			=  1.2		# minimum speed in m/s at which assistance kicks in
	fullSpd			= 14.4		# speed at which assistance reaches full strength
	lmtAngle		= 12.0		# unrestricted slip angle range
	lmtHdns			=  2.5		# steer limit hardness, not implemented
	sInLin			=  1.0		# steer input linearity, (-1,1) range,
								# 0 for linear response, - for center reduction, + for center boost
	################################# EDIT ABOVE #################################
	
	
	
	steerLock *= ackermannEft
	
	ana_max =	Int16.MaxValue*0.5-0.5
	ana_min = -Int16.MaxValue*0.5-0.5
	exitKey = Key.RightControl				### fix me
	exitCnt = 0
	
	if (abs(sInLin) < 0.005):
		linSwh = False
	else:
		linSwh = True
		sInLin =  math.exp(sInLin)
	
	steerIn = 0
	
	sockOS = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
	sockOS.setblocking(0)
	sockOS.bind(('127.0.0.1', 30000))
	outsim = None
	
	
	resetFun()
	missPkgCnt = 0



# ====================================================
# LOOP START
# ====================================================


if keyboard.getKeyDown(exitKey):
	exitCnt += 1
	if (exitCnt == 1 or exitCnt == 10):
		sockOS.shutdown(2)
		sockOS.close()
		diagnostics.watch(exitCnt)
	elif (exitCnt > 100):
		diagnostics.watch(exitCnt)
		sys.exit(0)



#################### REMOVE THIS FOR REAL CONTROLLER ####################
if keyboard.getKeyDown(steerRightKey):
	if (not keyboard.getKeyDown(steerLeftKey)):
		testInput += 1.5*senTestInput
elif keyboard.getKeyDown(steerLeftKey):
	testInput -= 1.5*senTestInput
else:
	if testInput<0:
		testInput += min(senTestInput,-testInput)
	else:
		testInput -= min(senTestInput,testInput)
if (testInput > tAnaMax):
	testInput = tAnaMax
elif (testInput < tAnaMin):
	testInput = tAnaMin
vJoy[1].x = testInput
#################### REMOVE THIS FOR REAL CONTROLLER ####################



try:
	#################### EDIT THIS FOR REAL CONTROLLER ####################
	steerIn = (joystick[1].x+1)/1000.0
	#################### EDIT THIS FOR REAL CONTROLLER ####################
	
	if (linSwh):
		steerIn = linearityFun(steerIn) * ana_max
	
	
	outsim = struct.unpack('I12f3i', sockOS.recv(256))
	angvel_x	= outsim[1]
	angvel_y	= outsim[2]
	angvel_z	= outsim[3]
	header		= outsim[4]
	pitch		= outsim[5]
	roll		= outsim[6]
	vel_x		= outsim[10]
	vel_y		= outsim[11]
	vel_z		= outsim[12]
	
	
	fVel_x	= vel_x - frontAxleDist*angvel_z*math.cos(header)
	fVel_y	= vel_y - frontAxleDist*angvel_z*math.sin(header)
	fSpd	= math.hypot(fVel_x,fVel_y)
	
	if (fSpd > minSpd):
		fHead		= math.atan2(-fVel_x, fVel_y)
		fAttack		= angleCompare(header-fHead)
		
		if (abs(fAttack) < 1.5):
			steerOut = ana_max*((math.degrees(fAttack)/steerLock)+(lmtAngle/steerLock)*(steerIn/ana_max))
			
			if (fSpd > fullSpd):
				assistLvl = 1.0
			else:
				assistLvl = (fSpd-minSpd)/(fullSpd-minSpd)
				assistLvl = 3*assistLvl**2-2*assistLvl**3
			if (abs(fAttack) > 1.2):
				tmpLvl = 1-(abs(fAttack)-1.2)/0.3
				assistLvl *= 3*tmpLvl**2-2*tmpLvl**3
		else:
			assistLvl = 0.0
	else:
		assistLvl = 0.0
	
	steerOut = steerOut*assistLvl + steerIn*(1.0-assistLvl)
	
	checkOutput()
	vJoy[0].x = steerOut
except:
	if (missPkgCnt < 30):
		missPkgCnt += 1
	elif (missPkgCnt == 30):
		resetFun()
		missPkgCnt = 100
	else:
		steerOut = steerIn
		checkOutput()
		vJoy[0].x = steerOut
else:
	missPkgCnt = 0



def diagnost():
	diagnostics.watch(missPkgCnt)
	
	diagnostics.watch(testInput)
	diagnostics.watch(steerIn)
	diagnostics.watch(steerOut)
	diagnostics.watch(steerOut/ana_max)
	diagnostics.watch(assistLvl)
	diagnostics.watch(vel_x)
	diagnostics.watch(vel_y)
	diagnostics.watch(vel_z)
	diagnostics.watch(angvel_x)
	diagnostics.watch(angvel_y)
	diagnostics.watch(angvel_z)
	#diagnostics.watch(header)
	diagnostics.watch(pitch)
	diagnostics.watch(roll)
	diagnostics.watch(fVel_x)
	diagnostics.watch(fVel_y)
	diagnostics.watch(fSpd)
	
	diagnostics.watch(header)
	diagnostics.watch(fHead)
	
	diagnostics.watch(fAttack)
	
	diagnostics.watch(fSpd > minSpd)
	return

#diagnost()