﻿$AdminFile = "./admin.txt"; # Name of the file containing admin lfsname player
$StoredValueDbs = "storedvalue"; # Name of the database in which additional values are stored
$TrackInfoFile = "trackInfo.cfg"; # Path to the TrackInfoFile used to compare splits
$TCPmode = true; # Connection to LFS in UDP mode or TCP mode
$EnableRegisterWeb = true; # When set to "true" your LFS Server is displayed on the FRH Team website
$DateFormat = "dd/MM/yyyy";
$LongDateFormat = "dddd dd MMMM yyyy";
$MessageTime = 4750; # Time in milliseconds for a racecontrol message (started by: rcm_all) to be displayed on screen
$PubStatIdk = "";
$DefaultTopCar = "UFR+XFR+RB4+RAC+FZR+XRR+FXR+FBM+LX4+LX6+XFG+XRG+XRT+FZ5+FXO+FO8+FOX+MRT+UF1+BF1";
$ShowPlayerControl = False; # Set option to "true" if you want to show the control configuration of players when leaving the pits.
include( "./includes/consts.lpr");
include( "./includes/addonsused.lpr");

#################################################
#Connect messages when a player joins the server#
#################################################

Event OnConnect( $userName ) # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	$Posabs = GetCurrentPlayerVar("PosAbs");

	openPrivButton( "welc",25,50,150,12,15,-1,ISB_NONE, langEngine("%{main_welc1}%", $NickName ) );
	openPrivButton( "pos",25,82,150,8,8,-1,ISB_NONE,langEngine("%{main_welc2}%",$Posabs) );
  openPrivButton( "query",40,122,70,10,8,-1,ISB_NONE,langEngine("%{main_query}%"));
	openPrivButton( "clos",105,122,20,10,10,-1,ISB_DARK,langEngine("%{main_accept}%"),OnConnectClose );
	openPrivButton( "ref",130,122,20,10,10,18,ISB_DARK,langEngine("%{main_deny}%"),OnConnectCloseKick );
  openPrivButton( "clickmessage",40,136,120,6,10,18,ISB_LIGHT,langEngine("%{main_clickmessage}%"),OnConnectCloseKick );
	http("http://www.frh-team.net/reglapper/getserver2.php" );
EndEvent

Sub OnConnectClose( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref&clickmessage&query");
EndSub

Sub OnConnectCloseKick( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref&clickmessage&query");
	cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
EndSub

#######################
#Language Translations#
#######################

Lang "EN"
	main_welc1 = "^7Welcome {0} ^7to this ^1LFSLapper ^7powered server !%nl%^2Type ^7!help ^2after leaving garage to see commands.";
	main_welc2 = "^7Your actual friendly Time Position (all visitors + vehicles): ^7{0}%nl%%nl%^4Don't use swearwords on this server%nl%^3Show respect to other player(s) else you may be banned";
  main_query = "^0Do you agree to these rules?";
  main_clickmessage = "^7You ^1MUST ^7click either '^2YES^7' or '^1NO^7' button within ^0> ^1%cpt% ^0< ^7seconds, else you will be kicked from server";
	main_accept = "^2YES";
	main_deny = "^1NO";
EndLang