/*  This file is part of LFSBench for Linux/X11
 *
 *  LFSBench for Linux/X11 is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSBench for Linux/X11 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with LFSBench for Linux/X11. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "appwindow.h"
#include "fpscounter.h"
#include "keyblogger.h"
#include "sharedstructs.h"
#include <sys/capability.h>
#include <unistd.h>

pthread_t win_event_loop;
pthread_t kb_event_loop;
pthread_mutex_t exit_mutex;

char* evdev_path;
int exit_app;

int main(int argc, char** argv)
{ 
  if (geteuid() != 0) {
    cap_t caps = cap_get_proc();
    cap_flag_value_t capfv;

    if (caps == NULL) {
      fprintf(stderr, "CRITICAL: Cannot get advanced capabilites status.\n");
      return -1;
    }
    if (cap_get_flag(caps, CAP_DAC_READ_SEARCH, CAP_EFFECTIVE, &capfv) != 0) {
      fprintf(stderr, "CRITICAL: Cannot check capability flags.\n");
      return -1;
    }
    if (capfv != CAP_SET) {
      fprintf(stderr, "CRITICAL: Capability CAP_DAC_READ_SEARCH is not set, this capability is required.\n");
      cap_free(caps);
      return -1;
    }
    if (cap_get_flag(caps, CAP_SYS_PTRACE, CAP_EFFECTIVE, &capfv) != 0) {
      fprintf(stderr, "CRITICAL: Cannot check capability flags.\n");
      return -1;
    }
    if (capfv != CAP_SET) {
      fprintf(stderr, "CRITICAL: Capability CAP_SYS_PTRACE is not set, this capability is required.\n");
      cap_free(caps);
      return -1;
    }
    cap_free(caps);
  }

  /* Check arguments */
  if (argc != 2) {
    printf("No arguments given, assuming that \"/dev/input/event0\" is the keyboard.\n");
    evdev_path = "/dev/input/event0";
  } else {
    evdev_path = malloc(strlen(argv[1])*sizeof(char) + 1);
    strcpy(evdev_path, argv[1]);
  }

  /* Setup threading data */
  exit_thrdata etd;
  exit_app = 0;
  if (pthread_mutex_init(&exit_mutex, NULL) != 0) {
    fprintf(stderr, "CRITICAL: Cannot create exit_mutex!");
    return -1;
  }
  
  etd.exit_mutex = &exit_mutex;
  etd.pexit_app = &exit_app;
    
  if (XInitThreads() <= 0) {
      fprintf(stderr, "Unable to initialize X11 threads\n");
      pthread_mutex_destroy(&exit_mutex);
      return -1;
  }
  /* Create main window */
  if (create_window() < 0)
    return -1;
  /* Start main window event loop */
  if (pthread_create(&win_event_loop, NULL, &window_event_loop, &etd) != 0) {
    fprintf(stderr, "CRITICAL: Cannot start main window event loop!\n");
    return -1;
  }
  
  if (init_keyb_logging(evdev_path) != 0)
    goto exit;
  
  if (init_fps_counter(&etd) != 0)
    goto exit;
  
  if (pthread_create(&kb_event_loop, NULL, &get_keyb_events, &etd) != 0) {
    fprintf(stderr, "CRITICAL: Cannot start boundkeys event loop!\n");
    return -1;
  }
 
  pthread_join(win_event_loop, NULL);
  stop_benchmark();
  destroy_window();

  pthread_join(kb_event_loop, NULL);
  
  pthread_mutex_destroy(&exit_mutex);

  return 0;
  
  exit:
  pthread_join(win_event_loop, NULL);
  pthread_mutex_destroy(&exit_mutex);
  
  return -1;
}
