float Script : STANDARDSGLOBAL <
    	string UIWidget = "none";
    	string ScriptClass = "object";
    	string ScriptOrder = "standard";
    	string ScriptOutput = "color";
    	string Script = "Technique=Technique?basicRender;";
> = 1.0;

texture gColorTexture0 : Diffuse
<
	string ResourceType = "2D";
>;
texture gColorTexture1 : Diffuse
<
	string ResourceType = "2D";
>;

sampler2D diffuseSampler : register(s0) = sampler_state
{
	Texture = <gColorTexture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
	AddressU = WRAP;
	AddressV = WRAP;
};
sampler2D normalSampler : register(s1) = sampler_state
{
	Texture = <gColorTexture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
	AddressU = WRAP;
	AddressV = WRAP;
};

//---------------------------------- 
float4x4 wvp : WorldViewProjection < string UIWidget = "None"; >;  
float4x4 worldIT : WorldInverseTranspose < string UIWidget = "None"; >;  

float3 ldir = float3( 1.0f , -1.0f , 1.0f );
float3 ambient = float3( 0.3f , 0.3f , 0.3f );
float1 wind = 0.0f;
float bumpiness = 2; 


// input from application 
struct a2v { 
	float4 position			: POSITION; 
	float2 diffuse			: TEXCOORD0;
	float3 norm				: NORMAL;
	float3 binorm			: BINORMAL;
	float3 tang				: TANGENT;
}; 

// output to fragment program 
struct v2f { 
        float4 position    		: POSITION;
		float2 uv				: TEXCOORD0;
		float3 norm				: TEXCOORD1;
		float3 wtang			: TEXCOORD3;
		float3 wbinorm			: TEXCOORD4;
		float4 range			: TEXCOORD5;		
}; 
 
//vertex shader
v2f v(a2v In) 
{ 
	v2f Out = (v2f)0; 

	Out.position = mul( In.position , wvp );
	Out.range		= Out.position;

	Out.uv		 	= In.diffuse;

	Out.norm		= mul(In.norm,worldIT);
	Out.wbinorm		= mul(In.binorm,worldIT);
	Out.wtang		= mul(In.tang,worldIT);
	
	return Out; 
}  



//Pixel Shader
float4 f(v2f In) : COLOR 
{ 
	float4 col = tex2D( diffuseSampler , In.uv ).rgba;
	float3 li = -normalize( ldir );

		float3 normal = tex2D( normalSampler , In.uv ).rgb;

		float3 bump = ( normal - float3( 0.5 , 0.5 , 0.5 ) ) * float3( bumpiness , bumpiness , bumpiness );
		normal = normalize( ( bump.b * normalize(In.norm) ) + ( bump.r * In.wtang ) + ( bump.g * In.wbinorm ) );

		return float4( col.rgb * saturate( dot( normal , li ) ) + ( col.rgb * ambient ) , col.a );

}

technique basicRender
{  
	pass p0  
    {		 
	VertexShader = compile vs_3_0 v(); 
	ZEnable = true; 
	ZWriteEnable = true; 
	ZFunc = LessEqual;
	AlphaBlendEnable = true;
	PixelShader = compile ps_3_0 f(); 
	}
}  
