//  
//  UnitConv.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.


using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace LFSLapper
{
    class unitConv
    {
        public static bool isTime( string strTime ){
            Regex regTime = new Regex( "^[0-9]{1}\\.[0-9]{2}\\.[0-9]{2}" );

            return regTime.IsMatch(strTime);

        }
        public static long HMSToLong(int m, int s, int d)
        {
            return (long)((m * 60 * 100) + s * 100 + d ) * 10;
        }
        public static bool isHMST(string time)
        {
            {
                string[] sp = time.Split('.');
                if (sp.Length != 3)
                    return false;
            }
            try
            {
                {
                    string[] sp = time.Split('.');
                    int m = Int32.Parse(sp[0]);
                    int s = Int32.Parse(sp[1]);
                    int d = Int32.Parse(sp[2]);
                    return true;
                }
            }
            catch
            {
                return false;
            }
        }
        public static long HMSToLong(string time)
        {
            try
            {
                string[] sp = time.Trim().Split('.');
                int m = Int32.Parse(sp[0]);
                int s = Int32.Parse(sp[1]);
                int d = Int32.Parse(sp[2]);
                if (time[0] == '-')
                {
                    m = Math.Abs( m );
                    return -HMSToLong(m, s, d);
                }
                else
                    return HMSToLong(m, s, d);
            }
            catch
            {
                return HMSToLong(0, 0, 0);
            }
        }
        public static string LongToHMS(long val)
        {
            long sec;
            long min;
            long hun;
            string sign = "";

            if (val < 0)
            {
                val = -val;
                sign = "-";
            }
            sec = val / 1000;
            hun = sec * 1000;
            hun = (val - hun) / 10;

            val = sec;
            min = val / 60;
            sec = min * 60;
            sec = val - sec;
            return string.Format("{3}{0}.{1,2:D2}.{2,2:D2}", min, sec, hun, sign);
        }

        public static double toMph(double speed)
        {
            return Math.Round( speed / 1.609344,2 );
        }
        public static double toKph(double speed)
        {
            return Math.Round( speed * 1.609344 );
        }
        public static double getSpeed(bool unitSpeedKmh, double speed)
        {
            if (unitSpeedKmh)
                return speed;
            else
                return speed / 1.609344;
        }

    }

}
