#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################
# MyStats addon by Sinanju using almost all Krayy's coding!

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Help", "MyStats", "1.01");
EndCatchEvent

Sub DoCifHelpMyStats ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Help";
	$cifModuleName="MyStats";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "MyStats Help", "DoCifHelp");
	
	openPrivButton( $DialogPrefix . "help",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $cifModuleName . "}%") );
	openPrivButton( $DialogPrefix . "statstitle",73,40,90,8,5,-1,32,langEngine( "%{main_statstitle}%" ));
	openPrivButton( $DialogPrefix . "statsdetails",73,48,90,6,5,-1,16,langEngine( "%{main_statsdetails}%",GetCurrentPlayerVar("UserName"),GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("PosAbs"),GetCurrentPlayerVar("PBDrift"),GetCurrentPlayerVar("Car"),getLapperVar("LongTrackName"),getLapperVar("ShortTrackName"),NumToMSH (GetCurrentPlayerVar("PBLapTime")),NumToMSH (GetCurrentPlayerVar("Tpb")),GetCurrentPlayerVar("Laps"),GetCurrentPlayerVar("Dist"),GetCurrentPlayerVar("UnitDist")));
	openPrivButton( $DialogPrefix . "qualdetails",73,99,90,6,5,-1,32,langEngine( "%{main_qualdetails}%",GetCurrentPlayerVar("PosQual"),GetCurrentPlayerVar("GroupQual"),getLapperVar("ShortDate"),getLapperVar("ShortTime")));
EndSub


Lang "EN" # Race Events messages
	gui_help_contents_MyStats = "^2MyStats";
main_statsbacking = "^2M y S t a t s"; 
main_statstitle = "^7Brought to you by ^1Sin'rs ^3(^1Sin^3anju^1'^3s ^1r^3acing ^1s^3erver)"; # Change this to your own server name/style 

main_statsdetails = "^7Username: ^3{0}^7 - Nickname: {1}"
            . "%nl%"
            . "%nl%^7Your actual friendly Position (all visitors / all vehicles): ^3{2}"
            . "%nl%^7Your current best Drift Score (in ^3{4}^7): ^3{3}"
            . "%nl%"
            . "%nl%^7Current Track: ^3{5}^0 [ {6} ]"
            . "%nl%^7Your current PB Laptime with this combo: ^3{7}"
            . "%nl%^7Theoretical PB: ^3{8}"
            . "%nl%^7You've done: ^3{9} ^7laps, which is approx ^3{10} ^7{11}"
            . "%nl%";

            main_qualdetails = "%nl%"
            . "^4Q u a l i f i c a t i o n   D e t a i l s:"
            . "%nl%^6Current qualification position: ^3{0}"
            . "%nl%^6Current GROUP qualification position: ^3{1}" 
            . "%nl%";
EndLang
