//  
//  Auth.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections.Generic;
using System.Text;

namespace LFSLapper
{
    class Auth
    {

        public bool AuthOn = true;
        public bool AllowAllPlayer = true;
        public String[] LibelLevel = new string[10];
        public String[] AuthString = new string[10];
        public bool[] usedLevel = new bool[10];
        public userGroups ugroup;
        int currString = 0;
        GLDebug.Debug myDebug;

        public Auth( GLDebug.Debug pmyDebug )
        {
            this.myDebug = pmyDebug;
            ugroup = new userGroups(myDebug);
            for (int i = 0; i < 10; i++)
            {
                LibelLevel[i] = "";
                AuthString[i] = "";
            }
        }

        public void AddAuthString(string str)
        {
            string [] par = str.Split(',');
            if (par.Length > 1)
            {
                LibelLevel[currString] = par[0];
                AuthString[currString] = par[1];
            }
            else
            {
                LibelLevel[currString] = (currString+1).ToString();
                AuthString[currString] = par[0];
            }
            currString++;
        }
        public void updAllowedLevel( string allowedLevelString ){


            for( int i = 0; i < 10; i++ )
                this.usedLevel[i] = false;
            string[] tmpAuthAllowPlayer = allowedLevelString.Split('|');
            for (int i = 0; i < tmpAuthAllowPlayer.Length; i++)
            {
                if (tmpAuthAllowPlayer[i].IndexOf("@") == 0) // Players Always Allowed
                {
                    string tmp = tmpAuthAllowPlayer[i].Substring(1);
                    string[] allPlayer = tmp.Split(',');
                    for (int j = 0; j < allPlayer.Length; j++)
                        ugroup.addUser("Allowed",allPlayer[j].ToLower() );
                }
                else
                {
                    int idx = int.Parse(tmpAuthAllowPlayer[i].Substring(4));
                    usedLevel[idx - 1] = true;
                }
            }
        }
    }

}
