# Registration & Login system V1.00	26-05-2014	-Initial release									#
# Registration & Login system V1.01	26-05-2014	-Code cleanup & comments added								#
# Registration & Login system V1.02	28-05-2014	-Fixed a massive bug in Register and then Login account					#
#							-Only show Login button if account is present						#
#							-Only show Register button if no account is present					#
#							-Show warning about password being send&stored in plain text				#
#							-Added button to leave server								#
#							-All clickable buttons are shown with yellow text					#
#							-Added timer to each screen, to avoid people will stil drive, while screen is left open #
#################################################################################################################################################

CatchEvent OnConnect( $userName ) # Player event
	OnConnect_Ask_Registration();
EndCatchEvent

Sub OnConnect_Ask_Registration()
	### Get UserName and search in storedvalue.dbs for saved values for this user ###
	$userName = GetCurrentPlayerVar( "UserName" );

	SetCurrentPlayerVar( "logon_code",GetStoredValue( $userName . "logon_code" ) );
	SetCurrentPlayerVar( "logon_password",GetStoredValue( $userName . "logon_password" ) );
	### End ###

	### Set number of logon attempts to 3 ###
	SetCurrentPlayerVar( "login_attempts",3 );
	### End ###

	### Set left/right and top/bottom coordinates ###
	$left_right_welcome=64;
	$top_bottom_welcome=80;
	### End ###

	openPrivButton( "welcome_bg",$left_right_welcome,$top_bottom_welcome,72,32,5,-1,16,"" );
	openPrivButton( "welcome_title",$left_right_welcome+1,$top_bottom_welcome+1,70,5,5,-1,32,"^7Welcome at this [TEAMNAME] server" );
	openPrivButton( "welcome_server",$left_right_welcome+1,$top_bottom_welcome+6,70,5,5,-1,32,"^7You are on server: " . getLapperVar( "HostName" ) );
	IF ( GetCurrentPlayerVar( "logon_code") != "" && GetCurrentPlayerVar( "logon_password") != "" )
	THEN
	  openPrivButton( "welcome_login",$left_right_welcome+1,$top_bottom_welcome+16,35,5,5,-1,32,"^3Login",Login );
	ENDIF

	IF ( GetCurrentPlayerVar( "logon_code") == "" && GetCurrentPlayerVar( "logon_password") == "" )
	THEN
	  openPrivButton( "welcome_register",$left_right_welcome+1,$top_bottom_welcome+16,35,5,5,-1,32,"^3Register",Register );
	ENDIF
	openPrivButton( "leave_server",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,-1,32,"^3Leave server",Leave_server );
	openPrivButton( "action_required",$left_right_welcome+1,$top_bottom_welcome+26,70,5,5,30,32,"^7Time left before being kicked off the server: %cpt%",Leave_server );
EndSub

Sub Login( $KeyFlags,$id )
	### Set left/right and top/bottom coordinates ###
	$left_right_welcome=64;
	$top_bottom_welcome=80;
	### End ###

	### Close buttons that were drawn when user connected ###
	closePrivButton("welcome_bg&welcome_title&welcome_server&welcome_login&welcome_register&leave_server&warning&action_required");
	### End ###

	openPrivButton( "loginscreen_bg",$left_right_welcome,$top_bottom_welcome,72,42,5,-1,16,"" );
	openPrivButton( "loginscreen_title",$left_right_welcome+1,$top_bottom_welcome+1,70,5,5,-1,32,"^7Login at this [TEAMNAME] server" );
	openPrivButton( "loginscreen_1a",$left_right_welcome+1,$top_bottom_welcome+11,35,5,5,-1,32,"^7Login name: " );
	IF ( GetCurrentPlayerVar( "logon_code_input" ) == "")
	THEN
		openPrivTextButton( "loginscreen_1b",$left_right_welcome+36,$top_bottom_welcome+11,35,5,5,32,"^3Login name","^3Click to enter",40,config_loginname );
	ELSE
		openPrivTextButton( "loginscreen_1b",$left_right_welcome+36,$top_bottom_welcome+11,35,5,5,32,"^3Login name","^3".GetCurrentPlayerVar( "logon_code_input" ),40,config_loginname );
	ENDIF
	openPrivButton( "loginscreen_2a",$left_right_welcome+1,$top_bottom_welcome+16,35,5,5,-1,32,"^7Password: " );
	IF ( GetCurrentPlayerVar( "logon_password_input" ) == "")
	THEN
		openPrivTextButton( "loginscreen_2b",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,32,"^3Password","^3Click to enter",40,config_password );
	ELSE
		openPrivTextButton( "loginscreen_2b",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,32,"^3Password","^3".GetCurrentPlayerVar( "logon_password_input" ),40,config_password );
	ENDIF

	openPrivButton( "loginscreen_check",$left_right_welcome+1,$top_bottom_welcome+26,35,5,5,-1,32,"^3Login",Check_login );
	openPrivButton( "leave_server",$left_right_welcome+36,$top_bottom_welcome+26,35,5,5,-1,32,"^3Leave server",Leave_server );
	openPrivButton( "action_required",$left_right_welcome+1,$top_bottom_welcome+36,70,5,5,60,32,"^7Time left before being kicked off the server: %cpt%",Leave_server );
EndSub

Sub Register( $KeyFlags,$id )
	### Set left/right and top/bottom coordinates ###
	$left_right_welcome=64;
	$top_bottom_welcome=80;
	### End ###

	### Close buttons that were drawn when user connected ###
	closePrivButton("welcome_bg&welcome_title&welcome_server&welcome_login&welcome_register&leave_server&action_required");
	### End ###

	### Check if user already has a registered account on this server, start registration if not, redirect to login screen if account is present ###
	IF ( GetCurrentPlayerVar( "logon_code") == "" && GetCurrentPlayerVar( "logon_password") == "" )
	THEN
	  openPrivButton( "register_bg",$left_right_welcome,$top_bottom_welcome,72,67,5,-1,16,"" );
	  openPrivButton( "register_title",$left_right_welcome+1,$top_bottom_welcome+1,70,5,5,-1,32,"^7Register at this [TEAMNAME] server" );
	  openPrivButton( "warning",$left_right_welcome+1,$top_bottom_welcome+11,70,5,5,-1,96,"  ^1!!! WARNING   ^7-   ^1WARNING   ^7-   ^1WARNING   ^7-   ^1WARNING !!!  "
		. "%nl%^7 "
		. "%nl%^7- Your password is send and stored in plain text"		
		. "%nl%^7- ^1DON'T^7 use a password you use regularly somewhere else");
	  openPrivButton( "register_1a",$left_right_welcome+1,$top_bottom_welcome+36,35,5,5,-1,32,"^7Login name: " );
	  IF ( GetCurrentPlayerVar( "logon_code_input_2" ) == "")
	  THEN
		openPrivTextButton( "register_1b",$left_right_welcome+36,$top_bottom_welcome+36,35,5,5,32,"^3Login name","^3Click to enter",40,config_loginname_2 );
	  ELSE
		openPrivTextButton( "register_1b",$left_right_welcome+36,$top_bottom_welcome+36,35,5,5,32,"^3Login name","^3".GetCurrentPlayerVar( "logon_code_input_2" ),40,config_loginname_2 );
	  ENDIF
	  openPrivButton( "loginscreen_2a",$left_right_welcome+1,$top_bottom_welcome+41,35,5,5,-1,32,"^7Password: " );
	  IF ( GetCurrentPlayerVar( "logon_password_input_2" ) == "")
	  THEN
		openPrivTextButton( "register_2b",$left_right_welcome+36,$top_bottom_welcome+41,35,5,5,32,"^3Password","^3Click to enter",40,config_password_2 );
	  ELSE
		openPrivTextButton( "register_2b",$left_right_welcome+36,$top_bottom_welcome+41,35,5,5,32,"^3Password","^3".GetCurrentPlayerVar( "logon_password_input_2" ),40,config_password_2 );
	  ENDIF

	  openPrivButton( "registration_check",$left_right_welcome+1,$top_bottom_welcome+51,35,5,5,-1,32,"^3Register account",Check_registration );
	  openPrivButton( "leave_server",$left_right_welcome+36,$top_bottom_welcome+51,35,5,5,-1,32,"^3Leave server",Leave_server );
	  openPrivButton( "action_required",$left_right_welcome+1,$top_bottom_welcome+61,70,5,5,60,32,"^7Time left before being kicked off the server: %cpt%",Leave_server );
	ELSE
	  PrivMsg ("^1WARNING: ^7You already have an account on this server");
	  PrivMsg ("^1WARNING: " . GetCurrentPlayerVar( "logon_code") );
	  Login( $KeyFlags,$id );
	ENDIF
	### End ###
EndSub

Sub config_loginname ( $loginname_value,$text )
	### Collect login name which has been entered in login screen ###
	$loginname=$text;
	SetCurrentPlayerVar( "logon_code_input",$loginname );
	Login( $KeyFlags,$id );
	### End ###
EndSub

Sub config_password ( $password_value,$text )
	### Collect password name which has been entered in login screen ###
	$password=$text;
	SetCurrentPlayerVar( "logon_password_input",$password );
	Login( $KeyFlags,$id );
	### End ###
EndSub

Sub Check_login ( $KeyFlags,$id )
	### Get UserName and search in storedvalue.dbs for saved values for this user ###
	$userName = GetCurrentPlayerVar( "UserName" );

	SetCurrentPlayerVar( "logon_code",GetStoredValue( $userName . "logon_code" ) );
	SetCurrentPlayerVar( "logon_password",GetStoredValue( $userName . "logon_password" ) );
	### End ###

	IF ( GetCurrentPlayerVar( "logon_code_input") == GetCurrentPlayerVar( "logon_code") && GetCurrentPlayerVar( "logon_password_input" ) == GetCurrentPlayerVar( "logon_password") )
	THEN
	  closePrivButton("loginscreen_bg&loginscreen_title&loginscreen_1a&loginscreen_1b&loginscreen_2a&loginscreen_2b&loginscreen_check&leave_server&action_required");
	  PrivMsg ("^7Login okay");
	ELSE
	  PrivMsg ("^1WARNING: ^7Login NOT okay");

	  $login_attempts=ToNum(GetCurrentPlayerVar( "login_attempts"));
	  $login_attempts=$login_attempts-1;
	  SetCurrentPlayerVar( "login_attempts",ToNum($login_attempts) );
	  
	  IF ( GetCurrentPlayerVar( "login_attempts") > 0)
	  THEN
	    PrivMsg ("^7Login attempts left: " . GetCurrentPlayerVar( "login_attempts")  );
	    Login( $KeyFlags,$id );
	  ELSE
	    cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
	  ENDIF
	ENDIF
EndSub

Sub config_loginname_2 ( $loginname_value,$text )
	### Collect login name which has been entered in registration screen ###
	$loginname=$text;
	SetCurrentPlayerVar( "logon_code_input_2",$loginname );
	Register( $KeyFlags,$id );
	### End ###
EndSub

Sub config_password_2 ( $password_value,$text )
	### Collect password which has been entered in registration screen ###
	$password=$text;
	SetCurrentPlayerVar( "logon_password_input_2",$password );
	Register( $KeyFlags,$id );
	### End ###
EndSub

Sub Check_registration ( $KeyFlags,$id )
	IF ( GetCurrentPlayerVar( "logon_code_input_2") != "" && GetCurrentPlayerVar( "logon_password_input_2") != "" )
	THEN
	  $userName = GetCurrentPlayerVar( "UserName" );
	  SetStoredValue( $userName . "logon_code", GetCurrentPlayerVar( "logon_code_input_2" ) );
	  SetStoredValue( $userName . "logon_password", GetCurrentPlayerVar( "logon_password_input_2" ) );
	  closePrivButton("register_bg&register_title&warning&register_1a&register_1b&register_2a&register_2b&registration_check&leave_server");
	  PrivMsg ("^7Registration okay");
	  Login( $KeyFlags,$id );
	ELSE
	  IF ( GetCurrentPlayerVar( "logon_code_input_2") != "" && GetCurrentPlayerVar( "logon_password_input_2") == "" )
	  THEN
	    PrivMsg ("^1WARNING: ^7Password NOT set");
	    Register( $KeyFlags,$id );
	  ELSE
	    IF ( GetCurrentPlayerVar( "logon_code_input_2") == "" )
	    THEN
	      PrivMsg ("^1WARNING: ^7Login name NOT set");
	      Register( $KeyFlags,$id );
	    ENDIF
	  ENDIF
	ENDIF
EndSub

Sub Leave_server ( $KeyFlags,$id )
	cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
EndSub