# Registration & Login system V1.00	26-05-2014	Initial release		      #
# Registration & Login system V1.01	26-05-2014	Code cleanup & comments added #
#######################################################################################

CatchEvent OnConnect( $userName ) # Player event
	OnConnect_Ask_Registration();
EndCatchEvent

Sub OnConnect_Ask_Registration()
	### Get UserName and search in storedvalue.dbs for saved values for this user ###
	$userName = GetCurrentPlayerVar( "UserName" );

	SetCurrentPlayerVar( "logon_code",GetStoredValue( $userName . "logon_code" ) );
	SetCurrentPlayerVar( "logon_password",GetStoredValue( $userName . "logon_password" ) );
	### End ###

	### Set number of logon attempts to 3 ###
	SetCurrentPlayerVar( "login_attempts",3 );
	### End ###

	### Set left/right and top/bottom coordinates ###
	$left_right_welcome=64;
	$top_bottom_welcome=80;
	### End ###

	openPrivButton( "welcome_bg",$left_right_welcome,$top_bottom_welcome,72,22,5,-1,16,"" );
	openPrivButton( "welcome_title",$left_right_welcome+1,$top_bottom_welcome+1,70,5,5,-1,32,"^7Welcome at this [TEAMNAME] server" );
	openPrivButton( "welcome_server",$left_right_welcome+1,$top_bottom_welcome+6,70,5,5,-1,32,"^7You are on server: " . getLapperVar( "HostName" ) );
	openPrivButton( "welcome_login",$left_right_welcome+1,$top_bottom_welcome+16,35,5,5,-1,32,"^2Login",Login );
	openPrivButton( "welcome_register",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,-1,32,"^1Register",Register );
EndSub

Sub Login( $KeyFlags,$id )
	### Set left/right and top/bottom coordinates ###
	$left_right_welcome=64;
	$top_bottom_welcome=80;
	### End ###

	### Close buttons that were drawn when user connected ###
	closePrivButton("welcome_bg&welcome_title&welcome_server&welcome_login&welcome_register");
	### End ###

	openPrivButton( "loginscreen_bg",$left_right_welcome,$top_bottom_welcome,72,32,5,-1,16,"" );
	openPrivButton( "loginscreen_title",$left_right_welcome+1,$top_bottom_welcome+1,70,5,5,-1,32,"^7Login at this [TEAMNAME] server" );
	openPrivButton( "loginscreen_1a",$left_right_welcome+1,$top_bottom_welcome+11,35,5,5,-1,32,"^7Login name: " );
	IF ( GetCurrentPlayerVar( "logon_code_input" ) == "")
	THEN
		openPrivTextButton( "loginscreen_1b",$left_right_welcome+36,$top_bottom_welcome+11,35,5,5,32,"^3Login name","^3Click to enter",40,config_loginname );
	ELSE
		openPrivTextButton( "loginscreen_1b",$left_right_welcome+36,$top_bottom_welcome+11,35,5,5,32,"^3Login name","^3".GetCurrentPlayerVar( "logon_code_input" ),40,config_loginname );
	ENDIF
	openPrivButton( "loginscreen_2a",$left_right_welcome+1,$top_bottom_welcome+16,35,5,5,-1,32,"^7Password: " );
	IF ( GetCurrentPlayerVar( "logon_password_input" ) == "")
	THEN
		openPrivTextButton( "loginscreen_2b",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,32,"^3Password","^3Click to enter",40,config_password );
	ELSE
		openPrivTextButton( "loginscreen_2b",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,32,"^3Password","^3".GetCurrentPlayerVar( "logon_password_input" ),40,config_password );
	ENDIF

	openPrivButton( "loginscreen_check",$left_right_welcome+1,$top_bottom_welcome+26,70,5,5,-1,32,"^2Check Login",Check_login );
EndSub

Sub Register( $KeyFlags,$id )
	### Set left/right and top/bottom coordinates ###
	$left_right_welcome=64;
	$top_bottom_welcome=80;
	### End ###

	### Close buttons that were drawn when user connected ###
	closePrivButton("welcome_bg&welcome_title&welcome_server&welcome_login&welcome_register");
	### End ###

	### Check if user already has a registered account on this server, start registration if not, redirect to login screen if account is present ###
	IF ( GetCurrentPlayerVar( "logon_code") == "" && GetCurrentPlayerVar( "logon_password") == "" )
	THEN
	  openPrivButton( "register_bg",$left_right_welcome,$top_bottom_welcome,72,32,5,-1,16,"" );
	  openPrivButton( "register_title",$left_right_welcome+1,$top_bottom_welcome+1,70,5,5,-1,32,"^7Register at this [TEAMNAME] server" );
	  openPrivButton( "register_1a",$left_right_welcome+1,$top_bottom_welcome+11,35,5,5,-1,32,"^7Login name: " );
	  IF ( GetCurrentPlayerVar( "logon_code_input_2" ) == "")
	  THEN
		openPrivTextButton( "register_1b",$left_right_welcome+36,$top_bottom_welcome+11,35,5,5,32,"^3Login name","^3Click to enter",40,config_loginname_2 );
	  ELSE
		openPrivTextButton( "register_1b",$left_right_welcome+36,$top_bottom_welcome+11,35,5,5,32,"^3Login name","^3".GetCurrentPlayerVar( "logon_code_input_2" ),40,config_loginname_2 );
	  ENDIF
	  openPrivButton( "loginscreen_2a",$left_right_welcome+1,$top_bottom_welcome+16,35,5,5,-1,32,"^7Password: " );
	  IF ( GetCurrentPlayerVar( "logon_password_input_2" ) == "")
	  THEN
		openPrivTextButton( "register_2b",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,32,"^3Password","^3Click to enter",40,config_password_2 );
	  ELSE
		openPrivTextButton( "register_2b",$left_right_welcome+36,$top_bottom_welcome+16,35,5,5,32,"^3Password","^3".GetCurrentPlayerVar( "logon_password_input_2" ),40,config_password_2 );
	  ENDIF

	  openPrivButton( "registration_check",$left_right_welcome+1,$top_bottom_welcome+26,70,5,5,-1,32,"^2Check registration",Check_registration );
	ELSE
	  PrivMsg ("^1WARNING: ^7You already have an account on this server");
	  PrivMsg ("^1WARNING: " . GetCurrentPlayerVar( "logon_code") );
	  Login( $KeyFlags,$id );
	ENDIF
	### End ###
EndSub

Sub config_loginname ( $loginname_value,$text )
	### Collect login name which has been entered in login screen ###
	$loginname=$text;
	SetCurrentPlayerVar( "logon_code_input",$loginname );
	Login( $KeyFlags,$id );
	### End ###
EndSub

Sub config_password ( $password_value,$text )
	### Collect password name which has been entered in login screen ###
	$password=$text;
	SetCurrentPlayerVar( "logon_password_input",$password );
	Login( $KeyFlags,$id );
	### End ###
EndSub

Sub Check_login ( $KeyFlags,$id )
	$userName = GetCurrentPlayerVar( "UserName" );
	IF ( GetCurrentPlayerVar( "logon_code_input") == GetCurrentPlayerVar( "logon_code") && GetCurrentPlayerVar( "logon_password_input" ) == GetCurrentPlayerVar( "logon_password") )
	THEN
	  closePrivButton("loginscreen_bg&loginscreen_title&loginscreen_1a&loginscreen_1b&loginscreen_2a&loginscreen_2b&loginscreen_check");
	  PrivMsg ("^7Login okay");
	ELSE
	  PrivMsg ("^1WARNING: ^7Login NOT okay");

	  $login_attempts=ToNum(GetCurrentPlayerVar( "login_attempts"));
	  $login_attempts=$login_attempts-1;
	  SetCurrentPlayerVar( "login_attempts",ToNum($login_attempts) );
	  
	  IF ( GetCurrentPlayerVar( "login_attempts") > 0)
	  THEN
	    PrivMsg ("^7Login attempts left: " . GetCurrentPlayerVar( "login_attempts")  );
	    Login( $KeyFlags,$id );
	  ELSE
	    cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
	  ENDIF
	ENDIF
EndSub

Sub config_loginname_2 ( $loginname_value,$text )
	### Collect login name which has been entered in registration screen ###
	$loginname=$text;
	SetCurrentPlayerVar( "logon_code_input_2",$loginname );
	Register( $KeyFlags,$id );
	### End ###
EndSub

Sub config_password_2 ( $password_value,$text )
	### Collect password which has been entered in registration screen ###
	$password=$text;
	SetCurrentPlayerVar( "logon_password_input_2",$password );
	Register( $KeyFlags,$id );
	### End ###
EndSub

Sub Check_registration ( $KeyFlags,$id )
	IF ( GetCurrentPlayerVar( "logon_code_input_2") != "" && GetCurrentPlayerVar( "logon_password_input_2") != "" )
	THEN
	  $userName = GetCurrentPlayerVar( "UserName" );
	  SetStoredValue( $userName . "logon_code", GetCurrentPlayerVar( "logon_code" ) );
	  SetStoredValue( $userName . "logon_password", GetCurrentPlayerVar( "logon_password" ) );
	  closePrivButton("register_bg&register_title&register_1a&register_1b&register_2a&register_2b&registration_check");
	  PrivMsg ("^7Registration okay");
	  Login( $KeyFlags,$id );
	ELSE
	  IF ( GetCurrentPlayerVar( "logon_code_input_2") != "" && GetCurrentPlayerVar( "logon_password_input_2") == "" )
	  THEN
	    PrivMsg ("^1WARNING: ^7Password NOT set");
	    Register( $KeyFlags,$id );
	  ELSE
	    IF ( GetCurrentPlayerVar( "logon_code_input_2") == "" )
	    THEN
	      PrivMsg ("^1WARNING: ^7Login name NOT set");
	      Register( $KeyFlags,$id );
	    ENDIF
	  ENDIF
	ENDIF
EndSub