#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.1 - 15 Jan 2010 Initial release
# Ver 1.0.2 - 16 Jan 2010 Minor updates to display
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
#############################################################################

CatchEvent OnLapperStart()
	### Set Dialog prefix and initial left/right and top/bottom coordinates ###
	GlobalVar $HLPRoot; $HLPRoot = "HLP";
	GlobalVar $HLPPrefix; $HLPPrefix = $HLPRoot . "-";		# Dialog prefix...used in Close Regex
	GlobalVar $HLPorigT; $HLPorigT = 35;			# Top edge of window
	GlobalVar $HLPorigL; $HLPorigL = 68;	# Left edge of main content window

	### Set up global var for Help GUI Tabs & increase HLP_MAX ####
	GlobalVar $HLP_GENERAL; $HLP_GENERAL = 0;
	GlobalVar $HLP_STATS;   $HLP_STATS = 1;
	GlobalVar $HLP_ADMIN;   $HLP_ADMIN = 2;
	GlobalVar $HLP_CUSTOM;   $HLP_CUSTOM = 3;

	GlobalVar $GUI_HELP_ITEMS;
	$GUI_HELP_ITEMS = "General,Stats,Admin,Custom";

EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!help":
			DoHelpGeneral(0, "gui_help_header_General");
			BREAK;
	ENDSWITCH
EndCatchEvent

############################
#Replacement Help Functions#
############################

Sub DrawHelpGUI($HighLightedItemNum, $TabTitle)
	# Draw the main Admin Framework dialog box
	DrawGUI(  $HLPRoot, $TabTitle, $HLPorigT, $HLPorigL, "DoHelp", $HighLightedItemNum, $GUI_HELP_ITEMS );

	# Display the help text
	openPrivButton ( $HLPPrefix . "contents",$HLPorigL+1,$HLPorigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $HighLightedItemNum . "}%") );
EndSub

Sub DoHelpGeneral ( $KeyFlags, $id )
	DrawHelpGUI($HLP_GENERAL,"General Help");
EndSub

Sub DoHelpStats ( $KeyFlags, $id )
	DrawHelpGUI($HLP_STATS,"Stats Commands");
EndSub

Sub DoHelpAdmin ( $KeyFlags, $id )
	DrawHelpGUI($HLP_ADMIN,"Admin Commands");
EndSub

Sub DoHelpCustom ( $KeyFlags, $id )
	DrawHelpGUI($HLP_CUSTOM,"Custom Commands");
EndSub

Lang "EN" # Race Events messages
	gui_help_contents_0 = "^2General Player commands"
			. "%nl%^3!cleanspb ^8- Reset this sessions PBs"
			. "%nl%^3!groupqual ^8- Show group qualifying pos"
			. "%nl%^3!hand [name] ^8- Show current handicap"
			. "%nl%^3!hc ^8- Show all players current handicaps"
			. "%nl%^3!laps ^8- Total laps done for this car/track + session"
			. "%nl%^3!license [name] ^8- Display license status"
			. "%nl%^3!myconfig ^8- Configure split time display"
			. "%nl%^3!mypb [cars] ^8- Show user PBs for set of cars"
			. "%nl%^3!pos ^8- Show friendly position"
			. "%nl%^3!stats [name] ^8- Display user stats"
			. "%nl%^3!statsqual [name] ^8- Display user stats"
			. "%nl%^3!who ^8- Display connected user info and stats"
			. "%nl%"
			. "%nl%^2Pit Board Setup and Info"
			. "%nl%^3!pbclose ^8- Close pit board"
			. "%nl%^3!pbconfig ^8- Configure Pit Board"
			. "%nl%^3!pit ^8- Pit stop info"
			. "%nl%^3!pitwindow ^8- Configure pit windows";
	gui_help_contents_1 = "^2Track/Race Info"
			. "%nl%^3!distance ^8- Show track distance"
			. "%nl%^3!near [name] ^8- Show top 14 drivers near your ranking"
			. "%nl%^3!nearqual [name] ^8- Show top qualifiers near your time"
			. "%nl%^3!spb ^8- Show splits"
			. "%nl%^3!top [car] ^8- Show top drivers with this track/car"
			. "%nl%^3!topqual [car] ^8- Show top qual times with this car"
			. "%nl%^3!track ^8- Show current track information"
			. "%nl%"
			. "%nl%^2Drifting Info"
			. "%nl%^3!drf [name] ^8- "
			. "%nl%^3!drfnear [name] ^8- "
			. "%nl%^3!drfnearqual [name] ^8- "
			. "%nl%^3!drfqual [name] ^8- "
			. "%nl%^3!dstats [name] ^8- "
			. "%nl%^3!dstatsqual [name] ^8- "
			. "%nl%"
			. "%nl%^2LFSLapper Info"
			. "%nl%^3!time ^8- Show local server time"
			. "%nl%^3!powered ^8- Show Copyright Notice"
			. "%nl%^3!ver ^8- Show LFSLapper version";
	gui_help_contents_2 = "^2Admin Commands"
			. "%nl%^3!ban [username] ^8- Ban [username] from server"
			. "%nl%^3!ctrack ^8- Configure track (GUI)"
			. "%nl%^3!groupcmdlfs [cmd] ^8- Execute [cmd] on all players"
			. "%nl%^3!gui ^8- Update race config GUI"
			. "%nl%^3!hc ^8- Set player handicaps"
			. "%nl%^3!kick [username] ^8- Kick [username] from server"
			. "%nl%^3!node ^8- LFS Server Node number"
			. "%nl%^3!pwgui ^8- GUI to set race pit windows"
			. "%nl%^3!sc ^8- Deploy Safety Car"
			. "%nl%^3!term ^8- Terminate LFSLapper"
			. "%nl%^3!zone ^8- Display current node on track";
	gui_help_contents_3 = "^2Custom Commands"
			. "%nl%^3!event ^8- Set up race event"
			. "%nl%^3!admins ^8- Add or display admins"
			. "%nl%^3!sc ^8- Deploy or Manage Safety Car";
EndLang
