#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.1 - 15 Jan 2010 Initial release
# Ver 1.0.2 - 16 Jan 2010 Minor updates to display
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!help":
			DoCifHelpGeneral(0, "gui_help_header_General");
			BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Help", "General", "1.01");
EndCatchEvent

Sub DoCifHelpGeneral ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Help";
	$cifModuleName="General";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "General Help");
	openPrivButton ( $DialogPrefix . "help",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $cifModuleName . "}%") );
EndSub

Lang "EN" # Race Events messages
	gui_help_contents_General = "^2General Player commands"
			. "%nl%^3!cleanspb ^8- Reset this sessions PBs"
			. "%nl%^3!groupqual ^8- Show group qualifying pos"
			. "%nl%^3!hand [name] ^8- Show current handicap"
			. "%nl%^3!hc ^8- Show all players current handicaps"
			. "%nl%^3!laps ^8- Total laps done for this car/track + session"
			. "%nl%^3!license [name] ^8- Display license status"
			. "%nl%^3!myconfig ^8- Configure split time display"
			. "%nl%^3!mypb [cars] ^8- Show user PBs for set of cars"
			. "%nl%^3!pos ^8- Show friendly position"
			. "%nl%^3!stats [name] ^8- Display user stats"
			. "%nl%^3!statsqual [name] ^8- Display user stats"
			. "%nl%^3!who ^8- Display connected user info and stats"
			. "%nl%"
			. "%nl%^2Pit Board Setup and Info"
			. "%nl%^3!pbclose ^8- Close pit board"
			. "%nl%^3!pbconfig ^8- Configure Pit Board"
			. "%nl%^3!pit ^8- Pit stop info"
			. "%nl%^3!pitwindow ^8- Configure pit windows";
EndLang
