//  
//  LFSServers.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.IO;
using System.Collections;
using System.Text;

namespace LapperInstances
{
    class LFSServers
    {
		public static int remotePort = 3000;
		public static int timeOutScript = 2000;
        static public void getServerConfig()
        {

            if (!File.Exists("LFSServers.cfg"))
            {
                throw (new System.Exception("Error LFSServers.cfg config file do not exist!"));
            }
            {
                StreamReader sr = new StreamReader("LFSServers.cfg");
                while (!sr.EndOfStream)
                {

                    string line = sr.ReadLine();
                    if (line.Trim() == "")
                        continue;
                    if (line[0] == '#')
                        continue;
					if (line.ToLower().IndexOf("remoteport") == 0)
					{
						try
						{
							string[] par = line.Split('=');
							remotePort = int.Parse(par[1].Replace(';', ' ').Trim());
						}
						catch
						{
							throw (new System.Exception("Error in LFSServers.cfg on remote port"));
						}
						continue;
					}
					if (line.ToLower().IndexOf("timeoutscript") == 0)
					{
						try
						{
							string[] par = line.Split('=');
							timeOutScript = int.Parse(par[1].Replace(';', ' ').Trim());
						}
						catch
						{
							throw (new System.Exception("Error in LFSServers.cfg on timeOutScript"));
						}
						continue;
					}
				}
                sr.Close();
            }
        }

    }

}
