#############################################################################
# LFS Handicapping Interface by Krayy
#############################################################################
# Ver 1.0.1 11-08-09 Initial release
# Ver 1.0.5 22-08-09 Major changes to functionality
#                    Added Save/Load code to store and retreive values
#                    Multiple column support for up to 32 players
#                    Changed button names to be unique
# Ver 1.0.6 27/12/09 Updated to be compatible with LFSLapper v5.918
#############################################################################

CatchEvent OnLapperStart()
	GlobalVar $ListOfHandicaps;
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!hc":
            		DoHandicapper(0,0);
            		BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoHandicapper ( $KeyFlags, $id )
	### Set initial values for left/right and top/bottom coordinates ###
	$x_left = 30;
	$x_right = 101;
	$ybase = 20;
	$topleft_y = $ybase;
	$lineHeight=6;
	$NumConns = GetLapperVar("numconns");
	
	# Set the dialog background
	$bgheight = ($lineHeight*20)+2;
	openPrivButton( "hc_bg",$x_left-1,$topleft_y-1,142,$bgheight,1,-1,32,"");

	openPrivButton( "hc_title",50,$topleft_y,100,($lineHeight*2)-1,1,-1,19,"Player Handicaps");

	$topleft_y=$topleft_y+($lineHeight*2);
	# Left hand titles
	openPrivButton ("hc_luser",$x_left,$topleft_y,37,$lineHeight,1,-1,96,"Username");
	openPrivButton ("hc_lweight",$x_left+38,$topleft_y,15,$lineHeight,1,-1,32,"Weight");
	openPrivButton ("hc_lintake",$x_left+54,$topleft_y,15,$lineHeight,1,-1,32,"Intake");

	# Right hand titles
	openPrivButton ("hc_ruser",$x_right,$topleft_y,37,$lineHeight,1,-1,96,"Username");
	openPrivButton ("hc_rweight",$x_right+38,$topleft_y,15,$lineHeight,1,-1,32,"Weight");
	openPrivButton ("hc_rintake",$x_right+54,$topleft_y,15,$lineHeight,1,-1,32,"Intake");

	DoHandicapper_ClearLines ( 0,0 );
	PopulateListOfHandicaps(0,0);
	DoHandicapper_Print(0,0);

	# Set different buttons for Admins vs Players
	IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 )
	THEN
		openPrivButton( "b_reload",60,$bgheight+$ybase,26,($lineHeight*2)-2,10,-1,32,"^3DB Load",DoHandicapper_Load );
		openPrivButton( "b_close",87,$bgheight+$ybase,26,($lineHeight*2)-2,10,-1,32,"^3Close",DoHandicapper_Close );
		openPrivButton( "b_save",116,$bgheight+$ybase,26,($lineHeight*2)-2,10,-1,32,"^3DB Save",DoHandicapper_Save );
	ELSE
		openPrivButton( "b_close",87,$bgheight+$ybase,24,($lineHeight*2)-2,10,-1,32,"^3Close",DoHandicapper_Close );
	ENDIF

EndSub

Sub PopulateListOfHandicaps ( $KeyFlags, $id ) # Player event
	### Add UserName to $ListOfHandicaps together with $number_of_stops ###
	$HcPlayerList = GetListOfPlayers("N");
	FOR ($i=0;$i<=31;$i=$i+1)
		IF ($HcPlayerList[$i] != "")
		THEN
		  $ListOfHandicaps[$i] = $HcPlayerList[$i];
		ELSE
		  $ListOfHandicaps[$i] = "";
		ENDIF
	ENDFOR
EndSub

Sub DoHandicapper_Print ( $KeyFlags, $id )

	$x_left = 30;
	$x_right = 101;
	$topleft_y = 32;
	$lineHeight=6;
	$topleft_y=$topleft_y+$lineHeight;
	$userTopY=$topleft_y;
	$plyNum=0;
	
	FOR ($i=0;$i<=31;$i=$i+1)
		$uName = $ListOfHandicaps[$i];
		$uNick = GetPlayerVar($uName,"NickName");
		IF ($uName != "")
		THEN
			$plyNum=$plyNum+1;
	
			IF ($plyNum == 17)
			THEN
				$topleft_y=$userTopY;
			ENDIF

			# Draw in second column if the ID is greater than 16
			IF ($plyNum > 16)
			THEN
				$xloc=$x_right;
			ELSE
				$xloc=$x_left;
			ENDIF

			openPrivButton ("hUser_".$i,$xloc,$topleft_y,37,$lineHeight,1,-1,96,"^7". $uNick);
			
			# Set the header row and display different info for Admins vs Players
			IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 )
			THEN
				openPrivButton ("wLess_".$i,$xloc+38,$topleft_y,3,$lineHeight,1,-1,32,"^2-",DoHandicapper_wLess);
				openPrivButton ("wCurr_".$i,$xloc+41,$topleft_y,9,$lineHeight,1,-1,32,GetPlayerVar($uName,"P_Mass") ."/^3" . GetPlayerVar($uName,"H_Mass"));
				openPrivButton ("wMore_".$i,$xloc+50,$topleft_y,3,$lineHeight,1,-1,32,"^2+",DoHandicapper_wMore);
				openPrivButton ("iLess_".$i,$xloc+54,$topleft_y,3,$lineHeight,1,-1,32,"^2-",DoHandicapper_iLess);
				openPrivButton ("iCurr_".$i,$xloc+57,$topleft_y,9,$lineHeight,1,-1,32,GetPlayerVar($uName,"P_Tres") ."/^3" . GetPlayerVar($uName,"H_Tres"));
				openPrivButton ("iMore_".$i,$xloc+66,$topleft_y,3,$lineHeight,1,-1,32,"^2+",DoHandicapper_iMore);
			ELSE
				openPrivButton ("wCurr_".$i,$xloc+38,$topleft_y,15,$lineHeight,1,-1,32,GetPlayerVar($uName,"P_Mass") ."/^3" . GetPlayerVar($uName,"H_Mass"));
				openPrivButton ("iCurr_".$i,$xloc+54,$topleft_y,15,$lineHeight,1,-1,32,GetPlayerVar($uName,"P_Tres") ."/^3" . GetPlayerVar($uName,"H_Tres"));
			ENDIF

			# Increase $topleft_y by $lineHeight before drawing next row
			$topleft_y=$topleft_y+$lineHeight;
		ELSE
			closePrivButton ("hUser_".$i."&wLess_".$i."&wCurr_".$i."&wMore_".$i."&iLess_".$i."&iCurr_".$i."&iMore_".$i);
		ENDIF
	ENDFOR

EndSub

Sub DoHandicapper_wLess ( $KeyFlags, $id )
	$uName = $ListOfHandicaps[ToNum(split( $id,"_",1 ))];
	$uMass = GetPlayerVar($uName,"H_Mass");
	IF ($KeyFlags > 1)
	THEN
	    $uMass=$uMass-5;
	ELSE
	    $uMass=$uMass-1;
	ENDIF
	IF ( $uMass < 0 )
	THEN
		$uMass = 0;
	ENDIF
	SetPlayerVar($uName,"H_Mass",$uMass);
	DoHandicapper_Print(0,0);
EndSub

Sub DoHandicapper_wMore ( $KeyFlags, $id )
	$uName = $ListOfHandicaps[ToNum(split( $id,"_",1 ))];
	$uMass = GetPlayerVar($uName,"H_Mass");
	IF ($KeyFlags > 1)
	THEN
	    $uMass=$uMass+5;
	ELSE
	    $uMass=$uMass+1;
	ENDIF
	IF ( $uMass > 200 )
	THEN
		$uMass = 200;
	ENDIF
	SetPlayerVar($uName,"H_Mass",$uMass);
	DoHandicapper_Print(0,0);
EndSub

Sub DoHandicapper_iLess ( $KeyFlags, $id )
	$uName = $ListOfHandicaps[ToNum(split( $id,"_",1 ))];
	$uTres = GetPlayerVar($uName,"H_Tres");
	IF ($KeyFlags > 1)
	THEN
	    $uTres=$uTres-5;
	ELSE
	    $uTres=$uTres-1;
	ENDIF
	IF ( $uTres < 0 )
	THEN
		$uTres = 0;
	ENDIF
	SetPlayerVar($uName,"H_Tres",$uTres);
	DoHandicapper_Print(0,0);
EndSub

Sub DoHandicapper_iMore ( $KeyFlags, $id )
	$uName = $ListOfHandicaps[ToNum(split( $id,"_",1 ))];
	$uTres = GetPlayerVar($uName,"H_Tres");
	IF ($KeyFlags > 1)
	THEN
	    $uTres=$uTres+5;
	ELSE
	    $uTres=$uTres+1;
	ENDIF
	IF ( $uTres > 50 )
	THEN
		$uTres = 50;
	ENDIF
	SetPlayerVar($uName,"H_Tres",$uTres);
	DoHandicapper_Print(0,0);
EndSub

Sub DoHandicapper_Save($KeyFlags, $id)
	FOR ($i=0;$i<=31;$i=$i+1)
		$uName = $ListOfHandicaps[$i];
		IF ($uName != "")
		THEN
			SetUserStoredValue( $uName, "H_Mass", GetPlayerVar($uName,"H_Mass"));
			SetUserStoredValue( $uName, "H_Tres", GetPlayerVar($uName,"H_Tres"));
		ENDIF
	ENDFOR
	DoHandicapper(0,0);
EndSub

Sub Handicapper_DbLoad()
	FOR ($i=0; $i<=31; $i=$i+1)
		$uName = $ListOfHandicaps[$i];
		IF ($uName != "")
		THEN
			$uMass = GetUserStoredValue( $uName, "H_Mass");
			$uTres = GetUserStoredValue( $uName, "H_Tres");
			SetPlayerVar($uName,"H_Mass",$uMass);
			SetPlayerVar($uName,"H_Tres",$uTres);
		ENDIF
	ENDFOR
EndSub

Sub DoHandicapper_Load($KeyFlags, $id)
	Handicapper_DbLoad();
	DoHandicapper(0,0);
EndSub

Sub DoHandicapper_Close ( $KeyFlags, $id )
	closePrivButton ("hc_title&hc_bg&hc_iLess&hc_iMore&hc_lintake&hc_luser&hc_lweight&hc_rintake&hc_ruser&hc_rweight&hc_wLess&h_wMore&b_close&b_save&b_reload");
	DoHandicapper_ClearLines ( 0,0 );
EndSub

Sub DoHandicapper_ClearLines ( $KeyFlags, $id )
	FOR ($i=0;$i<=31;$i=$i+1)
		closePrivButton ("hUser_".$i."&wLess_".$i."&wCurr_".$i."&wMore_".$i."&iLess_".$i."&iCurr_".$i."&iMore_".$i);
	ENDFOR
EndSub
