
#define WINDOW_NAME "Live for Speed"
#define PROG_NAME   "Color Chat"
#define VER         "v0.03"
#define CONFIG_NAME "ColorChat_config.txt"

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

void press();
void config();

int def_color=1; //default used color

int colorchat()
{
config();

HWND   handle_lfs = FindWindow(0 ,WINDOW_NAME); //get HWND of LFS
HWND   handle_act;

    if(!handle_lfs)  //if no LFS found, error message and exit program
        {
            MessageBox(0,TEXT("Can't open LFS!"),PROG_NAME " " VER,MB_OK|MB_ICONERROR);
            return 0;
        }

    for(;;Sleep(1)) // program loop
    {
          if(FindWindow(0 ,WINDOW_NAME)==NULL)  break;  //if LFS close, exit program

          handle_act = GetForegroundWindow();   //get HWND of active window

          if(handle_act==handle_lfs && GetKeyState(0x54)& 0x80) //if LFS is active and T is pressed
              {
                  press(def_color); //press CTRL+number of color

                  //later to add : if ! or $ is pressed to undo color selection, for proper insim function

                    for(;;Sleep(1)) //wait until LFS textbox is closed
                    {
                        handle_act = GetForegroundWindow();
                        if(handle_act==handle_lfs && (GetKeyState(VK_ESCAPE) |
                                                      GetKeyState(VK_RETURN) |
                                                      GetKeyState(VK_F1)     |
                                                      GetKeyState(VK_F2)     |
                                                      GetKeyState(VK_F3)     |
                                                      GetKeyState(VK_F4)     |
                                                      GetKeyState(VK_F5)     |
                                                      GetKeyState(VK_F6)     |
                                                      GetKeyState(VK_F7)     |
                                                      GetKeyState(VK_F8)     |
                                                      (GetKeyState(VK_CONTROL) | GetKeyState(VK_MENU)) & (GetKeyState(VK_F9) | GetKeyState(VK_F10) | GetKeyState(VK_F11) | GetKeyState(VK_F12))
                                                      )&0x80 )
                            break;  //exit loop when one of this combinations is pressed (ESC, ENTER, F1...F8, ALT or CTRL + F9...F12)
                    }

              }

    }

return 0;
}

int color;
void press()
{
    if(def_color<9)
        color=def_color;
    if(def_color==9)
        color++;
    if(def_color==10)
        color=rand();

            keybd_event(0x11, 0, 0, 0);// press ctrl
            keybd_event(48+color%8, 0, 0, 0);
            Sleep(1);
            keybd_event(48+color%8, 0, 2, 0);
            keybd_event(0x11, 0, 2, 0); //release ctrl
}

void config()
{
FILE *f=fopen(CONFIG_NAME,"r");
    if(f==NULL)
        {
            f=fopen(CONFIG_NAME,"w");
            fprintf(f,"%d"
                      "\n^^^ Write color code up! "
                      "\n #CODES:"
                      "\n # 0  - Black"
                      "\n # 1  - Red"
                      "\n # 2  - Green"
                      "\n # 3  - Yellow"
                      "\n # 4  - Blue"
                      "\n # 5  - Pink"
                      "\n # 6  - Cyan"
                      "\n # 7  - White"
                      "\n # 8  - No color"
                      "\n # 9  - Cylic color change"
                      "\n # 10 - Random color"
                      ,def_color);

        }
    else
        {
            fscanf(f,"%d",&def_color);
        }
    fclose(f);
}
