#define WINDOW_NAME "Live for Speed"
#define NAME "Color Chat"
#define VER "v2"
#define PROGRAM_NAME NAME " " VER
#define CONFIG_NAME "ColorChat.cfg"

#define _WIN32_IE 0x0300

#include <stdio.h>
#include <windows.h>
#include <commctrl.h>
#include "Resource.h"
#include "GUI.h"

void press(HWND lfs, int clr);
void config_read();
void config_write();

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nCmdShow)
{
INITCOMMONCONTROLSEX icc;
icc.dwSize = sizeof(icc);
icc.dwICC = ICC_WIN95_CLASSES;
InitCommonControlsEx(&icc);

    hInst = hThisInstance;
    global_nCmdShow=nCmdShow;

    HWND   handle_lfs = FindWindow(0 ,WINDOW_NAME);
        if(!handle_lfs)
        {
            MessageBox(0,TEXT("Can't open LFS!"),PROGRAM_NAME,MB_OK|MB_ICONERROR);
            return 0;
        }

    config_read();
    _beginthread(GUI,0,0);

    for(;;Sleep(1))
    {
          if(!IsWindow(handle_lfs))  break;  //if LFS close, exit program

          if(handle_lfs==GetForegroundWindow() && GetKeyState('T')&0x80  && CC.work) //if LFS is active and T is pressed
              {
                    if(GetKeyState(VK_SHIFT)&0x80^0x80)
                    press(handle_lfs,CC.color); //press CTRL+number of color

                    for(;;Sleep(1)) //wait until LFS textbox is closed
                    {
                        if(handle_lfs==GetForegroundWindow() && (GetKeyState(VK_ESCAPE) |
                                                                  GetKeyState(VK_RETURN) |
                                                                  GetKeyState(VK_F1)     |
                                                                  GetKeyState(VK_F2)     |
                                                                  GetKeyState(VK_F3)     |
                                                                  GetKeyState(VK_F4)     |
                                                                  GetKeyState(VK_F5)     |
                                                                  GetKeyState(VK_F6)     |
                                                                  GetKeyState(VK_F7)     |
                                                                  GetKeyState(VK_F8)     |
                                                                  (GetKeyState(VK_CONTROL) | GetKeyState(VK_MENU)) & (GetKeyState(VK_F9) | GetKeyState(VK_F10) | GetKeyState(VK_F11) | GetKeyState(VK_F12))
                                                                  )&0x80 )
                            break;  //exit loop when one of this combinations is pressed (ESC, ENTER, F1...F8, ALT or CTRL + F9...F12)
                    }

              }
    }
}

void press(HWND lfs, int clr)
{
    static int color;

    if(clr<8)
        color=clr;
    if(clr==8)
        color++;
    if(clr==9)
        color=rand();

            keybd_event(VK_CONTROL, 0, 0, 0);// press ctrl
            keybd_event(48+color%8, 0, 0, 0);
            Sleep(1);
            keybd_event(48+color%8, 0, 2, 0);
            keybd_event(VK_CONTROL, 0, 2, 0); //release ctrl

}

void config_read()
{
FILE *f=fopen(CONFIG_NAME,"r");
    if(f==NULL)
        {
            f=fopen(CONFIG_NAME,"w");
            fprintf(f,"%d %d",CC.work,CC.color);
            fclose(f);
        }
    else
        {
            fscanf(f,"%d %d",&CC.work,&CC.color);
            fclose(f);
        }
}

void config_write()
{
FILE *f=fopen(CONFIG_NAME,"w");
if(f)
        {
            fprintf(f,"%d %d",CC.work,CC.color);
            fclose(f);
        }
}
