﻿using System;
using System.Linq;
using System.Collections.Generic;

namespace SparkCruise
{
    public static class Dealer
    {
        private static readonly Dictionary<string, int> CarPrices = new Dictionary<string, int>
        {
            { "XFG", 4500 },  
            { "XRG", 6000 },  
            { "FBM", 150000 }, 
            { "XRT", 14000 },  
            { "RB4", 12000 }, 
            { "FXO", 12000 }, 
            { "LX4", 15000 }, 
            { "LX6", 25000 },  
            { "MRT", 30000 },
            { "UF1", 3000 },  
            { "RAC", 30000 }, 
            { "FZ5", 38000 },  
            { "XFR", 50000 },
            { "UFR", 45000 }, 
            { "FOX", 150000 }, 
            { "FO8", 165000 }, 
            { "BF1", 350000 }, 
            { "FXR", 120000 }, 
            { "XRR", 120000 },
            { "FZR", 130000 },
        };

        public static IEnumerable<CarPrice> GetAllPrices()
        {
            return (from c in CarPrices
                    orderby c.Value
                    select new CarPrice { Car = c.Key, Price = c.Value });
        }

        public static int GetCarPrice(string car)
        {
            return CarPrices[car];
        }

        public static bool TryGetPrice(string car, out int price)
        {
            return CarPrices.TryGetValue(car, out price);
        }

        public static bool CarExists(string carname)
        {
            int price;
            return CarPrices.TryGetValue(carname, out price);
        }
    }
}
