﻿using System;
using System.Linq;

namespace SparkCruise
{
    public class UserRepository
    {
        private SparkCruiseEntities _entities = new SparkCruiseEntities();

        public IQueryable<User> GetUsers()
        {
            return _entities.Users;
        }

        public User GetUser(string username)
        {
            return _entities.Users.SingleOrDefault(u => u.Username == username);
        }

        public bool TryGetUser(string username, out User user)
        {
            user = GetUser(username);
            return user != null;
        }

        public void Add(User user)
        {
            _entities.Users.AddObject(user);
        }

        public void Remove(Car car)
        {
            _entities.Cars.DeleteObject(car);
        }

        public void Detach(User user)
        {
            // Detach users car first. 
            foreach (var car in user.Cars.ToList())
            {
                _entities.Detach(car);
            }
            _entities.Detach(user);
        }

        public void Save()
        {
            _entities.SaveChanges();
        }
    }
}
